/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.InternalTraceObjectValue;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public class DBTraceObjectMemoryRegion
implements TraceObjectMemoryRegion,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final RegionChangeTranslator translator;
    private AddressRange range;
    private Lifespan lifespan;

    public DBTraceObjectMemoryRegion(DBTraceObject object) {
        this.object = object;
        this.translator = new RegionChangeTranslator(object, this);
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(this.computeSpan(), name);
        }
    }

    @Override
    public String getName() {
        InternalTraceObjectValue value = this.object.getValue(this.getCreationSnap(), "_display");
        return value == null ? "" : (String)value.getValue();
    }

    @Override
    public void setLifespan(Lifespan newLifespan) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            TraceObjectInterfaceUtils.setLifespan(TraceObjectMemoryRegion.class, this.object, newLifespan);
            this.lifespan = newLifespan;
        }
    }

    @Override
    public Lifespan getLifespan() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Lifespan computed = this.computeSpan();
            if (computed != null) {
                this.lifespan = computed;
            }
            Lifespan lifespan = this.lifespan;
            return lifespan;
        }
    }

    @Override
    public void setCreationSnap(long creationSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(Lifespan.span(creationSnap, this.getDestructionSnap()));
        }
    }

    @Override
    public long getCreationSnap() {
        return this.computeMinSnap();
    }

    @Override
    public void setDestructionSnap(long destructionSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(Lifespan.span(this.getCreationSnap(), destructionSnap));
        }
    }

    @Override
    public long getDestructionSnap() {
        return this.computeMaxSnap();
    }

    @Override
    public void setRange(Lifespan lifespan, AddressRange newRange) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_range", newRange);
            this.range = newRange;
        }
    }

    @Override
    public void setRange(AddressRange newRange) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(this.computeSpan(), newRange);
        }
    }

    @Override
    public AddressRange getRange() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            if (this.object.getLife().isEmpty()) {
                AddressRange addressRange = this.range;
                return addressRange;
            }
            AddressRange addressRange = this.range = TraceObjectInterfaceUtils.getValue(this.object, this.getCreationSnap(), "_range", AddressRange.class, this.range);
            return addressRange;
        }
    }

    @Override
    public void setMinAddress(Address min) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(DBTraceUtils.toRange(min, this.getMaxAddress()));
        }
    }

    @Override
    public Address getMinAddress() {
        AddressRange range = this.getRange();
        return range == null ? null : range.getMinAddress();
    }

    @Override
    public void setMaxAddress(Address max) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(DBTraceUtils.toRange(this.getMinAddress(), max));
        }
    }

    @Override
    public Address getMaxAddress() {
        AddressRange range = this.getRange();
        return range == null ? null : range.getMaxAddress();
    }

    @Override
    public void setLength(long length) throws AddressOverflowException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange((AddressRange)new AddressRangeImpl(this.getMinAddress(), length));
        }
    }

    @Override
    public long getLength() {
        return this.getRange().getLength();
    }

    protected static String keyForFlag(TraceMemoryFlag flag) {
        switch (flag) {
            case READ: {
                return "_readable";
            }
            case WRITE: {
                return "_writable";
            }
            case EXECUTE: {
                return "_executable";
            }
            case VOLATILE: {
                return "_volatile";
            }
        }
        throw new AssertionError();
    }

    @Override
    public void setFlags(Lifespan lifespan, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            for (TraceMemoryFlag flag : TraceMemoryFlag.values()) {
                Boolean val = flags.contains((Object)flag) ? Boolean.valueOf(true) : null;
                this.object.setValue(lifespan, DBTraceObjectMemoryRegion.keyForFlag(flag), val);
            }
        }
    }

    @Override
    public void addFlags(Lifespan lifespan, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            for (TraceMemoryFlag flag : flags) {
                this.object.setValue(lifespan, DBTraceObjectMemoryRegion.keyForFlag(flag), true);
            }
        }
    }

    @Override
    public void clearFlags(Lifespan lifespan, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            for (TraceMemoryFlag flag : flags) {
                this.object.setValue(lifespan, DBTraceObjectMemoryRegion.keyForFlag(flag), null);
            }
        }
    }

    @Override
    public void setFlags(Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setFlags(this.getLifespan(), flags);
        }
    }

    @Override
    public void addFlags(Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.addFlags(this.getLifespan(), flags);
        }
    }

    @Override
    public void clearFlags(Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.clearFlags(this.getLifespan(), flags);
        }
    }

    @Override
    public Set<TraceMemoryFlag> getFlags(long snap) {
        EnumSet<TraceMemoryFlag> result = EnumSet.noneOf(TraceMemoryFlag.class);
        for (TraceMemoryFlag flag : TraceMemoryFlag.values()) {
            if (this.object.getValue(snap, DBTraceObjectMemoryRegion.keyForFlag(flag)) == null) continue;
            result.add(flag);
        }
        return result;
    }

    @Override
    public Set<TraceMemoryFlag> getFlags() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Set<TraceMemoryFlag> set = this.getFlags(this.getCreationSnap());
            return set;
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(this.computeSpan());
        }
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected void updateViewsAdded() {
        this.object.getTrace().updateViewsAddRegionBlock(this);
    }

    protected void updateViewsLifespanChanged(Lifespan oldLifespan, Lifespan newLifespan) {
        this.object.getTrace().updateViewsChangeRegionBlockLifespan(this, oldLifespan, newLifespan);
    }

    protected void updateViewsValueChanged(Lifespan lifespan, String key, Object oldValue, Object newValue) {
        DBTrace trace = this.object.getTrace();
        switch (key) {
            case "_range": {
                trace.updateViewsRefreshBlocks();
                return;
            }
            case "_display": {
                trace.updateViewsChangeRegionBlockName(this);
                return;
            }
            case "_readable": 
            case "_writable": 
            case "_executable": {
                trace.updateViewsChangeRegionBlockFlags(this, lifespan);
                return;
            }
        }
    }

    protected void updateViewsDeleted() {
        this.object.getTrace().updateViewsDeleteRegionBlock(this);
    }

    protected class RegionChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceMemoryRegion> {
        protected RegionChangeTranslator(DBTraceObject object, TraceMemoryRegion iface) {
            super("_range", object, iface);
        }

        @Override
        protected TraceChangeType<TraceMemoryRegion, Void> getAddedType() {
            return Trace.TraceMemoryRegionChangeType.ADDED;
        }

        @Override
        protected TraceChangeType<TraceMemoryRegion, Lifespan> getLifespanChangedType() {
            return Trace.TraceMemoryRegionChangeType.LIFESPAN_CHANGED;
        }

        @Override
        protected TraceChangeType<TraceMemoryRegion, Void> getChangedType() {
            return Trace.TraceMemoryRegionChangeType.CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return "_range".equals(key) || "_display".equals(key) || "_readable".equals(key) || "_writable".equals(key) || "_executable".equals(key);
        }

        @Override
        protected TraceChangeType<TraceMemoryRegion, Void> getDeletedType() {
            return Trace.TraceMemoryRegionChangeType.DELETED;
        }

        @Override
        protected void emitExtraAdded() {
            DBTraceObjectMemoryRegion.this.updateViewsAdded();
        }

        @Override
        protected void emitExtraLifespanChanged(Lifespan oldLifespan, Lifespan newLifespan) {
            DBTraceObjectMemoryRegion.this.updateViewsLifespanChanged(oldLifespan, newLifespan);
        }

        @Override
        protected void emitExtraValueChanged(Lifespan lifespan, String key, Object oldValue, Object newValue) {
            DBTraceObjectMemoryRegion.this.updateViewsValueChanged(lifespan, key, oldValue, newValue);
        }

        @Override
        protected void emitExtraDeleted() {
            DBTraceObjectMemoryRegion.this.updateViewsDeleted();
        }
    }
}

