/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import generic.NestedIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkType;
import ghidra.trace.database.bookmark.DBTraceBookmark;
import ghidra.trace.database.bookmark.DBTraceBookmarkManager;
import ghidra.trace.database.bookmark.DBTraceBookmarkSpace;
import ghidra.trace.database.bookmark.DBTraceBookmarkType;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceProgramViewBookmarkManager;
import ghidra.util.LockHold;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.apache.commons.collections4.IteratorUtils;

public class DBTraceProgramViewBookmarkManager
implements TraceProgramViewBookmarkManager {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final Bookmark[] EMPTY_BOOKMARK_ARRAY = new Bookmark[0];
    protected final DBTraceProgramView program;
    protected final DBTraceBookmarkManager bookmarkManager;

    public DBTraceProgramViewBookmarkManager(DBTraceProgramView program) {
        this.program = program;
        this.bookmarkManager = program.trace.getBookmarkManager();
    }

    public BookmarkType defineType(String type, Icon icon, Color color, int priority) {
        return this.bookmarkManager.defineBookmarkType(type, icon, color, priority);
    }

    public BookmarkType[] getBookmarkTypes() {
        Collection<? extends DBTraceBookmarkType> types = this.bookmarkManager.getDefinedBookmarkTypes();
        return types.toArray(new BookmarkType[types.size()]);
    }

    public BookmarkType getBookmarkType(String type) {
        return this.bookmarkManager.getBookmarkType(type);
    }

    public String[] getCategories(String type) {
        DBTraceBookmarkType bmt = this.bookmarkManager.getBookmarkType(type);
        if (bmt == null) {
            return EMPTY_STRING_ARRAY;
        }
        Collection<String> categories = bmt.getCategories();
        return categories.toArray(new String[categories.size()]);
    }

    public Bookmark setBookmark(Address addr, String type, String category, String comment) {
        try (LockHold hold = this.program.trace.lockWrite();){
            DBTraceBookmarkType bmt = this.bookmarkManager.getOrDefineBookmarkType(type);
            DBTraceBookmarkSpace space = this.bookmarkManager.getBookmarkSpace(addr.getAddressSpace(), true);
            TraceBookmark traceBookmark = space.addBookmark(Lifespan.nowOn(this.program.snap), addr, (TraceBookmarkType)bmt, category, comment);
            return traceBookmark;
        }
    }

    public Bookmark getBookmark(Address addr, String type, String category) {
        try (LockHold hold = this.program.trace.lockRead();){
            DBTraceBookmarkSpace space = this.bookmarkManager.getBookmarkSpace(addr.getAddressSpace(), false);
            if (space == null) {
                Bookmark bookmark = null;
                return bookmark;
            }
            for (long s : this.program.viewport.getOrderedSnaps()) {
                for (TraceBookmark traceBookmark : space.getBookmarksAt(s, addr)) {
                    if (!type.equals(traceBookmark.getTypeString()) || !category.equals(traceBookmark.getCategory())) continue;
                    TraceBookmark traceBookmark2 = traceBookmark;
                    return traceBookmark2;
                }
            }
            Iterator<Long> iterator = null;
            return iterator;
        }
    }

    protected void doDeleteOrTruncateLifespan(TraceBookmark bm) {
        Lifespan lifespan = bm.getLifespan();
        if (!lifespan.contains(this.program.snap)) {
            throw new IllegalArgumentException("Given bookmark is not present at this view's snap");
        }
        if (lifespan.lmin() == this.program.snap) {
            bm.delete();
        } else {
            bm.setLifespan((Lifespan)lifespan.intersect(Lifespan.before(this.program.snap)));
        }
    }

    public void removeBookmark(Bookmark bookmark) {
        if (!(bookmark instanceof DBTraceBookmark)) {
            throw new IllegalArgumentException("Given bookmark is not part of this trace");
        }
        DBTraceBookmark dbBookmark = (DBTraceBookmark)bookmark;
        if (dbBookmark.getTrace() != this.program.trace) {
            throw new IllegalArgumentException("Given bookmark is not part of this trace");
        }
        this.doDeleteOrTruncateLifespan(dbBookmark);
    }

    public void removeBookmarks(String type) {
        try (LockHold hold = this.program.trace.lockWrite();){
            for (DBTraceBookmark bm : this.bookmarkManager.getBookmarksByType(type)) {
                if (!bm.getLifespan().contains(this.program.snap)) continue;
                this.doDeleteOrTruncateLifespan(bm);
            }
        }
    }

    public void removeBookmarks(String type, String category, TaskMonitor monitor) throws CancelledException {
        try (LockHold hold = this.program.trace.lockWrite();){
            Collection<DBTraceBookmark> bookmarks = this.bookmarkManager.getBookmarksByType(type);
            monitor.initialize((long)bookmarks.size());
            for (DBTraceBookmark bm : bookmarks) {
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
                if (!bm.getLifespan().contains(this.program.snap) || !category.equals(bm.getCategory())) continue;
                this.doDeleteOrTruncateLifespan(bm);
            }
        }
    }

    protected void doRemoveByAddressSet(AddressSetView set, TaskMonitor monitor, Predicate<? super TraceBookmark> predicate) throws CancelledException {
        try (LockHold hold = this.program.trace.lockWrite();){
            monitor.initialize(set.getNumAddresses());
            for (AddressRange rng : set) {
                monitor.checkCancelled();
                monitor.incrementProgress(rng.getLength());
                DBTraceBookmarkSpace space = this.bookmarkManager.getBookmarkSpace(rng.getAddressSpace(), false);
                if (space == null) continue;
                for (TraceBookmark traceBookmark : space.getBookmarksIntersecting(Lifespan.at(this.program.snap), rng)) {
                    monitor.checkCancelled();
                    if (!traceBookmark.getLifespan().contains(this.program.snap) || !predicate.test(traceBookmark)) continue;
                    this.doDeleteOrTruncateLifespan(traceBookmark);
                }
            }
        }
    }

    public void removeBookmarks(AddressSetView set, TaskMonitor monitor) throws CancelledException {
        this.doRemoveByAddressSet(set, monitor, bm -> true);
    }

    public void removeBookmarks(AddressSetView set, String type, TaskMonitor monitor) throws CancelledException {
        this.doRemoveByAddressSet(set, monitor, bm -> type.equals(bm.getTypeString()));
    }

    public void removeBookmarks(AddressSetView set, String type, String category, TaskMonitor monitor) throws CancelledException {
        this.doRemoveByAddressSet(set, monitor, bm -> type.equals(bm.getTypeString()) && category.equals(bm.getCategory()));
    }

    public Bookmark[] getBookmarks(Address addr) {
        try (LockHold hold = this.program.trace.lockRead();){
            DBTraceBookmarkSpace space = this.bookmarkManager.getBookmarkSpace(addr.getAddressSpace(), false);
            if (space == null) {
                Bookmark[] bookmarkArray = EMPTY_BOOKMARK_ARRAY;
                return bookmarkArray;
            }
            ArrayList<TraceBookmark> list = new ArrayList<TraceBookmark>();
            Bookmark[] bookmarkArray = this.program.viewport.getOrderedSnaps().iterator();
            while (bookmarkArray.hasNext()) {
                long s = bookmarkArray.next();
                for (TraceBookmark traceBookmark : space.getBookmarksAt(s, addr)) {
                    if (!traceBookmark.getLifespan().contains(this.program.snap)) continue;
                    list.add(traceBookmark);
                }
            }
            bookmarkArray = list.toArray(new Bookmark[list.size()]);
            return bookmarkArray;
        }
    }

    public Bookmark[] getBookmarks(Address address, String type) {
        try (LockHold hold = this.program.trace.lockRead();){
            DBTraceBookmarkSpace space = this.bookmarkManager.getBookmarkSpace(address.getAddressSpace(), false);
            if (space == null) {
                Bookmark[] bookmarkArray = EMPTY_BOOKMARK_ARRAY;
                return bookmarkArray;
            }
            ArrayList<TraceBookmark> list = new ArrayList<TraceBookmark>();
            Bookmark[] bookmarkArray = this.program.viewport.getOrderedSnaps().iterator();
            while (bookmarkArray.hasNext()) {
                long s = bookmarkArray.next();
                for (TraceBookmark traceBookmark : space.getBookmarksAt(s, address)) {
                    if (!type.equals(traceBookmark.getTypeString())) continue;
                    list.add(traceBookmark);
                }
            }
            bookmarkArray = list.toArray(new Bookmark[list.size()]);
            return bookmarkArray;
        }
    }

    public AddressSetView getBookmarkAddresses(String type) {
        try (LockHold hold = this.program.trace.lockRead();){
            AddressSet result = new AddressSet();
            DBTraceBookmarkType bmt = this.bookmarkManager.getBookmarkType(type);
            if (bmt == null) {
                AddressSet addressSet = result;
                return addressSet;
            }
            for (TraceBookmark bm : bmt.getBookmarks()) {
                if (bm.getAddress().getAddressSpace().isRegisterSpace() || !this.program.viewport.containsAnyUpper(bm.getLifespan())) continue;
                result.add(bm.getAddress());
            }
            AddressSet addressSet = result;
            return addressSet;
        }
    }

    protected static <T, U extends T> Iterator<T> filteredIterator(Iterator<U> it, Predicate<? super U> predicate) {
        return IteratorUtils.filteredIterator(it, e -> predicate.test((Object)e));
    }

    public Iterator<Bookmark> getBookmarksIterator(String type) {
        DBTraceBookmarkType bmt = this.bookmarkManager.getBookmarkType(type);
        if (bmt == null) {
            return Collections.emptyIterator();
        }
        return DBTraceProgramViewBookmarkManager.filteredIterator(bmt.getBookmarks().iterator(), bm -> !bm.getAddress().getAddressSpace().isRegisterSpace() && this.program.viewport.containsAnyUpper(bm.getLifespan()));
    }

    public Iterator<Bookmark> getBookmarksIterator() {
        return NestedIterator.start(this.bookmarkManager.getActiveMemorySpaces().iterator(), space -> DBTraceProgramViewBookmarkManager.filteredIterator(space.getAllBookmarks().iterator(), bm -> this.program.viewport.containsAnyUpper(bm.getLifespan())));
    }

    protected Comparator<Bookmark> getBookmarkComparator(boolean forward) {
        return forward ? (b1, b2) -> b1.getAddress().compareTo((Object)b2.getAddress()) : (b1, b2) -> -b1.getAddress().compareTo((Object)b2.getAddress());
    }

    public Iterator<Bookmark> getBookmarksIterator(Address startAddress, boolean forward) {
        AddressFactory factory = this.program.getAddressFactory();
        AddressSet allMemory = factory.getAddressSet();
        AddressSet within = forward ? factory.getAddressSet(startAddress, allMemory.getMaxAddress()) : factory.getAddressSet(allMemory.getMinAddress(), startAddress);
        return NestedIterator.start((Iterator)within.iterator(forward), rng -> {
            DBTraceBookmarkSpace space = this.bookmarkManager.getBookmarkSpace(rng.getAddressSpace(), false);
            if (space == null) {
                return Collections.emptyIterator();
            }
            return this.program.viewport.mergedIterator(s -> space.getBookmarksIntersecting(Lifespan.at(s), (AddressRange)rng).iterator(), this.getBookmarkComparator(forward));
        });
    }

    public Bookmark getBookmark(long id) {
        DBTraceBookmark bm = this.bookmarkManager.getBookmark(id);
        if (bm == null || !bm.getLifespan().contains(this.program.snap)) {
            return null;
        }
        return bm;
    }

    public boolean hasBookmarks(String type) {
        return this.bookmarkManager.getOrDefineBookmarkType(type).hasBookmarks();
    }

    public int getBookmarkCount(String type) {
        return this.bookmarkManager.getOrDefineBookmarkType(type).countBookmarks();
    }

    public int getBookmarkCount() {
        int sum = 0;
        for (DBTraceBookmarkSpace space : this.bookmarkManager.getActiveMemorySpaces()) {
            sum += space.getAllBookmarks().size();
        }
        return sum;
    }

    @Override
    public Trace getTrace() {
        return this.program.trace;
    }

    @Override
    public long getSnap() {
        return this.program.snap;
    }

    @Override
    public TraceProgramView getProgram() {
        return this.program;
    }
}

