/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialogBuilder;
import generic.theme.GIcon;
import ghidra.framework.main.datatable.FrontendProjectTreeAction;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.main.projectdata.actions.CountDomainFilesTask;
import ghidra.framework.main.projectdata.actions.DeleteProjectFilesTask;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.HTMLUtilities;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.Set;
import javax.swing.Icon;
import util.CollectionUtils;

public class ProjectDataDeleteAction
extends FrontendProjectTreeAction {
    private static final Icon ICON = new GIcon("icon.projectdata.delete");

    public ProjectDataDeleteAction(String owner, String group) {
        super("Delete", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Delete"}, ICON, group));
        this.setKeyBindingData(new KeyBindingData(127, 0));
        this.markHelpUnnecessary();
    }

    protected void actionPerformed(ProjectDataContext context) {
        Set files = CollectionUtils.asSet(context.getSelectedFiles());
        Set folders = CollectionUtils.asSet(context.getSelectedFolders());
        CountDomainFilesTask countTask = new CountDomainFilesTask(folders, files);
        new TaskLauncher((Task)countTask, context.getComponent(), 750);
        if (countTask.wasCancelled()) {
            return;
        }
        int fileCount = countTask.getFileCount();
        if (!this.confirmDelete(fileCount, files, context.getComponent())) {
            return;
        }
        DeleteProjectFilesTask deleteTask = this.createDeleteTask(context, files, folders, fileCount);
        TaskLauncher.launch((Task)deleteTask);
    }

    DeleteProjectFilesTask createDeleteTask(ProjectDataContext context, Set<DomainFile> files, Set<DomainFolder> folders, int fileCount) {
        return new DeleteProjectFilesTask(folders, files, fileCount, context.getComponent());
    }

    private boolean confirmDelete(int fileCount, Set<DomainFile> files, Component parent) {
        String message = this.getMessage(fileCount, files);
        OptionDialogBuilder builder = new OptionDialogBuilder("Confirm Delete", message);
        builder.addOption("OK").addCancel().setMessageType(3);
        return builder.show(parent) != 0;
    }

    private String getMessage(int fileCount, Set<DomainFile> selectedFiles) {
        if (fileCount == 0) {
            return "Are you sure you want to delete the selected empty folder(s)?";
        }
        if (fileCount == 1) {
            if (!selectedFiles.isEmpty()) {
                DomainFile file = (DomainFile)CollectionUtils.any(selectedFiles);
                return "<HTML>Are you sure you want to <B><U>permanently</U></B> delete \"" + HTMLUtilities.escapeHTML((String)file.getName()) + "\"?";
            }
            return "<HTML>Are you sure you want to <B><U>permanently</U></B> delete the  selected files and folders?";
        }
        return "<HTML>Are you sure you want to <B><U>permanently</U></B> delete the " + fileCount + " selected files?";
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataContext context) {
        if (!context.hasOneOrMoreFilesAndFolders()) {
            return false;
        }
        if (context.isReadOnlyProject()) {
            return false;
        }
        return !context.containsRootFolder();
    }
}

