/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.control;

import docking.ActionContext;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.actions.PopupActionProvider;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.services.ControlMode;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathPredicates;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.target.TraceObject;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@PluginInfo(shortDescription="Debugger model method actions", description="Adds context actions to the GUI, generically, based on the model's methods", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={}, servicesRequired={DebuggerStaticMappingService.class})
public class DebuggerMethodActionsPlugin
extends Plugin
implements PopupActionProvider {
    public static final String GROUP_METHODS = "Debugger Methods";
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    @AutoServiceConsumed
    private DebuggerControlService controlService;
    private final AutoService.Wiring autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);

    private static String getDisplay(TargetMethod method) {
        String display = method.getDisplay();
        if (display != null) {
            return display;
        }
        return method.getName();
    }

    public DebuggerMethodActionsPlugin(PluginTool tool) {
        super(tool);
        tool.addPopupActionProvider((PopupActionProvider)this);
    }

    protected boolean isControlTarget() {
        if (this.controlService == null || this.traceManager == null) {
            return true;
        }
        Trace trace = this.traceManager.getCurrentTrace();
        if (trace == null) {
            return true;
        }
        ControlMode mode = this.controlService.getCurrentMode(trace);
        return mode.isTarget();
    }

    public List<DockingActionIf> getPopupActions(Tool tool, ActionContext context) {
        if (!this.isControlTarget()) {
            return List.of();
        }
        TargetObject curObj = this.getCurrentTargetObject();
        if (curObj == null) {
            return List.of();
        }
        ArrayList<DockingActionIf> result = new ArrayList<DockingActionIf>();
        PathPredicates matcher = curObj.getModel().getRootSchema().matcherForSuitable(TargetMethod.class, curObj.getPath());
        for (TargetObject obj : matcher.getCachedSuccessors(curObj.getModel().getModelRoot()).values()) {
            TargetMethod method;
            Map<String, Object> arguments;
            if (!(obj instanceof TargetMethod) || (arguments = this.collectArguments((method = (TargetMethod)obj).getParameters(), context)) == null) continue;
            result.add((DockingActionIf)new InvokeMethodAction(method));
        }
        return result;
    }

    private TargetObject getCurrentTargetObject() {
        if (this.traceManager == null) {
            return null;
        }
        DebuggerCoordinates current = this.traceManager.getCurrent();
        TraceRecorder recorder = current.getRecorder();
        if (recorder == null) {
            return null;
        }
        TraceObject object = current.getObject();
        if (object != null) {
            return recorder.getTargetObject(object);
        }
        return recorder.getFocus();
    }

    private Address dynamicAddress(ProgramLocation loc) {
        if (loc.getProgram() instanceof TraceProgramView) {
            return loc.getAddress();
        }
        if (this.traceManager == null) {
            return null;
        }
        ProgramLocation dloc = this.mappingService.getDynamicLocationFromStatic(this.traceManager.getCurrentView(), loc);
        if (dloc == null) {
            return null;
        }
        return dloc.getByteAddress();
    }

    private Map<String, Object> collectArguments(TargetMethod.TargetParameterMap params, ActionContext context) {
        Object address;
        TargetMethod.ParameterDescription addrParam = null;
        for (TargetMethod.ParameterDescription p : params.values()) {
            if (p.type == Address.class) {
                if (addrParam != null) {
                    return null;
                }
                addrParam = p;
                continue;
            }
            if (!p.required || p.defaultValue != null) continue;
            return null;
        }
        if (addrParam == null) {
            return null;
        }
        if (context instanceof ProgramLocationActionContext) {
            ProgramLocationActionContext ctx = (ProgramLocationActionContext)context;
            address = this.dynamicAddress(ctx.getLocation());
            if (address == null) {
                return null;
            }
            return Map.of(addrParam.name, address);
        }
        address = context.getContextObject();
        if (address instanceof MarkerLocation) {
            MarkerLocation ml = (MarkerLocation)address;
            if ((address = this.dynamicAddress(new ProgramLocation(ml.getProgram(), ml.getAddr()))) == null) {
                return null;
            }
            return Map.of(addrParam.name, address);
        }
        return null;
    }

    class InvokeMethodAction
    extends DockingAction {
        private final TargetMethod method;

        public InvokeMethodAction(TargetMethod method) {
            super(DebuggerMethodActionsPlugin.getDisplay(method), DebuggerMethodActionsPlugin.this.getName());
            this.method = method;
            this.setPopupMenuData(new MenuData(new String[]{this.getName()}, DebuggerMethodActionsPlugin.GROUP_METHODS));
        }

        public void actionPerformed(ActionContext context) {
            Map<String, Object> arguments = DebuggerMethodActionsPlugin.this.collectArguments(this.method.getParameters(), context);
            if (arguments == null) {
                return;
            }
            ((CompletableFuture)this.method.invoke(arguments).thenAccept(result -> {
                if (DebuggerMethodActionsPlugin.this.consoleService != null && this.method.getReturnType() != Void.class) {
                    DebuggerMethodActionsPlugin.this.consoleService.log(null, DebuggerMethodActionsPlugin.getDisplay(this.method) + " returned " + result);
                }
            })).exceptionally(ex -> {
                DebuggerMethodActionsPlugin.this.tool.setStatusInfo("Invocation of " + DebuggerMethodActionsPlugin.getDisplay(this.method) + " failed: " + ex.getMessage(), true);
                Msg.error((Object)((Object)this), (Object)("Invocation of " + this.method.getPath() + " failed"), (Throwable)ex);
                return null;
            });
        }
    }
}

