/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memview;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingActionIf;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.memview.DebuggerMemviewPlugin;
import ghidra.app.plugin.core.debug.gui.memview.MemoryBox;
import ghidra.app.plugin.core.debug.gui.memview.MemviewPanel;
import ghidra.app.plugin.core.debug.gui.memview.MemviewTable;
import ghidra.app.plugin.core.debug.gui.memview.actions.ZoomInAAction;
import ghidra.app.plugin.core.debug.gui.memview.actions.ZoomInTAction;
import ghidra.app.plugin.core.debug.gui.memview.actions.ZoomOutAAction;
import ghidra.app.plugin.core.debug.gui.memview.actions.ZoomOutTAction;
import ghidra.app.services.DebuggerListingService;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class MemviewProvider
extends ComponentProviderAdapter {
    private static final String TITLE = "Memview";
    private AutoService.Wiring autoServiceWiring;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    private DebuggerMemviewPlugin plugin;
    private JComponent mainPanel;
    private MemviewPanel memviewPanel;
    private MemviewTable memviewTable;
    private JScrollPane scrollPane;
    private boolean vertical = true;
    private boolean applyFilter = true;
    private double zoomAmountA = 1.0;
    private double zoomAmountT = 1.0;
    long halfPage = 512L;

    public MemviewProvider(PluginTool tool, DebuggerMemviewPlugin plugin) {
        super(tool, TITLE, plugin.getName());
        this.plugin = plugin;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setWindowMenuGroup("Debugger");
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MemviewProvider.this.resized();
            }
        });
        tool.addComponentProvider((ComponentProvider)this, false);
        this.createActions();
        this.buildPanel();
    }

    private void createActions() {
        ZoomInAAction zoomInAAction = new ZoomInAAction(this);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)zoomInAAction);
        ZoomOutAAction zoomOutAAction = new ZoomOutAAction(this);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)zoomOutAAction);
        ZoomInTAction zoomInTAction = new ZoomInTAction(this);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)zoomInTAction);
        ZoomOutTAction zoomOutTAction = new ZoomOutTAction(this);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)zoomOutTAction);
        ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle Layout", this.plugin.getName()).toolBarIcon(DebuggerResources.AbstractRefreshAction.ICON)).helpLocation(new HelpLocation(this.plugin.getName(), "toggle_layout"))).onAction(ctx -> this.performToggleLayout((ActionContext)ctx))).buildAndInstallLocal((ComponentProvider)this);
        ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle Process Trace", this.plugin.getName()).toolBarIcon(DebuggerResources.ICON_SYNC)).helpLocation(new HelpLocation(this.plugin.getName(), "toggle_process_trace"))).onAction(ctx -> this.performToggleTrace((ActionContext)ctx))).selected(false).buildAndInstallLocal((ComponentProvider)this);
        ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Apply Filter To Panel", this.plugin.getName()).toolBarIcon(DebuggerResources.ICON_FILTER)).helpLocation(new HelpLocation(this.plugin.getName(), "apply_to_panel"))).onAction(ctx -> this.performApplyFilterToPanel((ActionContext)ctx))).selected(true).buildAndInstallLocal((ComponentProvider)this);
    }

    void buildPanel() {
        this.mainPanel.removeAll();
        this.memviewPanel = new MemviewPanel(this);
        this.memviewTable = new MemviewTable(this);
        this.scrollPane = new JScrollPane(this.memviewPanel);
        this.scrollPane.setPreferredSize(this.memviewPanel.getSize());
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setRightComponent(this.scrollPane);
        splitPane.setLeftComponent(this.memviewTable.getComponent());
        splitPane.setDividerLocation(0.5);
        this.mainPanel.add((Component)splitPane, "Center");
        this.setDirection();
        this.mainPanel.validate();
    }

    private void performToggleLayout(ActionContext ctx) {
        this.vertical = !this.vertical;
        this.setDirection();
        this.refresh();
    }

    private void performToggleTrace(ActionContext ctx) {
        this.plugin.toggleTrackTrace();
    }

    private void performApplyFilterToPanel(ActionContext ctx) {
        this.applyFilter = !this.isApplyFilter();
        this.applyFilter();
    }

    public void applyFilter() {
        if (this.applyFilter) {
            this.memviewTable.applyFilter();
        } else {
            this.memviewPanel.setBoxes(this.memviewTable.getBoxes());
        }
        this.refresh();
    }

    private void setDirection() {
        this.memviewPanel.setVerticalMode(this.vertical);
    }

    void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this);
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (event != null && event.getSource() == this.mainPanel) {
            return new ActionContext((ComponentProvider)this, (Component)this.mainPanel);
        }
        if (event != null && event.getSource() == this.memviewPanel) {
            return new ActionContext((ComponentProvider)this, (Component)this.memviewPanel);
        }
        return null;
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.plugin.getName());
    }

    public void setProgram(Program program) {
        this.memviewTable.setProgram(program);
    }

    public void initViews() {
        this.memviewPanel.initViews();
        this.memviewPanel.setPreferredSize(new Dimension(300, 100));
        this.memviewTable.setListingService(this.listingService);
        this.mainPanel.doLayout();
        this.mainPanel.repaint();
    }

    public void refresh() {
        String subTitle = " (" + this.zoomAmountA + "x:" + this.zoomAmountT + ") ";
        subTitle = subTitle + this.memviewPanel.getTitleAnnotation();
        this.setSubTitle(subTitle);
        this.memviewPanel.refresh();
        this.scrollPane.getViewport().doLayout();
    }

    public void goTo(int x, int y) {
        Rectangle bounds = this.scrollPane.getBounds();
        this.scrollPane.getViewport().scrollRectToVisible(new Rectangle(x, y, bounds.width, bounds.height));
        this.scrollPane.getViewport().doLayout();
    }

    public void goTo(MemoryBox box) {
        Point p = new Point(box.getX(this.vertical) - 10, box.getY(this.vertical) - 10);
        Point p0 = this.scrollPane.getViewport().getViewPosition();
        int w = this.scrollPane.getViewport().getWidth();
        int h = this.scrollPane.getViewport().getHeight();
        if (p.x > p0.x && p.x < p0.x + w && p.y > p0.y && p.y < p0.y + h) {
            return;
        }
        this.scrollPane.getViewport().setViewPosition(p);
    }

    public void selectTableEntry(Set<MemoryBox> boxes) {
        this.memviewTable.setSelection(boxes);
    }

    public void selectPanelPosition(Set<MemoryBox> boxes) {
        this.memviewPanel.setSelection(boxes);
        if (boxes.size() == 1) {
            Iterator<MemoryBox> iterator = boxes.iterator();
            this.goTo(iterator.next());
        }
    }

    public void changeZoomA(int changeAmount) {
        this.zoomAmountA = (float)(this.zoomAmountA * Math.pow(2.0, changeAmount));
        this.memviewPanel.scaleCurrentPixelAddr(changeAmount);
    }

    public double getZoomAmountA() {
        return this.zoomAmountA;
    }

    public void changeZoomT(int changeAmount) {
        this.zoomAmountT = (float)(this.zoomAmountT * Math.pow(2.0, changeAmount));
        this.memviewPanel.scaleCurrentPixelTime(changeAmount);
    }

    public double getZoomAmountT() {
        return this.zoomAmountT;
    }

    void resized() {
        this.memviewPanel.refresh();
    }

    public void setBoxes(List<MemoryBox> blist) {
        Swing.runIfSwingOrRunLater(() -> {
            this.memviewTable.setBoxes(blist);
            this.memviewTable.applyFilter();
        });
    }

    public void setBoxesInPanel(List<MemoryBox> blist) {
        Swing.runIfSwingOrRunLater(() -> {
            this.memviewPanel.setBoxes(blist);
            this.memviewPanel.refresh();
        });
    }

    public void addBox(MemoryBox box) {
        ArrayList<MemoryBox> blist = new ArrayList<MemoryBox>();
        blist.add(box);
        this.addBoxes(blist);
    }

    public void addBoxes(List<MemoryBox> blist) {
        Swing.runIfSwingOrRunLater(() -> {
            this.memviewTable.addBoxes(blist);
            this.memviewTable.applyFilter();
        });
    }

    public boolean isApplyFilter() {
        return this.applyFilter;
    }

    public void reset() {
        Swing.runIfSwingOrRunLater(() -> {
            this.memviewTable.reset();
            this.memviewPanel.reset();
        });
    }
}

