/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memview;

import docking.widgets.filter.FilterListener;
import docking.widgets.table.RowObjectTableModel;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.memview.MemoryBox;
import ghidra.app.plugin.core.debug.gui.memview.MemviewMapModel;
import ghidra.app.plugin.core.debug.gui.memview.MemviewProvider;
import ghidra.app.services.DebuggerListingService;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Program;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class MemviewTable {
    public static final Icon ICON_TABLE = new GIcon("icon.table");
    private MemviewMapModel model;
    private GhidraTable table;
    private GhidraTableFilterPanel<?> filterPanel;
    private FilterListener filterListener;
    private SwingUpdateManager applyFilterManager = new SwingUpdateManager(this::applyFilter);
    private JPanel component;
    private MemviewProvider provider;
    private Program program;
    private DebuggerListingService listingService;

    public MemviewTable(MemviewProvider provider) {
        this.provider = provider;
        this.model = new MemviewMapModel(provider);
        this.table = new GhidraTable((TableModel)((Object)this.model));
        this.table.setHTMLRenderingEnabled(true);
        this.component = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        this.filterPanel = new GhidraTableFilterPanel((JTable)this.table, (RowObjectTableModel)this.model);
        this.component.add((Component)scrollPane, "Center");
        this.component.add((Component)this.filterPanel, "South");
        this.table.setAutoscrolls(true);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int modelRow = this.filterPanel.getModelRow(this.table.getSelectedRow());
            MemoryBox box = this.model.getBoxAt(modelRow);
            if (box != null) {
                HashSet<MemoryBox> boxes = new HashSet<MemoryBox>();
                boxes.add(box);
                provider.selectPanelPosition(boxes);
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MemviewTable.this.navigateToSelectedObject();
                }
            }
        });
        this.filterListener = new FilterActionFilterListener();
        this.filterPanel.addFilterChagnedListener(this.filterListener);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public JComponent getPrincipalComponent() {
        return this.table;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public void setListingService(DebuggerListingService listingService) {
        this.listingService = listingService;
    }

    public void setBoxes(Collection<MemoryBox> blist) {
        this.model.setBoxes(blist);
    }

    public void addBoxes(Collection<MemoryBox> blist) {
        this.model.addBoxes(blist);
    }

    public void reset() {
        this.model.reset();
    }

    public List<MemoryBox> getBoxes() {
        return this.model.getBoxes();
    }

    public void setSelection(Set<MemoryBox> set) {
        this.table.clearSelection();
        for (MemoryBox box : set) {
            int index = this.model.getIndexForBox(box);
            int viewRow = this.filterPanel.getViewRow(index);
            if (viewRow < 0) continue;
            this.table.addRowSelectionInterval(viewRow, viewRow);
            this.table.scrollToSelectedRow();
        }
    }

    protected void navigateToSelectedObject() {
        int selectedRow = this.table.getSelectedRow();
        int selectedColumn = this.table.getSelectedColumn();
        Object value = this.table.getValueAt(selectedRow, selectedColumn);
        Address addr = null;
        if (value instanceof Address) {
            addr = (Address)value;
        }
        if (value instanceof AddressRangeImpl) {
            AddressRangeImpl range = (AddressRangeImpl)value;
            addr = range.getMinAddress();
        }
        if (value instanceof Long) {
            Long lval = (Long)value;
            if (this.program != null) {
                addr = this.program.getAddressFactory().getAddressSpace("ram").getAddress(lval.longValue());
            }
        }
        if (this.listingService != null) {
            this.listingService.goTo(addr, true);
        }
    }

    public void applyFilter() {
        ArrayList<MemoryBox> blist = new ArrayList<MemoryBox>();
        for (int i = 0; i < this.filterPanel.getRowCount(); ++i) {
            int row = this.filterPanel.getModelRow(i);
            if (row < 0) continue;
            blist.add(this.model.getBoxAt(row));
        }
        this.provider.setBoxesInPanel(blist);
    }

    private class FilterActionFilterListener
    implements FilterListener {
        private FilterActionFilterListener() {
        }

        public void filterChanged(String text) {
            if (MemviewTable.this.provider.isApplyFilter()) {
                MemviewTable.this.applyFilterManager.updateLater();
            }
        }
    }
}

