/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.util.ShellUtils;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DebuggerAttachDialogOld
extends DialogComponentProvider {
    protected DebuggerObjectsProvider provider;
    protected TargetAttacher attacher;
    protected JTextField pidField;
    protected JButton attachButton;

    public DebuggerAttachDialogOld(DebuggerObjectsProvider provider) {
        super("Attach", true, true, true, false);
        this.provider = provider;
        this.populateComponents();
    }

    protected void populateComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel centerPanel = new JPanel(new FlowLayout(1));
        panel.add((Component)centerPanel, "Center");
        JPanel grid = new JPanel(new GridLayout(1, 2));
        centerPanel.add(grid);
        JLabel cmdLineLabel = new JLabel("Target pid");
        grid.add(cmdLineLabel);
        this.pidField = new JTextField();
        grid.add(this.pidField);
        this.addWorkPanel(panel);
        this.attachButton = new JButton();
        DebuggerResources.AbstractLaunchAction.styleButton(this.attachButton);
        this.addButton(this.attachButton);
        this.addCancelButton();
        this.attachButton.addActionListener(this::attach);
    }

    protected void attach(ActionEvent evt) {
        String pidstr = this.pidField.getText();
        long pid = pidstr.startsWith("0x") ? Long.parseLong(pidstr, 16) : Long.parseLong(pidstr);
        AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> {
            this.setStatusText("Attaching");
            this.attacher.attach(pid).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1));
        }).finish().exceptionally(e -> {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Could not attach", (Object)e);
            this.setStatusText("Could not attach: " + e.getMessage(), MessageType.ERROR);
            return null;
        });
    }

    public void setLauncher(TargetAttacher attacher) {
        this.attacher = attacher;
    }

    public void setArgs(String ... args) {
        String cmdLine = ShellUtils.generateLine(Arrays.asList(args));
        this.pidField.setText(cmdLine);
    }
}

