/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.widgets.tree.support.GTreeRenderer;
import generic.theme.GColor;
import generic.theme.Gui;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectNode;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class ObjectTreeCellRenderer
extends GTreeRenderer {
    private static final Color COLOR_FOREGROUND_SELECTION = new GColor("color.fg.tree.selected");
    private static final String FONT_ID = "font.debugger.object.tree.renderer";
    private final DebuggerObjectsProvider provider;

    public ObjectTreeCellRenderer(DebuggerObjectsProvider provider) {
        this.provider = provider;
    }

    public Component getTreeCellRendererComponent(JTree t, Object value, boolean sel, boolean exp, boolean leaf, int row, boolean focus) {
        Component component = super.getTreeCellRendererComponent(t, value, sel, exp, leaf, row, focus);
        if (value instanceof ObjectNode) {
            ObjectContainer selection;
            Object last;
            TreePath path;
            TargetExecutionStateful stateful;
            Map attrs;
            String kind;
            ObjectNode node = (ObjectNode)((Object)value);
            ObjectContainer container = node.getContainer();
            this.setText(container.getDecoratedName());
            component.setForeground(DebuggerObjectsProvider.COLOR_FOREGROUND);
            TargetObject targetObject = container.getTargetObject();
            if (container.isSubscribed()) {
                Color color = DebuggerObjectsProvider.COLOR_FOREGROUND_SUBSCRIBED;
                if (!color.equals(this.getTextNonSelectionColor())) {
                    component.setForeground(color);
                }
            }
            if (targetObject != null && (kind = (String)(attrs = targetObject.getCachedAttributes()).get("_kind")) != null && !kind.equals("")) {
                if (kind.equals("OBJECT_INTRINSIC")) {
                    container.subscribe();
                }
                this.setColor(component, kind);
            }
            if (!node.isVisible() && !this.provider.isHideIntrinsics()) {
                component.setForeground(DebuggerObjectsProvider.COLOR_FOREGROUND_INVISIBLE);
            }
            if (container.getTargetObject() instanceof TargetExecutionStateful && (stateful = (TargetExecutionStateful)targetObject).getExecutionState().equals((Object)TargetExecutionStateful.TargetExecutionState.TERMINATED)) {
                component.setForeground(DebuggerObjectsProvider.COLOR_FOREGROUND_INVALIDATED);
            }
            if (container.isLink()) {
                component.setForeground(DebuggerObjectsProvider.COLOR_FOREGROUND_LINK);
            }
            if (container.isModified()) {
                component.setForeground(DebuggerObjectsProvider.COLOR_FOREGROUND_MODIFIED);
            }
            if ((path = t.getSelectionPath()) != null && (last = path.getLastPathComponent()) instanceof ObjectNode && container.equals(selection = ((ObjectNode)((Object)last)).getContainer())) {
                component.setForeground(COLOR_FOREGROUND_SELECTION);
            }
            Font font = Gui.getFont((String)FONT_ID);
            if (container.isFocused()) {
                font = font.deriveFont(1);
            }
            component.setFont(font);
        }
        return component;
    }

    private void setColor(Component component, String kind) {
        switch (kind) {
            case "OBJECT_PROPERTY_ACCESSOR": {
                component.setForeground(DebuggerObjectsProvider.COLOR_FOREGROUND);
                break;
            }
            case "OBJECT_INTRINSIC": {
                component.setForeground(DebuggerObjectsProvider.COLOR_FOREGROUND_INTRINSIC);
                break;
            }
            case "OBJECT_TARGET_OBJECT": {
                component.setForeground(DebuggerObjectsProvider.COLOR_FOREGROUND_TARGET);
                break;
            }
            case "OBJECT_ERROR": {
                component.setForeground(DebuggerObjectsProvider.COLOR_FOREGROUND_ERROR);
            }
        }
    }

    protected Component highlight(Component component) {
        return component;
    }
}

