/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.gdb;

import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOpinion;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMappingOffer;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import java.util.Set;

public class GdbM68kDebuggerMappingOpinion
implements DebuggerMappingOpinion {
    protected static final LanguageID LANG_ID_68K_BE = new LanguageID("68000:BE:32:default");
    protected static final CompilerSpecID COMP_ID_DEFAULT = new CompilerSpecID("default");

    @Override
    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment env, TargetObject target, boolean includeOverrides) {
        if (!(target instanceof TargetProcess)) {
            return Set.of();
        }
        if (!env.getDebugger().toLowerCase().contains("gdb")) {
            return Set.of();
        }
        String os = env.getOperatingSystem();
        if (!os.contains("Linux")) {
            return Set.of();
        }
        String endian = env.getEndian();
        if (!endian.contains("big")) {
            return Set.of();
        }
        String arch = env.getArchitecture();
        if (arch.startsWith("m68k")) {
            return Set.of(new GdbM68kBELinux32DefOffer((TargetProcess)target));
        }
        return Set.of();
    }

    protected static class GdbM68kBELinux32DefOffer
    extends DefaultDebuggerMappingOffer {
        public GdbM68kBELinux32DefOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux m68k - 32-bit", LANG_ID_68K_BE, COMP_ID_DEFAULT, Set.of());
        }
    }
}

