/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model.launch;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetObject;
import ghidra.util.task.TaskMonitor;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public interface DebuggerProgramLaunchOffer {
    public CompletableFuture<LaunchResult> launchProgram(TaskMonitor var1, PromptMode var2, LaunchConfigurator var3);

    default public CompletableFuture<LaunchResult> launchProgram(TaskMonitor monitor, PromptMode prompt) {
        return this.launchProgram(monitor, prompt, LaunchConfigurator.NOP);
    }

    public String getConfigName();

    default public Icon getIcon() {
        return DebuggerResources.ICON_DEBUGGER;
    }

    public String getMenuParentTitle();

    public String getMenuTitle();

    default public String getQuickTitle() {
        return this.getMenuTitle();
    }

    default public String getButtonTitle() {
        return this.getMenuParentTitle() + " " + this.getQuickTitle();
    }

    default public int defaultPriority() {
        return 50;
    }

    public static interface LaunchConfigurator {
        public static final LaunchConfigurator NOP = new LaunchConfigurator(){};

        default public void configureConnector(DebuggerModelFactory factory) {
        }

        default public Map<String, ?> configureLauncher(TargetLauncher launcher, Map<String, ?> arguments, RelPrompt relPrompt) {
            return arguments;
        }
    }

    public static enum PromptMode {
        ALWAYS,
        NEVER,
        ON_ERROR;

    }

    public static enum RelPrompt {
        NONE,
        BEFORE,
        AFTER;

    }

    public record LaunchResult(DebuggerObjectModel model, TargetObject target, TraceRecorder recorder, Throwable exception) {
        public static LaunchResult totalFailure(Throwable ex) {
            return new LaunchResult(null, null, null, ex);
        }
    }
}

