/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface StackUnwindWarning {
    public String getMessage();

    default public boolean moots(StackUnwindWarning other) {
        return false;
    }

    public record CouldNotRecoverSignatureStackUnwindWarning(PcodeOpAST op) implements StackUnwindWarning
    {
        @Override
        public String getMessage() {
            return "Could not recover signature of indirect call: " + this.op;
        }
    }

    public record UnexpectedTargetTypeStackUnwindWarning(DataType type) implements StackUnwindWarning
    {
        @Override
        public String getMessage() {
            return "Indirect call target has unexpected type: " + this.type;
        }
    }

    public record NoHighCallsStackUnwindWarning(PcodeOp op) implements StackUnwindWarning
    {
        @Override
        public String getMessage() {
            return "Caller generated no decompiled calls. How?:" + this.op;
        }
    }

    public record MultipleHighCallsStackUnwindWarning(List<PcodeOpAST> found) implements StackUnwindWarning
    {
        @Override
        public String getMessage() {
            return "Caller generated multiple decompiled calls. How?: " + this.found;
        }
    }

    public record UnspecifiedConventionStackUnwindWarning(Function function) implements StackUnwindWarning,
    Combinable<UnspecifiedConventionStackUnwindWarning>
    {
        @Override
        public String getMessage() {
            return "Function " + this.function + " has unspecified convention. Using default";
        }

        @Override
        public String summarize(Collection<UnspecifiedConventionStackUnwindWarning> all) {
            Stream<String> sortedDisplay = all.stream().map(w -> w.function.getName(false)).sorted();
            if (all.size() > 7) {
                return "Functions " + sortedDisplay.limit(7L).collect(Collectors.joining(", ")) + ", ... have unspecified convention.";
            }
            return "Functions " + sortedDisplay.collect(Collectors.joining(", ")) + " have unspecified convention.";
        }
    }

    public record UnknownPurgeStackUnwindWarning(Function function) implements StackUnwindWarning,
    Combinable<UnknownPurgeStackUnwindWarning>
    {
        @Override
        public String getMessage() {
            return "Function " + this.function + " has unknown/invalid stack purge";
        }

        @Override
        public String summarize(Collection<UnknownPurgeStackUnwindWarning> all) {
            Stream<String> sortedDisplay = all.stream().map(w -> w.function.getName(false)).sorted();
            if (all.size() > 7) {
                return "Functions " + sortedDisplay.limit(7L).collect(Collectors.joining(", ")) + ", ... have unknown/invalid stack purge.";
            }
            return "Functions " + sortedDisplay.collect(Collectors.joining(", ")) + " have unknown/invalid stack purge.";
        }
    }

    public record OpaqueReturnPathStackUnwindWarning(Address pc) implements StackUnwindWarning
    {
        @Override
        public String getMessage() {
            return "Could not analyze any path from " + this.pc + " to a return";
        }
    }

    public record NoReturnPathStackUnwindWarning(Address pc) implements StackUnwindWarning
    {
        @Override
        public String getMessage() {
            return "Could not find a path from " + this.pc + " to a return";
        }

        @Override
        public boolean moots(StackUnwindWarning other) {
            return other instanceof OpaqueReturnPathStackUnwindWarning;
        }
    }

    public static interface Combinable<T extends StackUnwindWarning> {
        public String summarize(Collection<T> var1);
    }
}

