/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.DialogComponentProvider;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.table.FocusableEditor;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.program.model.data.DataType;
import ghidra.util.MessageType;
import ghidra.util.data.DataTypeParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

class ParameterDataTypeCellEditor
extends AbstractCellEditor
implements TableCellEditor,
FocusableEditor {
    private DataTypeSelectionEditor editor;
    private DropDownSelectionTextField<DataType> textField;
    private JButton dataTypeChooserButton;
    private DataType dt;
    private JPanel editorPanel;
    private DataTypeManagerService service;
    private DialogComponentProvider dialog;

    ParameterDataTypeCellEditor(DialogComponentProvider dialog, DataTypeManagerService service) {
        this.dialog = dialog;
        this.service = service;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table1, Object value, boolean isSelected, int row, int column) {
        this.init();
        this.dt = (DataType)value;
        this.editor.setCellEditorValue(this.dt);
        return this.editorPanel;
    }

    private void init() {
        this.editor = new DataTypeSelectionEditor(this.service, DataTypeParser.AllowedDataTypes.ALL);
        this.editor.setTabCommitsEdit(true);
        this.editor.setConsumeEnterKeyPress(false);
        this.textField = this.editor.getDropDownTextField();
        this.editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                ParameterDataTypeCellEditor.this.cancelCellEditing();
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                ParameterDataTypeCellEditor.this.stopCellEditing();
            }
        });
        this.dataTypeChooserButton = new JButton("..."){

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                preferredSize.width = 15;
                return preferredSize;
            }
        };
        this.dataTypeChooserButton.addActionListener(e -> SwingUtilities.invokeLater(() -> {
            DataType dataType = this.service.getDataType((String)null);
            if (dataType != null) {
                this.editor.setCellEditorValue(dataType);
                this.editor.stopCellEditing();
            } else {
                this.editor.cancelCellEditing();
            }
        }));
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ParameterDataTypeCellEditor.this.textField.selectAll();
                ParameterDataTypeCellEditor.this.textField.removeFocusListener((FocusListener)this);
            }
        };
        this.textField.addFocusListener((FocusListener)focusListener);
        this.editorPanel = new JPanel(new BorderLayout());
        this.editorPanel.add((Component)this.textField, "Center");
        this.editorPanel.add((Component)this.dataTypeChooserButton, "East");
    }

    public void focusEditor() {
        this.textField.requestFocusInWindow();
    }

    public DropDownSelectionTextField<DataType> getTextField() {
        return this.textField;
    }

    public JButton getChooserButton() {
        return this.dataTypeChooserButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.dt;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            DataType dataType = this.editor.getCellEditorValueAsDataType();
            this.dialog.clearStatusText();
            if (dataType == null) {
                String text = this.editor.getCellEditorValueAsText();
                this.dialog.setStatusText("Invalid data type: " + text, MessageType.ERROR);
                return false;
            }
            if (dataType.equals(this.dt)) {
                this.fireEditingCanceled();
            } else {
                this.dt = dataType;
                this.fireEditingStopped();
            }
        }
        catch (IllegalArgumentException ex) {
            String text = this.editor.getCellEditorValueAsText();
            this.dialog.setStatusText("Invalid data type: " + text, MessageType.ERROR);
            return false;
        }
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    DataTypeSelectionEditor getEditor() {
        return this.editor;
    }
}

