/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import generic.theme.GThemeDefaults;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import ghidra.app.services.GoToService;
import ghidra.app.util.query.TableService;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import java.awt.Color;
import java.util.HashSet;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Search", shortDescription="Allows users to construct instruction search patterns", description="Provides a component for showing a selected set of instructions. Users can mask any operands and/or mnemonics to produce a search pattern, which can be used to find similar instruction sets in the current program.", servicesRequired={TableService.class, GoToService.class})
public class InstructionSearchPlugin
extends ProgramPlugin {
    static final String SEARCH_ACTION_NAME = "Search Instruction Patterns";
    private TaskMonitor taskMonitor;
    private DockingAction searchAction;
    private final String DIALOG_TITLE = "Instruction Pattern Search";
    private int MAX_SELECTION_SIZE = 500;
    private InstructionSearchDialog searchDialog;

    public InstructionSearchPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    protected void dispose() {
        super.dispose();
        if (this.searchDialog != null) {
            this.searchDialog.dispose();
        }
    }

    public InstructionSearchDialog getSearchDialog() {
        return this.searchDialog;
    }

    protected void init() {
        this.taskMonitor = new TaskMonitorComponent();
    }

    public boolean isSelectionValid(ProgramSelection selection, InstructionSearchDialog dialog) {
        if (selection == null) {
            return false;
        }
        dialog.clearMessage();
        if (selection.getNumAddresses() == 0L) {
            dialog.displayMessage("Select instructions from the listing (and hit reload) to populate the table.", (Color)GThemeDefaults.Colors.Messages.NORMAL);
            return false;
        }
        if (!this.isSelectionSizeValid(selection)) {
            dialog.displayMessage("Invalid selection.  Cannot select more than " + this.MAX_SELECTION_SIZE + " instructions and/or data items.", (Color)GThemeDefaults.Colors.Messages.ERROR);
            return false;
        }
        try {
            if (this.isSelectionRangeValid(selection)) {
                return true;
            }
        }
        catch (InvalidInputException e) {
            dialog.displayMessage(e.getMessage(), (Color)GThemeDefaults.Colors.Messages.ERROR);
            return false;
        }
        return true;
    }

    private int getNumInstructionsInSelection(Program program, ProgramSelection selection) {
        AddressRangeIterator addressRanges = selection.getAddressRanges();
        int numInstructions = 0;
        while (addressRanges.hasNext()) {
            AddressRange range = (AddressRange)addressRanges.next();
            AddressSet addrSet = new AddressSet(range);
            CodeUnitIterator cuIter = program.getListing().getCodeUnits((AddressSetView)addrSet, true);
            while (cuIter.hasNext()) {
                CodeUnit cu = cuIter.next();
                if (!(cu instanceof Instruction) && !(cu instanceof Data)) continue;
                ++numInstructions;
            }
        }
        return numInstructions;
    }

    private boolean isSelectionSizeValid(ProgramSelection selection) {
        int numInstructionsInSelection = this.getNumInstructionsInSelection(this.getCurrentProgram(), selection);
        return numInstructionsInSelection <= this.MAX_SELECTION_SIZE;
    }

    private boolean isSelectionRangeValid(ProgramSelection selection) throws InvalidInputException {
        HashSet<String> blockNames = new HashSet<String>();
        AddressRangeIterator iter = selection.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            Address addr = range.getMinAddress();
            MemoryBlock block = this.getCurrentProgram().getMemory().getBlock(addr);
            blockNames.add(block.getName());
        }
        if (blockNames.size() > 1) {
            throw new InvalidInputException("Selection range cannot span memory blocks");
        }
        if (selection.getNumAddressRanges() > 1) {
            throw new InvalidInputException("Selection cannot contain multiple address ranges");
        }
        return selection.getNumAddressRanges() == 1;
    }

    private void createActions() {
        this.searchAction = new NavigatableContextAction(SEARCH_ACTION_NAME, this.getName(), false){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                InstructionSearchPlugin.this.showSearchDialog(context);
            }
        };
        this.searchAction.addToWindowWhen(NavigatableActionContext.class);
        this.searchAction.setHelpLocation(new HelpLocation("Search", "Instruction_Pattern_Search"));
        this.searchAction.setMenuBarData(new MenuData(new String[]{"&Search", "For Instruction Patterns"}, null, "search for"));
        this.searchAction.setDescription("Construct searches using selected instructions");
        this.tool.addAction((DockingActionIf)this.searchAction);
    }

    private void showSearchDialog(NavigatableActionContext context) {
        this.searchDialog = new InstructionSearchDialog(this, "Instruction Pattern Search", this.taskMonitor);
        this.searchDialog.showDialog(context.getComponentProvider());
    }

    @Override
    protected void programActivated(Program program) {
        if (this.searchDialog != null) {
            this.searchDialog.clear();
        }
    }
}

