/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class FileSetEntryCommand
extends LoadCommand {
    private long vmaddr;
    private long fileoff;
    private LoadCommandString entryId;
    private int reserved;

    FileSetEntryCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.vmaddr = reader.readNextLong();
        this.fileoff = reader.readNextLong();
        this.entryId = new LoadCommandString(reader, this);
        this.reserved = reader.readNextInt();
    }

    public long getVMaddress() {
        return this.vmaddr;
    }

    public long getFileOffset() {
        return this.fileoff;
    }

    public LoadCommandString getFileSetEntryId() {
        return this.entryId;
    }

    public int getReserved() {
        return this.reserved;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(QWORD, "vmaddr", null);
        struct.add(QWORD, "fileoff", null);
        struct.add(this.entryId.toDataType(), "entry_id", null);
        struct.add(DWORD, "reserved", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "fileset_entry_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address addr = baseAddress.getNewAddress(this.getStartIndex());
                DataType fileSetEntryDT = this.toDataType();
                api.createData(addr, fileSetEntryDT);
                api.setPlateComment(addr, this.entryId.getString());
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
        }
    }

    public String toString() {
        return this.entryId.getString();
    }
}

