/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.dyld;

import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.dyld.AbstractDyldInfoState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.StringUtilities;
import java.io.File;
import java.util.List;

public class LazyBindState
extends AbstractDyldInfoState {
    long lazyOffset;

    LazyBindState(MachHeader header, Program program) {
        super(header, program);
    }

    @Override
    public String print() {
        Address sectionAddress = this.getAddress();
        String sectionName = "no section";
        List<Section> sections = this.header.getAllSections();
        for (Section section : sections) {
            long start = section.getAddress();
            long end = section.getAddress() + section.getSize();
            if (sectionAddress.getOffset() < start || sectionAddress.getOffset() >= end) continue;
            sectionName = section.getSectionName();
        }
        File file = new File(this.getOrdinalName());
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getSegmentName());
        buffer.append(' ');
        buffer.append(' ');
        buffer.append(StringUtilities.pad((String)sectionName, (char)' ', (int)-20));
        buffer.append(' ');
        buffer.append(' ');
        buffer.append(sectionAddress);
        buffer.append(' ');
        buffer.append(' ');
        buffer.append(Long.toHexString(this.lazyOffset));
        buffer.append(' ');
        buffer.append(' ');
        buffer.append(StringUtilities.pad((String)file.getName(), (char)' ', (int)-20));
        buffer.append(' ');
        buffer.append(' ');
        buffer.append(this.symbolName);
        buffer.append(' ');
        buffer.append(' ');
        return buffer.toString();
    }
}

