/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfData;
import ghidra.app.util.bin.format.omf.OmfRecord;
import java.io.IOException;
import java.util.ArrayList;

public class OmfFixupRecord
extends OmfRecord {
    private final Subrecord[] subrecs;
    private OmfData lastData = null;

    public OmfFixupRecord(BinaryReader reader) throws IOException {
        ArrayList<Subrecord> subreclist = new ArrayList<Subrecord>();
        this.readRecordHeader(reader);
        long max = reader.getPointerIndex() + (long)this.getRecordLength() - 1L;
        while (reader.getPointerIndex() < max) {
            subreclist.add(Subrecord.readSubrecord(reader, this.hasBigFields()));
        }
        this.subrecs = new Subrecord[subreclist.size()];
        subreclist.toArray(this.subrecs);
        this.readCheckSumByte(reader);
    }

    public void setDataBlock(OmfData last) {
        this.lastData = last;
    }

    public OmfData getDataBlock() {
        return this.lastData;
    }

    public Subrecord[] getSubrecords() {
        return this.subrecs;
    }

    public static class Subrecord {
        private byte first;
        private byte hiFixup;
        private byte fixData;
        private int index;
        private int frameDatum;
        private int targetDatum;
        private int targetDisplacement;

        public static Subrecord readSubrecord(BinaryReader reader, boolean hasBigFields) throws IOException {
            Subrecord rec = new Subrecord();
            rec.first = reader.readNextByte();
            rec.index = -1;
            if (rec.isThreadSubrecord()) {
                int method = rec.getThreadMethod();
                if (method < 4) {
                    rec.index = OmfRecord.readIndex(reader);
                }
                return rec;
            }
            rec.targetDisplacement = 0;
            rec.targetDatum = 0;
            rec.hiFixup = reader.readNextByte();
            rec.fixData = reader.readNextByte();
            int method = rec.getFrameMethod();
            if (!rec.isFrameThread() && method < 3) {
                rec.frameDatum = OmfRecord.readIndex(reader);
            }
            if (!rec.isTargetThread()) {
                rec.targetDatum = OmfRecord.readIndex(reader);
            }
            if ((rec.fixData & 4) == 0) {
                rec.targetDisplacement = OmfRecord.readInt2Or4(reader, hasBigFields);
            }
            return rec;
        }

        public boolean isThreadSubrecord() {
            return (this.first & 0x80) == 0;
        }

        public int getThreadMethod() {
            return this.first >> 2 & 7;
        }

        public boolean isFrameInSubThread() {
            return (this.first & 0x40) != 0;
        }

        public int getIndex() {
            return this.index;
        }

        public int getThreadNum() {
            return this.first & 3;
        }

        public boolean isFrameThread() {
            return (this.fixData & 0x80) != 0;
        }

        public boolean isTargetThread() {
            return (this.fixData & 8) != 0;
        }

        public int getFrameMethod() {
            return this.fixData >> 4 & 7;
        }

        public int getFixThreadNum() {
            return this.fixData & 3;
        }

        public int getFixMethodWithSub(Subrecord rec) {
            return this.fixData & 4 | rec.getThreadMethod() & 3;
        }

        public int getFixMethod() {
            return this.fixData & 7;
        }

        public int getTargetDatum() {
            return this.targetDatum;
        }

        public int getTargetDisplacement() {
            return this.targetDisplacement;
        }

        public int getLocationType() {
            return this.first >> 2 & 0xF;
        }

        public int getDataRecordOffset() {
            return (this.first & 3) << 8 | this.hiFixup & 0xFF;
        }

        public boolean isSegmentRelative() {
            return (this.first & 0x40) != 0;
        }
    }
}

