/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.cmd.register.SetRegisterCmd;
import ghidra.app.util.datatype.microsoft.GuidDataType;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.MutabilitySettingsDefinition;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnsignedCharDataType;
import ghidra.program.model.data.UnsignedLongLongDataType;
import ghidra.program.model.data.UnsignedShortDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;

public class ThreadEnvironmentBlock {
    private Program program;
    private int winVersion;
    private boolean is64Bit;
    private Address tebAddress;
    private int blockSize;
    private DataType DWORDsize;
    private DataType DWORD;
    private DataType PVOID;
    private DataType ULONGLONG;
    private DataType ULONG;
    private DataType LONG;
    private DataType ULONG_PTR;
    private DataType USHORT;
    private DataType CHAR;
    private DataType UCHAR;
    private DataType WCHAR;
    private DataType BOOLEAN;
    private DataType HANDLE;
    private DataType GUID;
    private StructureDataType CLIENT_ID;
    public static final String BLOCK_NAME = "tdb";

    private void setupDataTypes() {
        this.DWORDsize = this.is64Bit ? QWordDataType.dataType : DWordDataType.dataType;
        this.DWORD = DWordDataType.dataType;
        this.PVOID = VoidDataType.dataType;
        this.ULONG_PTR = this.is64Bit ? (this.PVOID = new Pointer64DataType(this.PVOID)) : (this.PVOID = new Pointer32DataType(this.PVOID));
        this.ULONGLONG = UnsignedLongLongDataType.dataType;
        this.ULONG = DWordDataType.dataType;
        this.LONG = DWordDataType.dataType;
        this.USHORT = UnsignedShortDataType.dataType;
        this.UCHAR = UnsignedCharDataType.dataType;
        this.WCHAR = WideChar16DataType.dataType;
        this.CHAR = CharDataType.dataType;
        this.BOOLEAN = BooleanDataType.dataType;
        this.HANDLE = this.PVOID;
        this.GUID = new GuidDataType();
        this.CLIENT_ID = new StructureDataType("CLIENT_ID", 0);
        this.CLIENT_ID.add(this.HANDLE, this.HANDLE.getLength(), "UniqueProcess", null);
        this.CLIENT_ID.add(this.HANDLE, this.HANDLE.getLength(), "UniqueThread", null);
    }

    private void create(LayDown laydown) {
        ArrayDataType dt;
        ArrayDataType dt2;
        laydown.addEntry(0, 0, "ExceptionList", this.PVOID);
        laydown.addEntry(4, 8, "StackBase", this.PVOID);
        laydown.addEntry(8, 16, "StackLimit", this.PVOID);
        laydown.addEntry(12, 24, "SubSystemTib", this.PVOID);
        laydown.addEntry(16, 32, "FiberData", this.PVOID);
        laydown.addEntry(20, 40, "ArbitraryUserPointer", this.PVOID);
        laydown.addEntry(24, 48, "Self", this.PVOID);
        laydown.addEntry(28, 56, "EnvironmentPointer", this.PVOID);
        laydown.addEntry(32, 64, "ClientId", (DataType)this.CLIENT_ID);
        if (this.winVersion <= 30010) {
            laydown.addEntry(40, 80, "pCSR_QLPC_TEB", this.PVOID);
            laydown.addEntry(56, 108, "unkbyte", this.DWORD);
        } else {
            laydown.addEntry(40, 80, "ActiveRpcHandle", this.PVOID);
            laydown.addEntry(56, 108, "CountOfOwnedCriticalSections", this.ULONG);
        }
        laydown.addEntry(44, 88, "ThreadLocalStoragePointer", this.PVOID);
        laydown.addEntry(48, 96, "ProcessEnvironmentBlock", this.PVOID);
        laydown.addEntry(52, 104, "LastErrorValue", this.ULONG);
        if (this.winVersion <= 30051) {
            laydown.addEntry(60, -1, "Win32ProcessInfo", this.PVOID);
        } else if (this.winVersion >= 40000) {
            laydown.addEntry(60, 112, "CsrClientThread", this.PVOID);
        }
        if (this.winVersion >= 30050) {
            laydown.addEntry(64, 120, "Win32ThreadInfo", this.PVOID);
        }
        if (this.winVersion <= 30051) {
            laydown.addEntry(68, -1, "CsrQlpcStack", this.PVOID);
        }
        if (this.winVersion == 40000) {
            dt2 = new ArrayDataType(this.ULONG, 31, this.ULONG.getLength());
            laydown.addEntry(68, -1, "Win32ClientInfo", (DataType)dt2);
        } else if (this.winVersion >= 50000) {
            dt2 = new ArrayDataType(this.ULONG, 26, this.ULONG.getLength());
            laydown.addEntry(68, 128, "User32Reserved", (DataType)dt2);
        }
        if (this.winVersion >= 50000) {
            dt2 = new ArrayDataType(this.ULONG, 5, this.ULONG.getLength());
            laydown.addEntry(172, 232, "UserReserved", (DataType)dt2);
        }
        if (this.winVersion >= 40000) {
            laydown.addEntry(192, 256, "WOW32Reserved", this.PVOID);
        }
        laydown.addEntry(196, 264, "CurrentLocale", this.ULONG);
        laydown.addEntry(200, 268, "FpSoftwareStatusRegister", this.ULONG);
        if (this.winVersion >= 100000) {
            dt2 = new ArrayDataType(this.PVOID, 16, this.PVOID.getLength());
            laydown.addEntry(204, 272, "ReservedForDebuggingInstrumentation", (DataType)dt2);
        }
        if (this.winVersion <= 60003) {
            dt2 = new ArrayDataType(this.PVOID, 54, this.PVOID.getLength());
            laydown.addEntry(204, 272, "SystemReserved1", (DataType)dt2);
        } else if (this.winVersion <= 101511) {
            dt2 = new ArrayDataType(this.PVOID, 38, this.PVOID.getLength());
            laydown.addEntry(268, 400, "SystemReserved1", (DataType)dt2);
        } else if (this.winVersion <= 101607) {
            dt2 = new ArrayDataType(this.PVOID, 36, this.PVOID.getLength());
            laydown.addEntry(268, 400, "SystemReserved1", (DataType)dt2);
        } else if (this.winVersion <= 101703) {
            dt2 = new ArrayDataType(this.PVOID, 30, this.PVOID.getLength());
            laydown.addEntry(268, 400, "SystemReserved1", (DataType)dt2);
        } else {
            dt2 = new ArrayDataType(this.PVOID, 26, this.PVOID.getLength());
            laydown.addEntry(268, 400, "SystemReserved1", (DataType)dt2);
        }
        if (this.winVersion >= 101709) {
            laydown.addEntry(372, 640, "PlaceholderCompatibilityMode", this.CHAR);
        }
        if (this.winVersion >= 101809) {
            laydown.addEntry(373, 641, "PlaceholderHydrationAlwaysExplicit", this.BOOLEAN);
        }
        if (this.winVersion >= 101709 && this.winVersion <= 101803) {
            dt2 = new ArrayDataType(this.CHAR, 17, this.CHAR.getLength());
            laydown.addEntry(373, 641, "PlaceholderReserved", (DataType)dt2);
        } else if (this.winVersion >= 101809) {
            dt2 = new ArrayDataType(this.CHAR, 16, this.CHAR.getLength());
            laydown.addEntry(374, 642, "PlaceholderReserved", (DataType)dt2);
        }
        if (this.winVersion >= 101709) {
            laydown.addEntry(384, 652, "ProxiedProcessId", this.DWORD);
        }
        if (this.winVersion >= 101703) {
            laydown.addEntry(388, 656, "ActivationStack", this.DWORDsize);
        }
        if (this.winVersion >= 101607) {
            dt2 = new ArrayDataType(this.UCHAR, 8, this.UCHAR.getLength());
            laydown.addEntry(412, 696, "WorkingOnBehalfOfTicket", (DataType)dt2);
        }
        if (this.winVersion >= 30010 && this.winVersion <= 40000) {
            laydown.addEntry(420, -1, "Spare1", this.PVOID);
        }
        if (this.winVersion >= 30010 && this.winVersion <= 30051) {
            laydown.addEntry(424, -1, "Spare2", this.PVOID);
        }
        if (this.winVersion == 40000) {
            laydown.addEntry(424, 704, "ExceptionCode", this.LONG);
        } else if (this.winVersion > 40000) {
            laydown.addEntry(420, 704, "ExceptionCode", this.LONG);
        }
        if (this.winVersion > 60003) {
            dt2 = new ArrayDataType(this.UCHAR, 4, this.UCHAR.getLength());
            laydown.addEntry(-1, 708, "Padding0", (DataType)dt2);
        }
        if (this.winVersion == 30010) {
            laydown.addEntry(428, -1, "Win32ThreadInfo", this.PVOID);
            laydown.addEntry(432, -1, "Win32ProcessInfo", this.PVOID);
            dt2 = new ArrayDataType(this.HANDLE, 2, this.HANDLE.getLength());
            laydown.addEntry(476, -1, "DbgSsReserved", (DataType)dt2);
        } else if (this.winVersion >= 30050 && this.winVersion <= 30051) {
            dt2 = new ArrayDataType(this.PVOID, 5, this.PVOID.getLength());
            laydown.addEntry(428, -1, "CsrQlpcTeb", (DataType)dt2);
            laydown.addEntry(448, -1, "Win32ClientInfo", (DataType)dt2);
        }
        if (this.winVersion >= 50001 && this.winVersion <= 50002) {
            laydown.addEntry(424, -1, "ActivationContextStack", this.DWORDsize);
        } else if (this.winVersion > 50002) {
            laydown.addEntry(424, -1, "ActivationContextStackPointer", this.PVOID);
        }
        if (this.winVersion >= 100000) {
            laydown.addEntry(428, -1, "InstrumentationCallbackSp", this.ULONG_PTR);
            laydown.addEntry(432, -1, "InstrumentationCallbackPreviousPc", this.ULONG_PTR);
            laydown.addEntry(436, -1, "InstrumentationCallbackPreviousSp", this.ULONG_PTR);
            laydown.addEntry(440, -1, "InstrumentationCallbackDisabled", this.BOOLEAN);
        }
        if (this.winVersion == 40000) {
            dt2 = new ArrayDataType(this.UCHAR, 40, this.UCHAR.getLength());
            laydown.addEntry(428, -1, "SpareBytes1", (DataType)dt2);
        } else if (this.winVersion == 50000) {
            dt2 = new ArrayDataType(this.UCHAR, 44, this.UCHAR.getLength());
            laydown.addEntry(424, -1, "SpareBytes1", (DataType)dt2);
        } else if (this.winVersion >= 50001 && this.winVersion <= 50002) {
            dt2 = new ArrayDataType(this.UCHAR, 24, this.UCHAR.getLength());
            laydown.addEntry(444, -1, "SpareBytes1", (DataType)dt2);
        } else if (this.winVersion == 60000) {
            dt2 = new ArrayDataType(this.UCHAR, 36, this.UCHAR.getLength());
            laydown.addEntry(428, -1, "SpareBytes1", (DataType)dt2);
        } else if (this.winVersion >= 60001 && this.winVersion <= 60003) {
            dt2 = new ArrayDataType(this.UCHAR, 36, this.UCHAR.getLength());
            laydown.addEntry(428, -1, "SpareBytes", (DataType)dt2);
        } else if (this.winVersion >= 100000) {
            dt2 = new ArrayDataType(this.UCHAR, 23, this.UCHAR.getLength());
            laydown.addEntry(441, -1, "SpareBytes", (DataType)dt2);
        }
        if (this.winVersion >= 60000) {
            laydown.addEntry(464, -1, "TxFsContext", this.ULONG);
        }
        if (this.winVersion > 50002) {
            laydown.addEntry(-1, 712, "ActivationContextStackPointer", this.PVOID);
        }
        if (this.winVersion == 60000) {
            dt2 = new ArrayDataType(this.UCHAR, 24, this.UCHAR.getLength());
            laydown.addEntry(-1, 720, "SpareBytes1", (DataType)dt2);
        } else if (this.winVersion >= 60001 && this.winVersion <= 60003) {
            dt2 = new ArrayDataType(this.UCHAR, 24, this.UCHAR.getLength());
            laydown.addEntry(-1, 720, "SpareBytes", (DataType)dt2);
        }
        if (this.winVersion >= 100000) {
            laydown.addEntry(-1, 720, "InstrumentationCallbackSp", this.ULONG_PTR);
            laydown.addEntry(-1, 728, "InstrumentationCallbackPreviousPc", this.ULONG_PTR);
            laydown.addEntry(-1, 736, "InstrumentationCallbackPreviousSp", this.ULONG_PTR);
        }
        if (this.winVersion >= 60000) {
            laydown.addEntry(-1, 744, "TxFsContext", this.ULONG);
        }
        if (this.winVersion >= 100000) {
            laydown.addEntry(-1, 748, "InstrumentationCallbackDisabled", this.BOOLEAN);
        }
        if (this.winVersion >= 101809) {
            laydown.addEntry(-1, 749, "UnalignedLoadStoreExceptions", this.BOOLEAN);
        }
        if (this.winVersion == 60003) {
            dt2 = new ArrayDataType(this.UCHAR, 4, this.UCHAR.getLength());
            laydown.addEntry(-1, 748, "Padding1", (DataType)dt2);
        } else if (this.winVersion >= 100000 && this.winVersion <= 101803) {
            dt2 = new ArrayDataType(this.UCHAR, 3, this.UCHAR.getLength());
            laydown.addEntry(-1, 749, "Padding1", (DataType)dt2);
        } else {
            dt2 = new ArrayDataType(this.UCHAR, 2, this.UCHAR.getLength());
            laydown.addEntry(-1, 750, "Padding1", (DataType)dt2);
        }
        if (this.winVersion == 30010) {
            dt2 = new ArrayDataType(this.PVOID, 323, this.PVOID.getLength());
            laydown.addEntry(484, -1, "SystemReserved2", (DataType)dt2);
        } else if (this.winVersion >= 30050 && this.winVersion <= 30051) {
            dt2 = new ArrayDataType(this.PVOID, 322, this.PVOID.getLength());
            laydown.addEntry(468, -1, "SystemReserved2", (DataType)dt2);
        } else if (this.winVersion == 40000) {
            dt2 = new ArrayDataType(this.PVOID, 10, this.PVOID.getLength());
            laydown.addEntry(468, -1, "SystemReserved2", (DataType)dt2);
        }
        if (this.winVersion == 40000) {
            laydown.addEntry(508, 752, "GdiTebBatch", this.DWORDsize);
        } else if (this.winVersion > 40000) {
            laydown.addEntry(468, 752, "GdiTebBatch", this.DWORDsize);
        }
        if (this.winVersion >= 30050 && this.winVersion <= 40000) {
            laydown.addEntry(1756, -1, "gdiRgn", this.ULONG);
            laydown.addEntry(1760, -1, "gdiPen", this.ULONG);
            laydown.addEntry(1764, -1, "gdiBrush", this.ULONG);
        }
        if (this.winVersion >= 30050 && this.winVersion <= 40000) {
            laydown.addEntry(1768, 2008, "RealClientId", (DataType)this.CLIENT_ID);
        } else if (this.winVersion > 40000) {
            laydown.addEntry(1716, 2008, "RealClientId", (DataType)this.CLIENT_ID);
        }
        if (this.winVersion >= 30010 && this.winVersion < 30050) {
            laydown.addEntry(1776, 2024, "CsrQlpcStack", this.PVOID);
        } else if (this.winVersion >= 30050 && this.winVersion <= 40000) {
            laydown.addEntry(1776, 2024, "GdiCachedProcessHandle", this.PVOID);
        } else if (this.winVersion > 40000) {
            laydown.addEntry(1724, 2024, "GdiCachedProcessHandle", this.PVOID);
        }
        if (this.winVersion >= 30010 && this.winVersion <= 40000) {
            laydown.addEntry(1780, 2032, "GdiClientPID", this.ULONG);
            laydown.addEntry(1784, 2036, "GdiCLientTID", this.ULONG);
            laydown.addEntry(1788, 2040, "GdiThreadLocalInfo", this.PVOID);
        } else if (this.winVersion > 40000) {
            laydown.addEntry(1728, 2032, "GdiClientPID", this.ULONG);
            laydown.addEntry(1732, 2036, "GdiCLientTID", this.ULONG);
            laydown.addEntry(1736, 2040, "GdiThreadLocalInfo", this.PVOID);
        }
        if (this.winVersion >= 30010 && this.winVersion <= 30051) {
            laydown.addEntry(1792, -1, "User32Reserved0", this.PVOID);
            laydown.addEntry(1796, -1, "User32Reserved1", this.PVOID);
        }
        if (this.winVersion == 30010) {
            dt2 = new ArrayDataType(this.PVOID, 315, this.PVOID.getLength());
            laydown.addEntry(1800, 2048, "UserReserved", (DataType)dt2);
        } else if (this.winVersion == 30051) {
            dt2 = new ArrayDataType(this.PVOID, 3, this.PVOID.getLength());
            laydown.addEntry(1800, 2048, "UserReserved", (DataType)dt2);
        } else if (this.winVersion == 40000) {
            dt2 = new ArrayDataType(this.PVOID, 5, this.PVOID.getLength());
            laydown.addEntry(1792, 2048, "UserReserved", (DataType)dt2);
        } else if (this.winVersion >= 50000) {
            dt2 = new ArrayDataType(this.ULONG_PTR, 62, this.ULONG_PTR.getLength());
            laydown.addEntry(1740, 2048, "Win32ClientInfo", (DataType)dt2);
        }
        if (this.winVersion == 30051) {
            dt2 = new ArrayDataType(this.PVOID, 307, this.PVOID.getLength());
            laydown.addEntry(1812, 2544, "glDispatchTable", (DataType)dt2);
        } else if (this.winVersion == 40000) {
            dt2 = new ArrayDataType(this.PVOID, 280, this.PVOID.getLength());
            laydown.addEntry(1812, 2544, "glDispatchTable", (DataType)dt2);
        } else if (this.winVersion > 40000) {
            dt2 = new ArrayDataType(this.PVOID, 233, this.PVOID.getLength());
            laydown.addEntry(1988, 2544, "glDispatchTable", (DataType)dt2);
        }
        if (this.winVersion == 40000) {
            dt2 = new ArrayDataType(this.ULONG_PTR, 26, this.ULONG_PTR.getLength());
            laydown.addEntry(2932, 4408, "glReserved1", (DataType)dt2);
        } else if (this.winVersion >= 50000) {
            dt2 = new ArrayDataType(this.ULONG_PTR, 29, this.ULONG_PTR.getLength());
            laydown.addEntry(2920, 4408, "glReserved1", (DataType)dt2);
        }
        if (this.winVersion >= 40000) {
            laydown.addEntry(3036, 4640, "glReserved2", this.PVOID);
        }
        if (this.winVersion >= 30050) {
            laydown.addEntry(3040, 4648, "glSectionInfo", this.PVOID);
            laydown.addEntry(3044, 4656, "glSection", this.PVOID);
            laydown.addEntry(3048, 4664, "glTable", this.PVOID);
            laydown.addEntry(3052, 4672, "glCurrentRC", this.PVOID);
            laydown.addEntry(3056, 4680, "glContext", this.PVOID);
        }
        laydown.addEntry(3060, 4688, "LastStatusValue", this.ULONG);
        if (this.winVersion >= 60003) {
            dt2 = new ArrayDataType(this.UCHAR, 4, this.UCHAR.getLength());
            laydown.addEntry(-1, 4692, "Padding2", (DataType)dt2);
        }
        ArrayDataType bufdt = new ArrayDataType(this.WCHAR, 261, this.WCHAR.getLength());
        laydown.addEntry(3072, 4712, "StaticUnicodeBuffer", (DataType)bufdt);
        if (this.winVersion >= 60003) {
            ArrayDataType dt3 = new ArrayDataType(this.UCHAR, 6, this.UCHAR.getLength());
            laydown.addEntry(-1, 5234, "Padding3", (DataType)dt3);
        }
        laydown.addEntry(3596, 5240, "DeallocationStack", this.PVOID);
        ArrayDataType ptrdt = new ArrayDataType(this.PVOID, 64, this.PVOID.getLength());
        laydown.addEntry(3600, 5248, "TlsSlots", (DataType)ptrdt);
        laydown.addEntry(3856, 5760, "TlsLinks.Flink", this.PVOID);
        laydown.addEntry(3860, 5768, "TlsLinks.Blink", this.PVOID);
        laydown.addEntry(3864, 5776, "Vdm", this.PVOID);
        laydown.addEntry(3868, 5784, "ReservedForNtRpc", this.PVOID);
        ArrayDataType handledt = new ArrayDataType(this.HANDLE, 2, this.HANDLE.getLength());
        laydown.addEntry(3872, 5792, "DbgSsReserved", (DataType)handledt);
        if (this.winVersion >= 40000 && this.winVersion <= 50001) {
            laydown.addEntry(3880, 5808, "HardErrorsAreDisabled", this.ULONG);
        } else if (this.winVersion >= 50002) {
            laydown.addEntry(3880, 5808, "HardErrorMode", this.ULONG);
        }
        if (this.winVersion >= 60003) {
            dt = new ArrayDataType(this.UCHAR, 4, this.UCHAR.getLength());
            laydown.addEntry(-1, 5812, "Padding4", (DataType)dt);
        }
        if (this.winVersion >= 40000 && this.winVersion <= 50002) {
            dt = new ArrayDataType(this.PVOID, 16, this.PVOID.getLength());
            laydown.addEntry(3884, 5816, "Instrumentation", (DataType)dt);
        } else if (this.winVersion >= 60000) {
            dt = new ArrayDataType(this.PVOID, this.is64Bit ? 11 : 9, this.PVOID.getLength());
            laydown.addEntry(3884, 5816, "Instrumentation", (DataType)dt);
        }
        if (this.winVersion >= 60000) {
            laydown.addEntry(3920, 5904, "ActivityId", this.GUID);
        }
        if (this.winVersion > 50002) {
            laydown.addEntry(3936, 5920, "SubProcessTag", this.PVOID);
        }
        if (this.winVersion >= 60000 && this.winVersion <= 60001) {
            laydown.addEntry(3940, 5928, "EtwLocalData", this.PVOID);
        } else if (this.winVersion >= 60002) {
            laydown.addEntry(3940, 5928, "PerflibData", this.PVOID);
        }
        if (this.winVersion > 50002) {
            laydown.addEntry(3944, 5936, "EtwTraceData", this.PVOID);
        }
        if (this.winVersion >= 40000) {
            laydown.addEntry(3948, 5944, "WinSockData", this.PVOID);
            laydown.addEntry(3952, 5952, "GdiBatchCount", this.ULONG);
        }
        if (this.winVersion >= 60001) {
            laydown.addEntry(3956, 5956, "IdealProcessorValue", this.ULONG);
        }
        if (this.winVersion > 50002) {
            laydown.addEntry(3960, 1864, "GuaranteedStackBytes", this.ULONG);
        }
        if (this.winVersion >= 50000) {
            laydown.addEntry(3964, 5968, "ReservedForPerf", this.PVOID);
        }
        if (this.winVersion >= 40000) {
            laydown.addEntry(3968, 5976, "ReservedForOle", this.PVOID);
            laydown.addEntry(3972, 5984, "WaitingOnLoaderLock", this.ULONG);
        }
        if (this.winVersion >= 60000) {
            laydown.addEntry(3976, 5992, "SavedPriorityState", this.PVOID);
        }
        if (this.winVersion >= 50002 && this.winVersion <= 60001) {
            laydown.addEntry(3980, 6000, "SoftPatchPtr1", this.ULONG_PTR);
        } else if (this.winVersion >= 60002) {
            laydown.addEntry(3980, 6000, "ReservedForCodeCoverage", this.ULONG_PTR);
        }
        if (this.winVersion >= 60000) {
            laydown.addEntry(3984, 6008, "ThreadPoolData", this.PVOID);
        }
        if (this.winVersion >= 50000) {
            laydown.addEntry(3988, 6016, "TlsExpansionSlots", this.PVOID);
        }
        if (this.winVersion > 50002) {
            laydown.addEntry(-1, 6024, "DeallocationBStore", this.PVOID);
            laydown.addEntry(-1, 6032, "BStoreLimit", this.PVOID);
        }
        if (this.winVersion >= 50000 && this.winVersion <= 60000) {
            laydown.addEntry(3992, 6040, "ImpersonationLocale", this.ULONG);
        } else if (this.winVersion >= 60001) {
            laydown.addEntry(3992, 6040, "MuiGeneration", this.ULONG);
        }
        if (this.winVersion >= 50000) {
            laydown.addEntry(3996, 6044, "IsImpersonating", this.ULONG);
            laydown.addEntry(4000, 6048, "NlsCache", this.PVOID);
        }
        if (this.winVersion >= 50001) {
            laydown.addEntry(4004, 6056, "pShimData", this.PVOID);
        }
        if (this.winVersion >= 50001 && this.winVersion <= 60001) {
            laydown.addEntry(4008, 6064, "HeapVirtualAffinity", this.ULONG);
        } else if (this.winVersion >= 60002 && this.winVersion <= 101803) {
            laydown.addEntry(4008, 6064, "HeapVirtualAffinity", this.USHORT);
        } else if (this.winVersion >= 101809) {
            laydown.addEntry(4008, 6064, "HeapData", this.ULONG);
        }
        if (this.winVersion >= 60002 && this.winVersion <= 101803) {
            laydown.addEntry(4010, 6066, "LowFragHeapDataSlot", this.USHORT);
        }
        if (this.winVersion >= 50001) {
            laydown.addEntry(4012, 6072, "CurrentTransactionHandle", this.PVOID);
            laydown.addEntry(4016, 6080, "ActiveFrame", this.PVOID);
        }
        if (this.winVersion >= 50002) {
            laydown.addEntry(4020, 6088, "FlsData", this.PVOID);
        }
        if (this.winVersion >= 60000) {
            laydown.addEntry(4024, 6096, "PreferredLanguages", this.PVOID);
            laydown.addEntry(4028, 6104, "UserPrefLanguages", this.PVOID);
            laydown.addEntry(4032, 6112, "MergedPrefLanguages", this.PVOID);
            laydown.addEntry(4036, 6120, "MuiImpersonation", this.ULONG);
            laydown.addEntry(4040, 6124, "CrossTebFlags", this.USHORT);
            laydown.addEntry(4042, 6126, "SameTebFlags", this.USHORT);
            laydown.addEntry(4044, 6128, "TxnScopeEnterCallback", this.PVOID);
            laydown.addEntry(4048, 6136, "TxnScopeExitCallback", this.PVOID);
            laydown.addEntry(4052, 6144, "TxnScopeContext", this.PVOID);
            laydown.addEntry(4056, 6152, "LockCount", this.ULONG);
        }
        if (this.winVersion >= 100000) {
            laydown.addEntry(4060, 6156, "WowTebOffset", this.LONG);
        }
        if (this.winVersion >= 60001) {
            laydown.addEntry(4064, 6160, "ResourceRetValue", this.PVOID);
        }
        if (this.winVersion >= 60002) {
            laydown.addEntry(4068, 6168, "ReservedForWdf", this.PVOID);
        }
        if (this.winVersion >= 100000) {
            laydown.addEntry(4072, 6176, "ReservedForCrt", this.ULONGLONG);
            laydown.addEntry(4080, 6184, "EffectiveContainerId", this.GUID);
        }
    }

    private void clearBlock(MemoryBlock block) {
        Symbol sym;
        Listing listing = this.program.getListing();
        Address endAddr = this.tebAddress.add((long)(this.blockSize - 1));
        listing.clearCodeUnits(this.tebAddress, endAddr, false);
        SymbolTable symbolTable = this.program.getSymbolTable();
        SymbolIterator iter = symbolTable.getSymbolIterator(this.tebAddress, true);
        while (iter.hasNext() && block.contains((sym = iter.next()).getAddress())) {
            sym.delete();
        }
    }

    public void createBlockAndStructure() throws MemoryConflictException, LockException, IllegalArgumentException, AddressOverflowException, CodeUnitInsertionException, InvalidInputException {
        Memory memory = this.program.getMemory();
        MemoryBlock block = memory.getBlock(BLOCK_NAME);
        if (block != null) {
            if (!block.getStart().equals((Object)this.tebAddress) || block.getSize() != (long)this.blockSize || block.isInitialized()) {
                throw new MemoryConflictException("Incompatible tdb block exists");
            }
            this.clearBlock(block);
        } else {
            block = memory.createUninitializedBlock(BLOCK_NAME, this.tebAddress, (long)this.blockSize, false);
        }
        block.setWrite(true);
        LayDownStructure laydown = new LayDownStructure(this.is64Bit);
        this.create(laydown);
        if (this.is64Bit) {
            selfRef = new Pointer64DataType((DataType)laydown.tebDataType);
            laydown.tebDataType.replaceAtOffset(48, (DataType)selfRef, 8, "Self", null);
        } else {
            selfRef = new Pointer32DataType((DataType)laydown.tebDataType);
            laydown.tebDataType.replaceAtOffset(24, (DataType)selfRef, 4, "Self", null);
        }
        Listing listing = this.program.getListing();
        listing.createData(this.tebAddress, (DataType)laydown.tebDataType);
        SymbolTable symbolTable = this.program.getSymbolTable();
        symbolTable.createLabel(this.tebAddress, "TEB", SourceType.ANALYSIS);
    }

    private ByteArrayInputStream getTEBBytes() {
        byte[] buffer = new byte[this.blockSize];
        for (int i = 0; i < this.blockSize; ++i) {
            buffer[i] = 0;
        }
        long offset = this.tebAddress.getOffset();
        if (this.is64Bit) {
            for (int i = 0; i < 8; ++i) {
                buffer[48 + i] = (byte)offset;
                offset >>= 8;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                buffer[24 + i] = (byte)offset;
                offset >>= 8;
            }
        }
        return new ByteArrayInputStream(buffer);
    }

    private void markDataAsConstant(Data data) {
        SettingsDefinition[] settings;
        for (SettingsDefinition definitions : settings = data.getDataType().getSettingsDefinitions()) {
            if (!(definitions instanceof MutabilitySettingsDefinition)) continue;
            MutabilitySettingsDefinition setting = (MutabilitySettingsDefinition)definitions;
            setting.setChoice((Settings)data, 2);
        }
    }

    public void createBlocksAndSymbols() throws MemoryConflictException, LockException, IllegalArgumentException, AddressOverflowException, CancelledException {
        Memory memory = this.program.getMemory();
        MemoryBlock block1 = memory.getBlock(BLOCK_NAME);
        if (block1 != null) {
            if (!block1.getStart().equals((Object)this.tebAddress) || block1.getSize() != (long)this.blockSize || !block1.isInitialized()) {
                throw new MemoryConflictException("Incompatible tdb block exists");
            }
            this.clearBlock(block1);
        } else {
            ByteArrayInputStream byteStream = this.getTEBBytes();
            block1 = memory.createInitializedBlock(BLOCK_NAME, this.tebAddress, (InputStream)byteStream, (long)this.blockSize, null, false);
        }
        block1.setWrite(true);
        LayDownFlat laydown = new LayDownFlat(this.program, this.tebAddress, this.is64Bit);
        this.create(laydown);
        Data data = this.program.getListing().getDataAt(this.tebAddress.add(this.is64Bit ? 48L : 24L));
        this.markDataAsConstant(data);
    }

    public void setRegisterValue() {
        Register reg = this.program.getRegister(this.is64Bit ? "GS_OFFSET" : "FS_OFFSET");
        BigInteger val = BigInteger.valueOf(this.tebAddress.getOffset());
        for (MemoryBlock block : this.program.getMemory().getBlocks()) {
            if (!block.isExecute()) continue;
            SetRegisterCmd cmd = new SetRegisterCmd(reg, block.getStart(), block.getEnd(), val);
            cmd.applyTo((DomainObject)this.program);
        }
    }

    public boolean is64() {
        return this.is64Bit;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setAddress(Address addr) {
        this.tebAddress = addr;
    }

    public ThreadEnvironmentBlock(Program prog, WinVersion version) {
        this.program = prog;
        this.tebAddress = null;
        this.winVersion = version.getOrder();
        this.is64Bit = this.program.getLanguageID().getIdAsString().contains("64");
        this.blockSize = this.is64Bit ? 6224 : 4096;
        this.setupDataTypes();
    }

    private static abstract class LayDown {
        protected boolean is64Bit;

        public abstract void addEntry(int var1, int var2, String var3, DataType var4);

        public LayDown(boolean is64) {
            this.is64Bit = is64;
        }
    }

    private static class LayDownStructure
    extends LayDown {
        protected StructureDataType tebDataType = new StructureDataType("TEB", 0);

        @Override
        public void addEntry(int off32, int off64, String name, DataType dat) {
            int offset;
            int n = offset = this.is64Bit ? off64 : off32;
            if (offset < 0) {
                return;
            }
            this.tebDataType.insertAtOffset(offset, dat, dat.getLength(), name, null);
        }

        public LayDownStructure(boolean is64) {
            super(is64);
        }
    }

    private static class LayDownFlat
    extends LayDown {
        private Listing listing;
        private DataTypeManager dtManager;
        private SymbolTable symbolTable;
        private Address baseAddr;

        @Override
        public void addEntry(int off32, int off64, String name, DataType dat) {
            int offset;
            int n = offset = this.is64Bit ? off64 : off32;
            if (offset < 0) {
                return;
            }
            Address addr = this.baseAddr.add((long)offset);
            DataType clone = dat.clone(this.dtManager);
            try {
                this.listing.createData(addr, clone);
                this.symbolTable.createLabel(addr, name, SourceType.ANALYSIS);
            }
            catch (CodeUnitInsertionException e) {
                Msg.warn((Object)this, (Object)("Unable to insert TEB field: " + name));
            }
            catch (InvalidInputException e) {
                Msg.warn((Object)this, (Object)("Unable to create TEB symbol name: " + name));
            }
        }

        public LayDownFlat(Program program, Address addr, boolean is64) {
            super(is64);
            this.listing = program.getListing();
            this.dtManager = program.getDataTypeManager();
            this.symbolTable = program.getSymbolTable();
            this.baseAddr = addr;
        }
    }

    public static enum WinVersion {
        WIN_3_10(30010, "Windows 3.10"),
        WIN_3_50(30050, "Windows 3.50"),
        WIN_95(40000, "Windows 95"),
        WIN_2000(50000, "Windows 2000"),
        WIN_XP(50001, "Windows XP"),
        WIN_VISTA(60000, "Windows Vista"),
        WIN_7(60001, "Windows 7"),
        WIN_10(100000, "Windows 10"),
        WIN_LATEST(101900, "Latest");

        private String display;
        private int order;

        private WinVersion(int ord, String disp) {
            this.display = disp;
            this.order = ord;
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return this.display;
        }
    }
}

