/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.ClippingTextField;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.FlowLayoutTextField;
import docking.widgets.fieldpanel.field.ReverseClippingTextField;
import docking.widgets.fieldpanel.field.TextField;
import docking.widgets.fieldpanel.field.VerticalLayoutTextField;
import docking.widgets.fieldpanel.field.WrappingVerticalLayoutTextField;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.AddressFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingFieldHighlightFactoryAdapter;
import ghidra.app.util.viewer.proxy.EmptyProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;

public class ListingTextField
implements ListingField,
TextField {
    private ProxyObj<?> proxy;
    private FieldFactory factory;
    protected TextField field;
    protected ListingFieldHighlightFactoryAdapter hlFactory;

    public static ListingTextField createSingleLineTextField(FieldFactory factory, ProxyObj<?> proxy, FieldElement fieldElement, int startX, int width, ListingHighlightProvider provider) {
        ListingFieldHighlightFactoryAdapter hlFactory = new ListingFieldHighlightFactoryAdapter(provider);
        ClippingTextField field = new ClippingTextField(startX, width, fieldElement, (FieldHighlightFactory)hlFactory);
        ListingTextField listingField = new ListingTextField(factory, proxy, (TextField)field, hlFactory);
        return listingField;
    }

    public static ListingTextField createSingleLineTextFieldWithReverseClipping(AddressFieldFactory factory, ProxyObj<?> proxy, FieldElement fieldElement, int startX, int width, ListingHighlightProvider provider) {
        ListingFieldHighlightFactoryAdapter hlFactory = new ListingFieldHighlightFactoryAdapter(provider);
        ReverseClippingTextField field = new ReverseClippingTextField(startX, width, fieldElement, (FieldHighlightFactory)hlFactory);
        ListingTextField listingField = new ListingTextField(factory, proxy, (TextField)field, hlFactory);
        return listingField;
    }

    public static ListingTextField createWordWrappedTextField(FieldFactory factory, ProxyObj<?> proxy, FieldElement fieldElement, int startX, int width, int maxLines, ListingHighlightProvider provider) {
        ListingFieldHighlightFactoryAdapter hlFactory = new ListingFieldHighlightFactoryAdapter(provider);
        WrappingVerticalLayoutTextField field = new WrappingVerticalLayoutTextField(fieldElement, startX, width, maxLines, (FieldHighlightFactory)hlFactory);
        ListingTextField listingField = new ListingTextField(factory, proxy, (TextField)field, hlFactory);
        return listingField;
    }

    public static ListingTextField createPackedTextField(FieldFactory factory, ProxyObj<?> proxy, FieldElement[] textElements, int startX, int width, int maxLines, ListingHighlightProvider provider) {
        ListingFieldHighlightFactoryAdapter hlFactory = new ListingFieldHighlightFactoryAdapter(provider);
        List<FieldElement> list = Arrays.asList(textElements);
        FlowLayoutTextField field = new FlowLayoutTextField(list, startX, width, maxLines, (FieldHighlightFactory)hlFactory);
        ListingTextField listingField = new ListingTextField(factory, proxy, (TextField)field, hlFactory);
        return listingField;
    }

    public static ListingTextField createMultilineTextField(FieldFactory factory, ProxyObj<?> proxy, FieldElement[] textElements, int startX, int width, int maxLines, ListingHighlightProvider provider) {
        ListingFieldHighlightFactoryAdapter hlFactory = new ListingFieldHighlightFactoryAdapter(provider);
        List<FieldElement> list = Arrays.asList(textElements);
        VerticalLayoutTextField field = new VerticalLayoutTextField(list, startX, width, maxLines, (FieldHighlightFactory)hlFactory);
        ListingTextField listingField = new ListingTextField(factory, proxy, (TextField)field, hlFactory);
        return listingField;
    }

    protected ListingTextField(FieldFactory factory, ProxyObj<?> proxy, TextField field, ListingFieldHighlightFactoryAdapter hlFactory) {
        this.factory = factory;
        this.proxy = proxy;
        this.field = field;
        this.hlFactory = hlFactory;
        hlFactory.setListingField(this);
    }

    public void setPrimary(boolean b) {
        this.field.setPrimary(b);
    }

    public RowColLocation dataToScreenLocation(int dataRow, int dataColumn) {
        return this.field.dataToScreenLocation(dataRow, dataColumn);
    }

    public RowColLocation screenToDataLocation(int screenRow, int screenColumn) {
        return this.field.screenToDataLocation(screenRow, screenColumn);
    }

    public int getWidth() {
        return this.field.getWidth();
    }

    public int getPreferredWidth() {
        return this.field.getPreferredWidth();
    }

    public int getHeight() {
        return this.field.getHeight();
    }

    public int getHeightAbove() {
        return this.field.getHeightAbove();
    }

    public int getHeightBelow() {
        return this.field.getHeightBelow();
    }

    public int getStartX() {
        return this.field.getStartX();
    }

    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager map, RowColLocation cursorLoc, int rowHeight) {
        this.field.paint(c, g, context, clip, map, cursorLoc, rowHeight);
    }

    public boolean contains(int x, int y) {
        return this.field.contains(x, y);
    }

    public int getNumDataRows() {
        return this.field.getNumDataRows();
    }

    public int getNumRows() {
        return this.field.getNumRows();
    }

    public int getNumCols(int row) {
        return this.field.getNumCols(row);
    }

    public int getX(int row, int col) {
        return this.field.getX(row, col);
    }

    public int getY(int row) {
        return this.field.getY(row);
    }

    public int getRow(int y) {
        return this.field.getRow(y);
    }

    public int getCol(int row, int x) {
        return this.field.getCol(row, x);
    }

    public boolean isValid(int row, int col) {
        return this.field.isValid(row, col);
    }

    public Rectangle getCursorBounds(int row, int col) {
        return this.field.getCursorBounds(row, col);
    }

    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        return this.field.getScrollableUnitIncrement(topOfScreen, direction, max);
    }

    public boolean isPrimary() {
        return this.field.isPrimary();
    }

    public void rowHeightChanged(int heightAbove, int heightBelow) {
        this.field.rowHeightChanged(heightAbove, heightBelow);
    }

    public String getText() {
        return this.field.getText();
    }

    public String getTextWithLineSeparators() {
        return this.field.getTextWithLineSeparators();
    }

    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        return this.field.textOffsetToScreenLocation(textOffset);
    }

    public int screenLocationToTextOffset(int row, int col) {
        return this.field.screenLocationToTextOffset(row, col);
    }

    @Override
    public FieldFactory getFieldFactory() {
        return this.factory;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public ProxyObj<?> getProxy() {
        if (this.proxy == null) {
            return EmptyProxy.EMPTY_PROXY;
        }
        return this.proxy;
    }

    public boolean isClipped() {
        return this.field.isClipped();
    }

    @Override
    public Object getClickedObject(FieldLocation fieldLocation) {
        return this.getFieldElement(fieldLocation.row, fieldLocation.col);
    }

    public FieldElement getFieldElement(int screenRow, int screenColumn) {
        return this.field.getFieldElement(screenRow, screenColumn);
    }
}

