/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.functiontype;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;

public class MDCallingConvention
extends MDParsableItem {
    private String convention;
    private boolean exported;

    public MDCallingConvention(MDMang dmang) {
        super(dmang);
    }

    public boolean isExported() {
        return this.exported;
    }

    @Override
    protected void parseInternal() throws MDException {
        char ch = this.dmang.getAndIncrement();
        this.exported = (ch - 65) % 2 == 1;
        switch (ch) {
            case 'A': 
            case 'B': {
                this.dmang.parseInfoPush(1, "__cdecl");
                this.convention = "__cdecl";
                this.dmang.parseInfoPop();
                break;
            }
            case 'C': 
            case 'D': {
                this.dmang.parseInfoPush(1, "__pascal");
                this.convention = "__pascal";
                this.dmang.parseInfoPop();
                break;
            }
            case 'E': 
            case 'F': {
                this.dmang.parseInfoPush(1, "__thiscall");
                this.convention = "__thiscall";
                this.dmang.parseInfoPop();
                break;
            }
            case 'G': 
            case 'H': {
                this.dmang.parseInfoPush(1, "__stdcall");
                this.convention = "__stdcall";
                this.dmang.parseInfoPop();
                break;
            }
            case 'I': 
            case 'J': {
                this.dmang.parseInfoPush(1, "__fastcall");
                this.convention = "__fastcall";
                this.dmang.parseInfoPop();
                break;
            }
            case 'K': 
            case 'L': {
                this.dmang.parseInfoPush(1, "(blank convention)");
                this.convention = "";
                this.dmang.parseInfoPop();
                break;
            }
            case 'M': 
            case 'N': {
                this.dmang.parseInfoPush(1, "__clrcall");
                this.convention = "__clrcall";
                this.dmang.parseInfoPop();
                break;
            }
            case 'O': 
            case 'P': {
                this.dmang.parseInfoPush(1, "__eabi");
                this.convention = "__eabi";
                this.dmang.parseInfoPop();
                break;
            }
            case 'Q': {
                this.dmang.parseInfoPush(1, "__vectorcall");
                this.convention = "__vectorcall";
                this.dmang.parseInfoPop();
                break;
            }
            default: {
                throw new MDException("Unknown calling convention " + ch + "\n");
            }
        }
    }

    @Override
    public void insert(StringBuilder builder) {
        this.dmang.insertString(builder, this.convention);
    }
}

