/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.ClosedException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.ConnectException;

public class SwingExceptionHandler
implements Thread.UncaughtExceptionHandler {
    public void handle(Throwable t) throws Throwable {
        SwingExceptionHandler.handleUncaughtException(t);
    }

    public static void registerHandler() {
        SystemUtilities.runSwingLater(() -> Thread.setDefaultUncaughtExceptionHandler(new SwingExceptionHandler()));
    }

    public static void handleUncaughtException(Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = t.getCause();
        }
        if (t instanceof ThreadDeath) {
            return;
        }
        if (t instanceof ConnectException) {
            return;
        }
        if (t instanceof ClosedException) {
            return;
        }
        Object details = "";
        if (t instanceof OutOfMemoryError) {
            Runtime rt = Runtime.getRuntime();
            details = "\nMemory: free=" + rt.freeMemory() + " max=" + rt.maxMemory() + " total=" + rt.totalMemory();
        } else {
            String message = t.getMessage();
            if (message != null) {
                details = "\n" + t.getClass().getSimpleName() + " - " + message;
            }
        }
        Msg.showError(SwingExceptionHandler.class, null, (String)"Error", (Object)("Uncaught Exception! " + (String)details), (Throwable)t);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        SwingExceptionHandler.handleUncaughtException(e);
    }
}

