/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.program;

import ghidra.app.plugin.match.MatchSymbol;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTScore;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelator;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.List;

public class SymbolNameProgramCorrelator
extends VTAbstractProgramCorrelator {
    private final String name;
    private final boolean oneToOne;

    public SymbolNameProgramCorrelator(ServiceProvider serviceProvider, Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, ToolOptions options, String name, boolean oneToOne) {
        super(serviceProvider, sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options);
        this.name = name;
        this.oneToOne = oneToOne;
    }

    @Override
    protected void doCorrelate(VTMatchSet matchSet, TaskMonitor monitor) throws CancelledException {
        int minSymbolNameLength = this.getOptions().getInt("Minimum Symbol Name Length", 3);
        boolean includeExternals = this.getOptions().getBoolean("Include External Function Symbols", true);
        List matchedSymbols = MatchSymbol.matchSymbol((Program)this.getSourceProgram(), (AddressSetView)this.getSourceAddressSet(), (Program)this.getDestinationProgram(), (AddressSetView)this.getDestinationAddressSet(), (int)minSymbolNameLength, (boolean)this.oneToOne, (boolean)includeExternals, (TaskMonitor)monitor);
        HashMap<AddressMatch, Integer> matchScoreMap = new HashMap<AddressMatch, Integer>();
        monitor.initialize((long)matchedSymbols.size());
        monitor.setMessage("Deduping " + matchedSymbols.size() + " match objects...");
        int skipAmount = 1000;
        int count = 0;
        for (MatchSymbol.MatchedSymbol matchedSymbol : matchedSymbols) {
            monitor.checkCancelled();
            if (++count % skipAmount == 0) {
                monitor.incrementProgress((long)skipAmount);
            }
            AddressMatch addressMatch = new AddressMatch(matchedSymbol);
            int scoreFactor = matchedSymbol.getMatchCount();
            Integer previousScoreFactor = (Integer)matchScoreMap.get(addressMatch);
            if (previousScoreFactor != null && scoreFactor >= previousScoreFactor) continue;
            matchScoreMap.put(addressMatch, scoreFactor);
        }
        monitor.initialize((long)matchScoreMap.size());
        monitor.setMessage("Adding " + matchScoreMap.size() + " match objects...");
        count = 0;
        for (AddressMatch addressMatch : matchScoreMap.keySet()) {
            monitor.checkCancelled();
            if (++count % skipAmount == 0) {
                monitor.incrementProgress((long)skipAmount);
            }
            VTMatchInfo match = this.generateMatchFromMatchedSymbol(matchSet, addressMatch.aAddr, addressMatch.bAddr, (Integer)matchScoreMap.get(addressMatch), addressMatch.matchType);
            matchSet.addMatch(match);
        }
    }

    private VTMatchInfo generateMatchFromMatchedSymbol(VTMatchSet matchSet, Address sourceAddress, Address destinationAddress, int scoreFactor, SymbolType matchType) {
        VTAssociationType associationType;
        int destinationLength;
        int sourceLength;
        VTScore similarity = new VTScore(1.0);
        VTScore confidence = new VTScore(10.0 / (double)scoreFactor);
        if (matchType == SymbolType.FUNCTION) {
            Function sourceFunction = this.getSourceProgram().getFunctionManager().getFunctionAt(sourceAddress);
            Function destinationFunction = this.getDestinationProgram().getFunctionManager().getFunctionAt(destinationAddress);
            sourceLength = (int)sourceFunction.getBody().getNumAddresses();
            destinationLength = (int)destinationFunction.getBody().getNumAddresses();
            associationType = VTAssociationType.FUNCTION;
        } else {
            Data sourceData = this.getSourceProgram().getListing().getDataAt(sourceAddress);
            Data destinationData = this.getDestinationProgram().getListing().getDataAt(destinationAddress);
            sourceLength = sourceData.getLength();
            destinationLength = destinationData.getLength();
            associationType = VTAssociationType.DATA;
        }
        VTMatchInfo match = new VTMatchInfo(matchSet);
        match.setSimilarityScore(similarity);
        match.setConfidenceScore(confidence);
        match.setSourceLength(sourceLength);
        match.setSourceAddress(sourceAddress);
        match.setDestinationLength(destinationLength);
        match.setDestinationAddress(destinationAddress);
        match.setTag(null);
        match.setAssociationType(associationType);
        return match;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static class AddressMatch {
        final SymbolType matchType;
        final Address aAddr;
        final Address bAddr;

        AddressMatch(MatchSymbol.MatchedSymbol matchedSymbol) {
            this.matchType = matchedSymbol.getMatchType();
            this.aAddr = matchedSymbol.getASymbolAddress();
            this.bAddr = matchedSymbol.getBSymbolAddress();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.aAddr.hashCode();
            result = 31 * result + this.bAddr.hashCode();
            result = 31 * result + this.matchType.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AddressMatch)) {
                return false;
            }
            AddressMatch other = (AddressMatch)obj;
            return this.aAddr.equals((Object)other.aAddr) && this.bAddr.equals((Object)other.bAddr) && this.matchType.equals((Object)other.matchType);
        }
    }
}

