/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.rzo.yajsw.io.CircularBuffer;
import org.rzo.yajsw.util.DaemonThreadFactory;
import org.rzo.yajsw.util.MyReentrantLock;

public class TeeInputStream
extends InputStream {
    Source[] sources = new Source[0];
    ReentrantLock lock = new MyReentrantLock();
    Condition dataAvailable = this.lock.newCondition();
    private static final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("TeeInputStream"));

    public synchronized void connect(InputStream source) {
        this.lock.lock();
        Source[] newsources = new Source[this.sources.length + 1];
        for (int i = 0; i < this.sources.length; ++i) {
            if (source == this.sources[i].getInputStream()) {
                this.lock.unlock();
                return;
            }
            newsources[i] = this.sources[i];
        }
        newsources[newsources.length - 1] = new Source(source, this.dataAvailable);
        this.sources = newsources;
        executor.execute(newsources[newsources.length - 1]);
        this.lock.unlock();
    }

    public synchronized void disconnect(InputStream source) {
        this.lock.lock();
        if (this.sources.length == 0) {
            this.lock.unlock();
            return;
        }
        Source[] newsources = new Source[this.sources.length - 1];
        int j = 0;
        boolean removed = false;
        for (int i = 0; i < this.sources.length && j < newsources.length; ++i) {
            if (source != this.sources[i].getInputStream()) {
                newsources[j] = this.sources[i];
                ++j;
                continue;
            }
            removed = true;
        }
        if (removed) {
            this.sources = newsources;
        }
        this.lock.unlock();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read() throws IOException {
        this.lock.lock();
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = 0; i < this.sources.length; ++i) {
                if (this.sources[i].isStop() || this.sources[i].getBuffer().size() <= 0) continue;
                result = this.sources[i].getBuffer().get();
                this.lock.unlock();
                return result;
            }
            try {
                this.dataAvailable.await();
                ** continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.lock.lock();
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = 0; i < this.sources.length; ++i) {
                if (this.sources[i].isStop() || this.sources[i].getBuffer().size() <= 0) continue;
                result = this.sources[i].getBuffer().get(b, off, len);
                this.lock.unlock();
                return result;
            }
            try {
                this.dataAvailable.await();
                ** continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) throws IOException {
        String line;
        TeeInputStream in = new TeeInputStream();
        InputStream inp = System.in;
        System.setIn(in);
        in.connect(inp);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while ((line = reader.readLine()) != null) {
            System.out.println(">" + line);
        }
    }

    class Source
    implements Runnable {
        InputStream in;
        CircularBuffer buffer = new CircularBuffer(512, true);
        byte[] buff = new byte[512];
        volatile boolean stop = false;
        Condition dataAvailable;

        Source(InputStream in, Condition dataAvailable) {
            this.in = in;
            this.dataAvailable = dataAvailable;
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    int c = this.in.read();
                    if (c != -1) {
                        TeeInputStream.this.lock.lock();
                        this.buffer.put((byte)c);
                        try {
                            this.dataAvailable.signal();
                        }
                        catch (Exception ex) {
                            System.err.println("could not read from InputStream " + ex.getMessage());
                        }
                        TeeInputStream.this.lock.unlock();
                        continue;
                    }
                    this.stop = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.stop = true;
                }
            }
        }

        CircularBuffer getBuffer() {
            return this.buffer;
        }

        boolean isStop() {
            return this.stop;
        }

        void close() {
            try {
                this.in.close();
                this.buffer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.stop = true;
        }

        InputStream getInputStream() {
            return this.in;
        }
    }
}

