/*
 * Decompiled with CFR 0.152.
 */
package generic.application;

import generic.jar.ResourceFile;
import ghidra.framework.ApplicationProperties;
import ghidra.framework.GModule;
import ghidra.util.SystemUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import utility.application.ApplicationLayout;
import utility.application.ApplicationUtilities;
import utility.module.ClasspathFilter;
import utility.module.ModuleUtilities;

public class GenericApplicationLayout
extends ApplicationLayout {
    private static final String ADDITIONAL_APPLICATION_ROOT_DIRS = "ADDITIONAL_APPLICATION_ROOT_DIRS";
    private static final String NO_RELEASE_NAME = "NO_RELEASE";
    private static final Pattern CLASS_PATH_MODULE_NAME_PATTERN = Pattern.compile(".*/(\\w+)/bin/main");

    public GenericApplicationLayout(String name, String version) throws FileNotFoundException {
        this(new ApplicationProperties(name, version, NO_RELEASE_NAME));
    }

    public GenericApplicationLayout(ApplicationProperties applicationProperties) throws FileNotFoundException {
        this(GenericApplicationLayout.getDefaultApplicationRootDirs(), applicationProperties);
    }

    public GenericApplicationLayout(Collection<ResourceFile> applicationRootDirs, ApplicationProperties applicationProperties) throws FileNotFoundException {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.applicationRootDirs = applicationRootDirs;
        applicationRootDirs.addAll(this.getAdditionalApplicationRootDirs(applicationRootDirs));
        this.applicationInstallationDir = applicationRootDirs.iterator().next().getParentFile();
        if (SystemUtilities.isInDevelopmentMode()) {
            this.applicationInstallationDir = this.applicationInstallationDir.getParentFile();
        }
        Collection moduleRoots = ModuleUtilities.findModuleRootDirectories(applicationRootDirs);
        HashMap<String, GModule> allModules = new HashMap<String, GModule>();
        Map discoveredModules = ModuleUtilities.findModules(applicationRootDirs, (Collection)moduleRoots, (Predicate)new ClasspathFilter());
        allModules.putAll(discoveredModules);
        for (ResourceFile root : applicationRootDirs) {
            GModule rootModule = new GModule(applicationRootDirs, root);
            allModules.put(rootModule.getName(), rootModule);
        }
        this.modules = Collections.unmodifiableMap(allModules);
        this.userTempDir = ApplicationUtilities.getDefaultUserTempDir((ApplicationProperties)applicationProperties);
        this.userSettingsDir = ApplicationUtilities.getDefaultUserSettingsDir((ApplicationProperties)applicationProperties, (ResourceFile)this.applicationInstallationDir);
    }

    protected Collection<ResourceFile> getAdditionalApplicationRootDirs(Collection<ResourceFile> roots) {
        return Collections.emptyList();
    }

    protected Map<String, GModule> findModules() {
        if (!SystemUtilities.isInDevelopmentMode()) {
            return ModuleUtilities.findModules((Collection)this.applicationRootDirs, (Collection)this.applicationRootDirs);
        }
        Collection roots = ModuleUtilities.findModuleRootDirectories((Collection)this.applicationRootDirs, new ArrayList());
        Map allModules = ModuleUtilities.findModules((Collection)this.applicationRootDirs, (Collection)roots);
        Set<String> cpNames = this.getClassPathModuleNames();
        HashMap<String, GModule> filteredModules = new HashMap<String, GModule>();
        Set entrySet = allModules.entrySet();
        for (Map.Entry entry : entrySet) {
            GModule module = (GModule)entry.getValue();
            if (!cpNames.contains(module.getName())) continue;
            filteredModules.put((String)entry.getKey(), module);
        }
        return filteredModules;
    }

    private Set<String> getClassPathModuleNames() {
        String cp = System.getProperty("java.class.path");
        String[] pathParts = cp.split(File.pathSeparator);
        HashSet<String> paths = new HashSet<String>(Arrays.asList(pathParts));
        HashSet<String> cpNames = new HashSet<String>();
        for (String cpEntry : paths) {
            Matcher matcher = CLASS_PATH_MODULE_NAME_PATTERN.matcher(cpEntry);
            if (!matcher.matches()) continue;
            cpNames.add(matcher.group(1));
        }
        return cpNames;
    }

    public static Collection<ResourceFile> getDefaultApplicationRootDirs() {
        HashSet<ResourceFile> results = new HashSet<ResourceFile>();
        String additionalRootsProperty = System.getProperty(ADDITIONAL_APPLICATION_ROOT_DIRS);
        if (!StringUtils.isBlank((CharSequence)additionalRootsProperty)) {
            String[] paths;
            for (String path : paths = additionalRootsProperty.split(File.pathSeparator)) {
                ResourceFile file = new ResourceFile(path);
                results.add(file);
            }
        }
        if (SystemUtilities.isInDevelopmentMode()) {
            Collection defaultRoots = ApplicationUtilities.findDefaultApplicationRootDirs();
            results.addAll(defaultRoots);
        } else {
            results.add(new ResourceFile(System.getProperty("user.dir")));
        }
        return results;
    }
}

