/*
 * Decompiled with CFR 0.152.
 */
package generic.constraint;

import generic.constraint.Constraint;
import generic.constraint.ConstraintData;
import generic.constraint.DecisionNode;
import generic.constraint.DecisionSet;
import generic.constraint.RootDecisionNode;
import generic.jar.ResourceFile;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DecisionTree<T> {
    private DecisionNode<T> root = new RootDecisionNode();
    private Map<String, Class<? extends Constraint<T>>> constraintClassMap = new HashMap<String, Class<? extends Constraint<T>>>();
    private Set<String> propertyNameSet = new HashSet<String>();

    public DecisionSet getDecisionsSet(T testObject, String propertyName) {
        DecisionSet decisionSet = new DecisionSet(propertyName);
        this.root.populateDecisions(testObject, decisionSet, propertyName);
        return decisionSet;
    }

    public void registerConstraintType(String name, Class<? extends Constraint<T>> constraintClass) {
        this.constraintClassMap.put(name, constraintClass);
    }

    public void registerPropertyName(String propertyName) {
        this.propertyNameSet.add(propertyName);
    }

    public void loadConstraints(String name, InputStream stream) throws IOException, XmlParseException {
        NonThreadedXmlPullParserImpl parser;
        try {
            parser = new NonThreadedXmlPullParserImpl(stream, name, (ErrorHandler)new XMLErrorHandler(), false);
        }
        catch (SAXException e) {
            throw new XmlParseException("Sax Exception", e);
        }
        parser.next();
        this.processSubContraintsAndProperties(this.root, (XmlPullParser)parser);
    }

    public void loadConstraints(ResourceFile file) throws FileNotFoundException, IOException, XmlParseException {
        InputStream inputStream = file.getInputStream();
        String name = file.getName();
        this.loadConstraints(name, inputStream);
        inputStream.close();
    }

    private void processSubContraintsAndProperties(DecisionNode<T> parent, XmlPullParser parser) throws XmlParseException {
        XmlElement element = parser.next();
        while (!element.isEnd()) {
            Constraint<T> constraint = this.readConstraint(element);
            if (constraint != null) {
                DecisionNode<T> node = parent.getOrCreateNodeForContraint(constraint);
                this.processSubContraintsAndProperties(node, parser);
            } else if (this.propertyNameSet.contains(element.getName())) {
                this.processPropertyElement(parent, element, parser);
            } else {
                throw new XmlParseException("Unknown element tag: " + element.getName());
            }
            element = parser.next();
        }
    }

    private Constraint<T> getConstraint(String name) throws XmlParseException {
        Class<Constraint<T>> constraintClass = this.constraintClassMap.get(name);
        if (constraintClass == null) {
            return null;
        }
        try {
            return constraintClass.newInstance();
        }
        catch (Exception e) {
            throw new XmlParseException("Can't create constraint instance for class " + constraintClass.getName(), e);
        }
    }

    private void processPropertyElement(DecisionNode<T> node, XmlElement element, XmlPullParser parser) throws XmlParseException {
        String propertyName = element.getName();
        XmlElement nextElement = parser.next();
        if (!nextElement.isEnd()) {
            throw new XmlParseException("Expected end tag for property " + propertyName);
        }
        node.setProperty(propertyName, nextElement.getText(), parser.getName());
    }

    private Constraint<T> readConstraint(XmlElement element) throws XmlParseException {
        String name = element.getName();
        Constraint<T> constraint = this.getConstraint(name);
        if (constraint == null) {
            return null;
        }
        constraint.loadConstraintData(new ConstraintData(element.getAttributes()));
        return constraint;
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        private XMLErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException("Error: " + exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException("Fatal error: " + exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw new SAXException("Warning: " + exception);
        }
    }
}

