/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.workflow;

import ghidra.app.plugin.core.debug.workflow.AbstractMapDebuggerBot;
import ghidra.app.services.DebuggerBotInfo;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.MapProposal;
import ghidra.app.services.SectionMapProposal;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@DebuggerBotInfo(description="Map sections to open programs", details="Monitors open traces and programs, attempting to map sections by \"best\" match.", help=@HelpInfo(anchor="map_sections"), enabledByDefault=false)
public class MapSectionsDebuggerBot
extends AbstractMapDebuggerBot {
    @Override
    protected Collection<TraceChangeType<?, ?>> getChangeTypes() {
        return List.of(Trace.TraceSectionChangeType.ADDED);
    }

    @Override
    protected void doAnalysis(PluginTool tool, Trace trace, Set<Program> programs, TaskMonitor monitor) throws CancelledException {
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)tool.getService(DebuggerStaticMappingService.class);
        if (mappingService != null) {
            Map<TraceModule, SectionMapProposal> maps = mappingService.proposeSectionMaps(trace.getModuleManager().getAllModules(), programs);
            Collection<SectionMapProposal.SectionMapEntry> entries = MapProposal.flatten(maps.values());
            entries = MapProposal.removeOverlapping(entries);
            mappingService.addSectionMappings(entries, monitor, false);
        }
    }
}

