/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import generic.concurrent.QCallback;
import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.parallel.DecompilerCallback;
import ghidra.app.decompiler.parallel.ParallelDecompiler;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.FunctionUtility;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GolangDuffFixupAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Golang Duff Function Fixup";
    private static final String DESCRIPTION = "Propagates function signature information from the base runtime.duffcopy and runtime.duffzero functions to the other entry points that were discovered during analysis.";
    private Program program;
    private TaskMonitor monitor;
    private MessageLog log;

    public GolangDuffFixupAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FUNCTION_ANALYSIS.after());
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        return "golang".equals(program.getCompilerSpec().getCompilerSpecDescription().getCompilerSpecName());
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.program = program;
        this.monitor = monitor;
        this.log = log;
        Symbol duffzeroSym = SymbolUtilities.getUniqueSymbol((Program)program, (String)"runtime.duffzero");
        Function duffzeroFunc = duffzeroSym != null ? (Function)duffzeroSym.getObject() : null;
        Symbol duffcopySym = SymbolUtilities.getUniqueSymbol((Program)program, (String)"runtime.duffcopy");
        Function duffcopyFunc = duffcopySym != null ? (Function)duffcopySym.getObject() : null;
        ArrayList<Function> funcs = new ArrayList<Function>();
        if (duffzeroFunc != null && duffzeroFunc.getCallingConvention() != null) {
            funcs.add(duffzeroFunc);
        }
        if (duffcopyFunc != null && duffcopyFunc.getCallingConvention() != null) {
            funcs.add(duffcopyFunc);
        }
        if (funcs.isEmpty()) {
            return true;
        }
        Map<Address, AddressSetView> map = this.getFunctionActualRanges(funcs);
        if (duffzeroFunc != null) {
            this.updateDuffFuncs(duffzeroFunc, map.get(duffzeroFunc.getEntryPoint()));
        }
        if (duffcopyFunc != null) {
            this.updateDuffFuncs(duffcopyFunc, map.get(duffcopyFunc.getEntryPoint()));
        }
        return true;
    }

    private void updateDuffFuncs(Function duffFunc, AddressSetView duffFuncBody) {
        if (duffFunc == null || duffFuncBody == null) {
            return;
        }
        String duffComment = this.program.getListing().getCodeUnitAt(duffFunc.getEntryPoint()).getComment(3);
        FunctionIterator funcIt = this.program.getFunctionManager().getFunctions(duffFuncBody, true);
        while (funcIt.hasNext()) {
            Function func = (Function)funcIt.next();
            if (!FunctionUtility.isDefaultFunctionName((Function)func)) continue;
            try {
                func.setName(duffFunc.getName() + "_" + func.getEntryPoint(), SourceType.ANALYSIS);
                func.updateFunction(duffFunc.getCallingConventionName(), (Variable)duffFunc.getReturn(), Arrays.asList(duffFunc.getParameters()), Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.ANALYSIS);
                if (duffComment == null || duffComment.isBlank()) continue;
                new SetCommentCmd(func.getEntryPoint(), 3, duffComment).applyTo((DomainObject)this.program);
            }
            catch (DuplicateNameException | InvalidInputException e) {
                this.log.appendMsg("Error updating duff functions");
                this.log.appendException(e);
            }
        }
    }

    private void configureDecompiler(DecompInterface decompiler) {
        decompiler.toggleCCode(false);
        decompiler.toggleSyntaxTree(true);
        decompiler.setSimplificationStyle("normalize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Address, AddressSetView> getFunctionActualRanges(List<Function> funcs) {
        DecompilerCallback<HighFunctionAddresses> callback = new DecompilerCallback<HighFunctionAddresses>(this.program, this::configureDecompiler){

            public HighFunctionAddresses process(DecompileResults results, TaskMonitor tMonitor) throws Exception {
                tMonitor.checkCancelled();
                if (results == null) {
                    return null;
                }
                Function func = results.getFunction();
                HighFunction highFunc = results.getHighFunction();
                if (func == null || highFunc == null) {
                    return null;
                }
                AddressSet funcAddrs = new AddressSet();
                for (PcodeBlockBasic bb : highFunc.getBasicBlocks()) {
                    funcAddrs.add(bb.getStart(), bb.getStop());
                }
                return new HighFunctionAddresses(func.getEntryPoint(), (AddressSetView)funcAddrs);
            }
        };
        try {
            Map<Address, AddressSetView> results;
            List funcAddresses = ParallelDecompiler.decompileFunctions((QCallback)callback, funcs, (TaskMonitor)this.monitor);
            Map<Address, AddressSetView> map = results = funcAddresses.stream().collect(Collectors.toMap(hfa -> hfa.functionEntry, hfa -> hfa.functionAddresses));
            return map;
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Error: could not decompile functions with ParallelDecompiler", (Throwable)e);
            Map<Address, AddressSetView> map = Map.of();
            return map;
        }
        finally {
            callback.dispose();
        }
    }

    record HighFunctionAddresses(Address functionEntry, AddressSetView functionAddresses) {
    }
}

