/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.rmi.trace;

import ghidra.app.plugin.core.debug.service.rmi.trace.OpenTrace;
import ghidra.app.plugin.core.debug.service.rmi.trace.ValueDecoder;
import ghidra.util.Swing;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RemoteAsyncResult
extends CompletableFuture<Object> {
    final ValueDecoder decoder;

    public RemoteAsyncResult() {
        this.decoder = ValueDecoder.DEFAULT;
    }

    public RemoteAsyncResult(OpenTrace open) {
        this.decoder = open;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        if (Swing.isSwingThread()) {
            throw new AssertionError((Object)"Refusing indefinite wait on Swing thread");
        }
        return super.get();
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (Swing.isSwingThread() && unit.toSeconds(timeout) > 1L) {
            throw new AssertionError((Object)"Refusing a timeout > 1 second on Swing thread");
        }
        return super.get(timeout, unit);
    }
}

