/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.markuptype;

import ghidra.feature.vt.api.impl.MarkupItemImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;

public abstract class VTMarkupType {
    static final ToolOptions VT_UNAPPLY_MARKUP_OPTIONS = new ToolOptions("Version Tracking");
    private final String name;

    public VTMarkupType(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public abstract boolean supportsAssociationType(VTAssociationType var1);

    public abstract List<VTMarkupItem> createMarkupItems(VTAssociation var1);

    public abstract boolean applyMarkup(VTMarkupItem var1, ToolOptions var2) throws VersionTrackingApplyException;

    public abstract void unapplyMarkup(VTMarkupItem var1) throws VersionTrackingApplyException;

    public abstract VTMarkupItemApplyActionType getApplyAction(ToolOptions var1);

    public abstract boolean supportsApplyAction(VTMarkupItemApplyActionType var1);

    public Address validateDestinationAddress(VTAssociation association, Address sourceAddress, Address suggestedDestinationAddress) {
        return suggestedDestinationAddress;
    }

    public abstract ProgramLocation getSourceLocation(VTAssociation var1, Address var2);

    public abstract Stringable getSourceValue(VTAssociation var1, Address var2);

    public abstract ProgramLocation getDestinationLocation(VTAssociation var1, Address var2);

    public abstract Stringable getCurrentDestinationValue(VTAssociation var1, Address var2);

    public abstract Stringable getOriginalDestinationValue(VTAssociation var1, Address var2);

    protected Stringable getOriginalDestinationValueForAppliedMarkupOfThisType(VTAssociation association, Address destinationAddress, TaskMonitor monitor) throws CancelledException {
        if (destinationAddress == null || destinationAddress == Address.NO_ADDRESS) {
            return null;
        }
        Collection<VTMarkupItem> markupItems = association.getMarkupItems(monitor);
        for (VTMarkupItem markupItem : markupItems) {
            Address itemDestination;
            if (markupItem.getMarkupType() != this || !markupItem.canUnapply() || !destinationAddress.equals((Object)(itemDestination = markupItem.getDestinationAddress()))) continue;
            return markupItem.getOriginalDestinationValue();
        }
        return null;
    }

    public abstract boolean hasSameSourceAndDestinationValues(VTMarkupItem var1);

    public Program getDestinationProgram(VTAssociation association) {
        VTSession session = association.getSession();
        return session.getDestinationProgram();
    }

    public Program getSourceProgram(VTAssociation association) {
        VTSession session = association.getSession();
        return session.getSourceProgram();
    }

    public Listing getDestinationListing(VTAssociation association) {
        Program program = this.getDestinationProgram(association);
        return program.getListing();
    }

    public Listing getSourceListing(VTAssociation association) {
        Program program = this.getSourceProgram(association);
        return program.getListing();
    }

    public Function getSourceFunction(VTAssociation association) {
        VTSession session = association.getSession();
        Program program = session.getSourceProgram();
        Address sourceAddress = association.getSourceAddress();
        FunctionManager functionManager = program.getFunctionManager();
        return functionManager.getFunctionAt(sourceAddress);
    }

    public Function getDestinationFunction(VTAssociation association) {
        VTSession session = association.getSession();
        Program program = session.getDestinationProgram();
        Address destinationAddress = association.getDestinationAddress();
        FunctionManager functionManager = program.getFunctionManager();
        return functionManager.getFunctionAt(destinationAddress);
    }

    public Address getAddress(ProgramLocation loc, Program program) {
        return loc.getAddress();
    }

    public boolean conflictsWithOtherMarkup(MarkupItemImpl markupItem, Collection<VTMarkupItem> markupItems) {
        return false;
    }

    public abstract Options convertOptionsToForceApplyOfMarkupItem(VTMarkupItemApplyActionType var1, ToolOptions var2);

    static {
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Function Signature", (Enum)VTMatchApplyChoices.FunctionSignatureChoices.REPLACE);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Function Calling Convention", (Enum)VTMatchApplyChoices.CallingConventionChoices.NAME_MATCH);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Function Inline", (Enum)VTMatchApplyChoices.ReplaceChoices.REPLACE);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Function No Return", (Enum)VTMatchApplyChoices.ReplaceChoices.REPLACE);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Function Var Args", (Enum)VTMatchApplyChoices.ReplaceChoices.REPLACE);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Function Call Fixup", (Enum)VTMatchApplyChoices.ReplaceChoices.REPLACE);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Function Return Type", (Enum)VTMatchApplyChoices.ParameterDataTypeChoices.REPLACE);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Function Parameter Data Types", (Enum)VTMatchApplyChoices.ParameterDataTypeChoices.REPLACE);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Function Parameter Names", (Enum)VTMatchApplyChoices.SourcePriorityChoices.REPLACE);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Function Parameter Comments", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.REPLACE_ALWAYS);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Labels", (Enum)VTMatchApplyChoices.LabelChoices.REPLACE_ALL);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Plate Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Pre Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.End of Line Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Repeatable Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Post Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        VT_UNAPPLY_MARKUP_OPTIONS.setEnum("Apply Markup Options.Data Match Data Type", (Enum)VTMatchApplyChoices.ReplaceDataChoices.REPLACE_ALL_DATA);
    }
}

