/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.MultiLineLabel;
import docking.widgets.list.ListPanel;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.function.Function;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;

public class SelectFromListDialog<T>
extends DialogComponentProvider {
    private boolean actionComplete = false;
    private ListPanel listPanel;
    private T selectedObject;
    private List<T> list;
    private Function<T, String> toStringFunc;

    public static <T> T selectFromList(List<T> list, String title, String prompt, Function<T, String> toStringFunction) {
        SelectFromListDialog dialog = new SelectFromListDialog(title, prompt, list, toStringFunction);
        SystemUtilities.runSwingNow(() -> dialog.doSelect());
        return dialog.actionComplete ? (T)dialog.getSelectedObject() : null;
    }

    public SelectFromListDialog(String title, String prompt, List<T> list, Function<T, String> toStringFunc) {
        super(title, true);
        this.list = list;
        this.toStringFunc = toStringFunc;
        this.addWorkPanel(this.buildWorkPanel(prompt));
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
    }

    @Override
    protected void okCallback() {
        if (this.checkInput()) {
            this.actionComplete = true;
            this.close();
        }
    }

    private boolean checkInput() {
        return this.listPanel.getSelectedIndex() != -1;
    }

    public T getSelectedObject() {
        return this.selectedObject;
    }

    public void setSelectedObject(T obj) {
        this.listPanel.setSelectedValue(obj);
    }

    private void doSelect() {
        this.selectedObject = null;
        this.actionComplete = false;
        DockingWindowManager.showDialog(this);
        if (this.actionComplete) {
            this.selectedObject = this.list.get(this.listPanel.getSelectedIndex());
        }
    }

    private JPanel buildWorkPanel(String prompt) {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>(){

            @Override
            public String getElementAt(int index) {
                Object t = super.getElementAt(index);
                return SelectFromListDialog.this.toStringFunc.apply(t);
            }
        };
        for (T obj : this.list) {
            listModel.addElement(obj);
        }
        this.listPanel = new ListPanel();
        this.listPanel.setListModel(listModel);
        this.listPanel.setSelectionMode(0);
        this.listPanel.setSelectedIndex(0);
        this.listPanel.setDoubleClickActionListener(e -> this.okCallback());
        JPanel workPanel = new JPanel(new BorderLayout());
        MultiLineLabel mll = new MultiLineLabel("\n" + prompt + ":");
        workPanel.add((Component)mll, "North");
        workPanel.add((Component)this.listPanel, "Center");
        return workPanel;
    }
}

