/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import generic.FilteredIterator;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.function.FunctionAdapter;
import ghidra.program.database.function.FunctionDB;
import ghidra.program.database.function.FunctionTagManagerDB;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.function.ThunkFunctionAdapter;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.ReferenceDBManager;
import ghidra.program.database.symbol.NamespaceManager;
import ghidra.program.database.symbol.OverlappingNamespaceException;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.database.symbol.VariableSymbolDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.FunctionTagManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class FunctionManagerDB
implements FunctionManager {
    private final String CALLFIXUP_MAP = "CallFixup";
    private ProgramDB program;
    private DBHandle dbHandle;
    private AddressMap addrMap;
    private DBObjectCache<FunctionDB> cache;
    private FunctionAdapter adapter;
    private ThunkFunctionAdapter thunkAdapter;
    private NamespaceManager namespaceMgr;
    private SymbolManager symbolMgr;
    private CodeManager codeMgr;
    private DataTypeManagerDB dtMgr;
    private FunctionTagManagerDB functionTagManager;
    private Namespace globalNamespace;
    private Predicate<Function> functionFilter = f -> {
        CodeUnit codeUnitAt;
        return f != null && (codeUnitAt = this.program.getListing().getCodeUnitAt(f.getEntryPoint())) != null && codeUnitAt instanceof Instruction;
    };
    private StringPropertyMap callFixupMap;
    private long lastFuncID = -1L;
    Lock lock;
    int oldAdapterVersion;

    public FunctionManagerDB(DBHandle dbHandle, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        this.dbHandle = dbHandle;
        this.addrMap = addrMap;
        this.lock = lock;
        this.cache = new DBObjectCache(20);
        this.initializeAdapters(openMode, monitor);
        this.functionTagManager = new FunctionTagManagerDB(dbHandle, openMode, lock, monitor);
    }

    private void initializeAdapters(int openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        try {
            FunctionAdapter oldAdapter = FunctionAdapter.findReadOnlyAdapter(this.dbHandle, this.addrMap);
            this.oldAdapterVersion = oldAdapter.getVersion();
        }
        catch (VersionException e) {
            this.oldAdapterVersion = -1;
        }
        this.adapter = FunctionAdapter.getAdapter(this.dbHandle, openMode, this.addrMap, monitor);
        this.thunkAdapter = ThunkFunctionAdapter.getAdapter(this.dbHandle, openMode, this.addrMap, monitor);
    }

    @Override
    public ProgramDB getProgram() {
        return this.program;
    }

    FunctionAdapter getFunctionAdapter() {
        return this.adapter;
    }

    @Override
    public Collection<String> getCallingConventionNames() {
        return this.dtMgr.getDefinedCallingConventionNames();
    }

    @Override
    public PrototypeModel getDefaultCallingConvention() {
        CompilerSpec compilerSpec = this.program.getCompilerSpec();
        return compilerSpec.getDefaultCallingConvention();
    }

    @Override
    public PrototypeModel getCallingConvention(String name) {
        CompilerSpec compilerSpec = this.program.getCompilerSpec();
        return compilerSpec.getCallingConvention(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function createExternalFunction(Address extSpaceAddr, String name, Namespace nameSpace, String extData, SourceType source) throws InvalidInputException {
        this.lock.acquire();
        try {
            Symbol symbol = this.symbolMgr.createFunctionSymbol(extSpaceAddr, name, nameSpace, source, extData);
            long returnDataTypeId = this.program.getDataTypeManager().getResolvedID(DataType.DEFAULT);
            try {
                DBRecord rec = this.adapter.createFunctionRecord(symbol.getID(), returnDataTypeId);
                FunctionDB funcDB = new FunctionDB(this, this.cache, this.addrMap, rec);
                this.program.setObjChanged(150, extSpaceAddr, (Object)funcDB, null, null);
                FunctionDB functionDB = funcDB;
                return functionDB;
            }
            catch (IOException e) {
                this.dbError(e);
                Function function = null;
                this.lock.release();
                return function;
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Function createFunction(String name, Address entryPoint, AddressSetView body, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        return this.createFunction(name, this.globalNamespace, entryPoint, body, null, source);
    }

    @Override
    public Function createFunction(String name, Namespace nameSpace, Address entryPoint, AddressSetView body, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        return this.createFunction(name, nameSpace, entryPoint, body, null, source);
    }

    @Override
    public Function createThunkFunction(String name, Namespace nameSpace, Address entryPoint, AddressSetView body, Function thunkedFunction, SourceType source) throws OverlappingFunctionException {
        try {
            return this.createFunction(name, nameSpace, entryPoint, body, thunkedFunction, source);
        }
        catch (InvalidInputException e) {
            throw new RuntimeException("Unexpected for default named function", e);
        }
    }

    static void checkSingleAddressSpaceOnly(AddressSetView set) {
        if (set.getMinAddress().getAddressSpace() != set.getMaxAddress().getAddressSpace()) {
            throw new IllegalArgumentException("Function body must contain single address space only");
        }
    }

    /*
     * Exception decompiling
     */
    private Function createFunction(String name, Namespace nameSpace, Address entryPoint, AddressSetView body, Function thunkedFunction, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setThunkedFunction(FunctionDB function, FunctionDB referencedFunction) throws IllegalArgumentException {
        if (function.isExternal()) {
            throw new UnsupportedOperationException("External functions may not be a thunk");
        }
        try {
            if (referencedFunction == null) {
                if (!function.isThunk()) {
                    return;
                }
                this.thunkAdapter.removeThunkRecord(function.getKey());
                function.setInvalid();
            } else {
                Function endFunction;
                FunctionDB refFunc = (FunctionDB)this.getFunctionAt(referencedFunction.getEntryPoint());
                if (refFunc != referencedFunction) {
                    throw new IllegalArgumentException("thunkedFunction not found within program");
                }
                referencedFunction.checkDeleted();
                for (endFunction = referencedFunction; endFunction != function && endFunction.isThunk(); endFunction = endFunction.getThunkedFunction(false)) {
                }
                if (endFunction == function) {
                    throw new IllegalArgumentException("Cannot create a thunk function which results in loop to itself");
                }
                Symbol s = function.getSymbol();
                String oldName = s.getName();
                this.thunkAdapter.createThunkRecord(function.getKey(), referencedFunction.getKey());
                function.setInvalid();
                if (s.getSource() == SourceType.DEFAULT) {
                    this.program.symbolChanged(s, 46, function.getEntryPoint(), s, oldName, s.getName());
                }
            }
            this.program.setObjChanged(152, 7, function.getEntryPoint(), function, null, null);
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    CodeManager getCodeManager() {
        return this.codeMgr;
    }

    @Override
    public int getFunctionCount() {
        return this.adapter.getRecordCount();
    }

    @Override
    public boolean removeFunction(Address entryPoint) {
        FunctionDB func = (FunctionDB)this.getFunctionAt(entryPoint);
        if (func != null) {
            return func.getSymbol().delete();
        }
        return false;
    }

    public void functionTagsChanged() {
        this.invalidateCache(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void functionNamespaceChanged(long key) {
        this.lock.acquire();
        try {
            FunctionDB func = this.cache.get(key);
            if (func != null) {
                func.checkDeleted();
                func.createClassStructIfNeeded();
                func.updateParametersAndReturn();
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doRemoveFunction(long key) {
        this.lock.acquire();
        try {
            DBRecord rec;
            Symbol s;
            FunctionDB function = (FunctionDB)this.getFunction(key);
            if (function == null) {
                boolean bl = false;
                return bl;
            }
            this.thunkAdapter.removeThunkRecord(key);
            function.setInvalid();
            RecordIterator thunks = this.thunkAdapter.iterateThunkRecords(key);
            if (thunks.hasNext() && (s = this.symbolMgr.getSymbol((rec = thunks.next()).getKey())) != null) {
                s.delete();
            }
            Address entryPoint = function.getEntryPoint();
            function.setCallFixup(null);
            AddressSet body = new AddressSet(function.getBody());
            this.removeVariableRefs(function, body);
            this.namespaceMgr.removeBody(function);
            int n = function.getParameterCount();
            for (int i = n - 1; i >= 0; --i) {
                function.removeParameter(i);
            }
            for (FunctionTag tag : function.getTags()) {
                function.removeTag(tag.getName());
            }
            long functionID = function.getID();
            this.adapter.removeFunctionRecord(functionID);
            this.cache.delete(functionID);
            this.program.setObjChanged(151, entryPoint, (Object)function, (Object)body, null);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function getFunction(long key) {
        this.lock.acquire();
        try {
            this.lastFuncID = key;
            FunctionDB func = this.cache.get(key);
            if (func == null) {
                try {
                    DBRecord rec = this.adapter.getFunctionRecord(key);
                    if (rec != null) {
                        func = new FunctionDB(this, this.cache, this.addrMap, rec);
                    }
                }
                catch (IOException e) {
                    this.dbError(e);
                }
            }
            FunctionDB functionDB = func;
            return functionDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Function getReferencedFunction(Address address) {
        Function function = this.getFunctionAt(address);
        if (function != null) {
            return function;
        }
        Data data = this.codeMgr.getDataContaining(address);
        if (data == null) {
            return null;
        }
        Reference ref = this.program.getReferenceManager().getPrimaryReferenceFrom(address, 0);
        return ref != null ? this.getFunctionAt(ref.getToAddress()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function getFunctionAt(Address entryPoint) {
        this.lock.acquire();
        try {
            FunctionDB function;
            if (this.lastFuncID != -1L && (function = this.cache.get(this.lastFuncID)) != null && function.getEntryPoint().equals(entryPoint)) {
                FunctionDB functionDB = function;
                return functionDB;
            }
            Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(entryPoint);
            if (symbol != null && symbol.getSymbolType() == SymbolType.FUNCTION) {
                Function function2 = this.getFunction(symbol.getID());
                return function2;
            }
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function getFunctionContaining(Address addr) {
        if (addr.isExternalAddress()) {
            return this.getFunctionAt(addr);
        }
        this.lock.acquire();
        try {
            Symbol symbol;
            FunctionDB func;
            if (this.lastFuncID != -1L && (func = this.cache.get(this.lastFuncID)) != null && func.getBody().contains(addr)) {
                FunctionDB functionDB = func;
                return functionDB;
            }
            Namespace scope = this.namespaceMgr.getNamespaceContaining(addr);
            for (symbol = scope.getSymbol(); symbol != null && symbol.getSymbolType() != SymbolType.FUNCTION; symbol = symbol.getParentSymbol()) {
            }
            if (symbol == null) {
                Function function = null;
                return function;
            }
            Function function = this.getFunction(symbol.getID());
            return function;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public FunctionIterator getFunctions(boolean forward) {
        return new FunctionIteratorDB(false, forward);
    }

    @Override
    public FunctionIterator getFunctions(Address start, boolean foward) {
        return new FunctionIteratorDB(start, foward);
    }

    @Override
    public FunctionIterator getFunctions(AddressSetView asv, boolean forward) {
        return new FunctionIteratorDB(asv, forward);
    }

    @Override
    public FunctionIterator getFunctionsNoStubs(boolean forward) {
        return new FunctionFilteredIterator(new FunctionIteratorDB(false, forward));
    }

    @Override
    public FunctionIterator getFunctionsNoStubs(Address start, boolean foward) {
        return new FunctionFilteredIterator(new FunctionIteratorDB(start, foward));
    }

    @Override
    public FunctionIterator getFunctionsNoStubs(AddressSetView asv, boolean forward) {
        return new FunctionFilteredIterator(new FunctionIteratorDB(asv, forward));
    }

    @Override
    public FunctionIterator getExternalFunctions() {
        return new FunctionIteratorDB(true, true);
    }

    @Override
    public boolean isInFunction(Address addr) {
        if (!addr.isMemoryAddress()) {
            return false;
        }
        return this.getFunctionContaining(addr) != null;
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        this.invalidateCache(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            Iterator<Function> iter = this.getFunctionsOverlapping(new AddressSet(startAddr, endAddr));
            while (iter.hasNext()) {
                monitor.checkCancelled();
                FunctionDB func = (FunctionDB)iter.next();
                this.removeFunction(func.getEntryPoint());
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
        this.namespaceMgr = program.getNamespaceManager();
        this.codeMgr = program.getCodeManager();
        this.dtMgr = program.getDataTypeManager();
        this.symbolMgr = program.getSymbolTable();
        this.globalNamespace = program.getGlobalNamespace();
        this.functionTagManager.setProgram(program);
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        if (openMode == 3) {
            this.upgradeAllDotDotDots(monitor);
        }
    }

    private VariableStorage checkDynamicStorageConversion(DataType returnDataType, Parameter[] currentParams, int paramOffset, PrototypeModel callingConvention) {
        DataType[] types = new DataType[currentParams.length - paramOffset + 1];
        types[0] = returnDataType;
        int index = 1;
        for (int i = paramOffset; i < currentParams.length; ++i) {
            types[index++] = currentParams[i].getDataType();
        }
        VariableStorage[] paramStorage = callingConvention.getStorageLocations(this.program, types, true);
        int n = index = paramStorage.length == types.length ? 1 : 2;
        if (paramStorage.length - 1 != types.length) {
            return paramStorage[0];
        }
        for (int i = 0; i < currentParams.length; ++i) {
            if (currentParams[i].getVariableStorage().equals(paramStorage[i + 1])) continue;
            return paramStorage[0];
        }
        return null;
    }

    public void initSignatureSource(TaskMonitor monitor) throws CancelledException, IOException {
        PrototypeModel defaultConvention = this.getDefaultCallingConvention();
        FunctionIterator functions = this.getFunctions(false);
        while (functions.hasNext()) {
            monitor.checkCancelled();
            FunctionDB func = (FunctionDB)functions.next();
            func.setSignatureSource(func.getInferredSignatureSource());
            PrototypeModel callingConvention = func.getCallingConvention();
            if (callingConvention == null) {
                callingConvention = defaultConvention;
            }
            if (callingConvention == null) continue;
            boolean useDynamic = false;
            DataType returnDataType = func.getReturnDataType();
            Parameter[] params = func.getParameters();
            VariableStorage returnStorage = null;
            if ("__thiscall".equals(func.getCallingConventionName())) {
                if (params.length != 0 && this.isLikelyThisParam(params[0]) && (returnStorage = this.checkDynamicStorageConversion(returnDataType, params, 1, callingConvention)) == null) {
                    useDynamic = true;
                    func.removeVariable(params[0]);
                }
            } else {
                returnStorage = this.checkDynamicStorageConversion(returnDataType, params, 0, callingConvention);
                boolean bl = useDynamic = returnStorage == null;
            }
            if (useDynamic) {
                func.setCustomVariableStorage(false);
                continue;
            }
            if (returnStorage == null || returnStorage.isUnassignedStorage()) continue;
            func.setReturnStorageAndDataType(returnStorage, returnDataType);
        }
    }

    private boolean isLikelyThisParam(Parameter param) {
        if (Function.THIS_PARAM_NAME.equals(param.getName())) {
            return true;
        }
        if (param.getSource() == SourceType.DEFAULT) {
            DataType dt = param.getDataType();
            if (dt instanceof Pointer) {
                return true;
            }
            if (dt instanceof AbstractIntegerDataType || dt instanceof Undefined) {
                int pointerSize = this.program.getDataTypeManager().getDataOrganization().getPointerSize();
                return dt.getLength() == pointerSize;
            }
        }
        return false;
    }

    public void removeExplicitThisParameters(TaskMonitor monitor) throws CancelledException, IOException {
        FunctionDB func;
        FunctionIterator functions = this.getFunctions(false);
        while (functions.hasNext()) {
            monitor.checkCancelled();
            func = (FunctionDB)functions.next();
            this.removeExplicitThisParameters(func);
        }
        functions = this.getExternalFunctions();
        while (functions.hasNext()) {
            monitor.checkCancelled();
            func = (FunctionDB)functions.next();
            this.removeExplicitThisParameters(func);
        }
    }

    private void removeExplicitThisParameters(FunctionDB func) {
        if (func.isThunk() || !"__thiscall".equals(func.getCallingConventionName()) || func.hasCustomVariableStorage()) {
            return;
        }
        for (Parameter param : func.getParameters()) {
            if (param.isAutoParameter()) continue;
            if (!this.isLikelyThisParam(param)) break;
            func.removeVariable(param);
            break;
        }
    }

    @Override
    public void invalidateCache(boolean all) {
        this.lock.acquire();
        try {
            this.functionTagManager.invalidateCache();
            this.callFixupMap = null;
            this.lastFuncID = -1L;
            this.cache.invalidate();
        }
        finally {
            this.lock.release();
        }
    }

    StringPropertyMap getCallFixupMap(boolean create) {
        if (this.callFixupMap != null) {
            return this.callFixupMap;
        }
        PropertyMapManager usrPropertyManager = this.program.getUsrPropertyManager();
        this.callFixupMap = usrPropertyManager.getStringPropertyMap("CallFixup");
        if (this.callFixupMap == null && create) {
            try {
                this.callFixupMap = usrPropertyManager.createStringPropertyMap("CallFixup");
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)"Failed to define CallFixup due to conflicting property map name");
            }
        }
        if (this.callFixupMap != null) {
            // empty if block
        }
        return this.callFixupMap;
    }

    void functionChanged(FunctionDB func, int subEventType) {
        this.program.setObjChanged(152, subEventType, func.getEntryPoint(), func, null, null);
        List<Long> thunkFunctionIds = this.getThunkFunctionIds(func.getKey());
        if (thunkFunctionIds != null) {
            for (long key : thunkFunctionIds) {
                Function thunk = this.getFunction(key);
                if (thunk == null) continue;
                this.program.setObjChanged(152, subEventType, thunk.getEntryPoint(), thunk, null, null);
            }
        }
    }

    void dbError(IOException e) {
        this.program.dbError(e);
    }

    @Override
    public Iterator<Function> getFunctionsOverlapping(AddressSetView set) {
        Iterator<Namespace> it = this.namespaceMgr.getNamespacesOverlapping(set);
        ArrayList<Function> list = new ArrayList<Function>();
        while (it.hasNext()) {
            Function f;
            Namespace scope = it.next();
            Symbol symbol = scope.getSymbol();
            if (symbol == null || symbol.getSymbolType() != SymbolType.FUNCTION || (f = this.getFunction(symbol.getID())) == null) continue;
            list.add(f);
        }
        return list.iterator();
    }

    void setFunctionBody(FunctionDB function, AddressSetView newBody) throws OverlappingFunctionException {
        Address entryPoint = function.getEntryPoint();
        if (entryPoint.isExternalAddress()) {
            throw new UnsupportedOperationException("Body may not be set on external function");
        }
        if (newBody == null || !newBody.contains(entryPoint)) {
            throw new IllegalArgumentException("body must contain the entry point");
        }
        if (newBody.getNumAddresses() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Function body size must be <= 0x7fffffff byte addresses");
        }
        FunctionManagerDB.checkSingleAddressSpaceOnly(newBody);
        AddressSetView oldBody = function.getBody();
        try {
            this.namespaceMgr.setBody(function, newBody);
        }
        catch (OverlappingNamespaceException e) {
            throw new OverlappingFunctionException(entryPoint, e);
        }
        AddressSet set = oldBody.subtract(newBody);
        this.removeVariableRefs(function, set);
        this.removeFunctionSymbols(function, set);
        this.program.setObjChanged(155, function.getEntryPoint(), (Object)function, null, null);
    }

    private void removeFunctionSymbols(FunctionDB function, AddressSet set) {
        Symbol functionSymbol = function.getSymbol();
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        SymbolIterator iter = this.symbolMgr.getSymbols(set, SymbolType.LABEL, true);
        while (iter.hasNext()) {
            Symbol symbol = iter.next();
            if (symbol.getParentSymbol() != functionSymbol) continue;
            list.add(symbol);
        }
        for (Symbol symbol : list) {
            symbol.delete();
        }
    }

    private void removeVariableRefs(Function function, AddressSetView view) {
        ReferenceDBManager refMgr = this.program.getReferenceManager();
        AddressIterator iter = refMgr.getReferenceSourceIterator(view, true);
        while (iter.hasNext()) {
            Reference[] refs;
            Address fromAddr = iter.next();
            for (Reference ref : refs = refMgr.getReferencesFrom(fromAddr)) {
                Symbol s;
                Address toAddr = ref.getToAddress();
                if (toAddr.isStackAddress() || toAddr.isRegisterAddress()) {
                    refMgr.delete(ref);
                    continue;
                }
                long symID = ref.getSymbolID();
                if (symID < 0L || !((s = this.symbolMgr.getSymbol(symID)) instanceof VariableSymbolDB) || s.getParentSymbol().getID() != function.getID()) continue;
                if (toAddr.isMemoryAddress()) {
                    refMgr.removeAssociation(ref);
                    continue;
                }
                refMgr.delete(ref);
            }
        }
    }

    private void upgradeAllDotDotDots(TaskMonitor monitor) throws CancelledException {
        if (!this.isOldAdapterPreVarArgs()) {
            return;
        }
        PropertyMapManager usrPropertyManager = this.program.getUsrPropertyManager();
        StringPropertyMap decompilerPropertyMap = usrPropertyManager.getStringPropertyMap("decompiler_tags");
        if (decompilerPropertyMap == null) {
            return;
        }
        AddressIterator iter = decompilerPropertyMap.getPropertyIterator();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            this.upgradeDotDotDotToVarArgs(iter.next(), decompilerPropertyMap);
        }
    }

    private void upgradeDotDotDotToVarArgs(Address addr, StringPropertyMap decompilerPropertyMap) {
        Function f;
        String functionString = decompilerPropertyMap.getString(addr);
        String dotstring = HighFunction.tagFindExclude("dotdotdot", functionString);
        if (dotstring != null && (f = this.getFunctionAt(addr)) != null) {
            f.setVarArgs(true);
        }
    }

    private boolean isOldAdapterPreVarArgs() {
        return this.oldAdapterVersion == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable getReferencedVariable(Address instrAddr, Address storageAddr, int size, boolean isRead) {
        this.lock.acquire();
        try {
            Function func = this.getFunctionContaining(instrAddr);
            if (func == null) {
                Variable variable = null;
                return variable;
            }
            Variable[] variables = func.getAllVariables();
            Parameter paramCandidate = null;
            ArrayList<Variable> localCandidates = null;
            Variable firstCandidate = null;
            if (size <= 0) {
                size = 1;
            }
            Register register = this.program.getRegister(storageAddr, size);
            for (Variable var : variables) {
                VariableStorage variableStorage = var.getVariableStorage();
                if ((register == null || !variableStorage.intersects(register)) && (register != null || !var.getVariableStorage().contains(storageAddr))) continue;
                if (var instanceof Parameter) {
                    paramCandidate = (Parameter)var;
                    continue;
                }
                if (firstCandidate != null) {
                    if (localCandidates == null) {
                        localCandidates = new ArrayList<Variable>();
                        localCandidates.add(firstCandidate);
                    }
                    localCandidates.add(var);
                    continue;
                }
                firstCandidate = var;
            }
            int useOffset = (int)instrAddr.subtract(func.getEntryPoint());
            if (isRead) {
                if (useOffset == 0) {
                    Parameter parameter = paramCandidate;
                    return parameter;
                }
                --useOffset;
            }
            if (useOffset < 0) {
                useOffset = Integer.MAX_VALUE - useOffset;
            }
            if (localCandidates == null) {
                if (firstCandidate != null) {
                    int varFirstUse = firstCandidate.getFirstUseOffset();
                    if (varFirstUse < 0) {
                        varFirstUse = Integer.MAX_VALUE - varFirstUse;
                    }
                    if (varFirstUse <= useOffset) {
                        Variable variable = firstCandidate;
                        return variable;
                    }
                }
                Parameter varFirstUse = paramCandidate;
                return varFirstUse;
            }
            Variable bestVar = null;
            int bestFirstUse = 0;
            for (Variable var : localCandidates) {
                int varFirstUse = var.getFirstUseOffset();
                if (varFirstUse < 0) {
                    varFirstUse = Integer.MAX_VALUE - varFirstUse;
                }
                if (varFirstUse > useOffset || bestVar != null && bestFirstUse >= varFirstUse) continue;
                bestVar = var;
                bestFirstUse = varFirstUse;
            }
            if (bestVar == null) {
                bestVar = paramCandidate;
            }
            Parameter parameter = bestVar;
            return parameter;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDataTypes(long oldDataTypeID, long newDataTypeID) {
        this.lock.acquire();
        try {
            RecordIterator it = this.adapter.iterateFunctionRecords();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                if (this.thunkAdapter.getThunkRecord(rec.getKey()) != null || rec.getLongValue(0) != oldDataTypeID) continue;
                rec.setLongValue(0, newDataTypeID);
                this.adapter.updateFunctionRecord(rec);
                FunctionDB functionDB = this.cache.get(rec);
                if (functionDB == null) {
                    functionDB = new FunctionDB(this, this.cache, this.addrMap, rec);
                }
                this.functionChanged(functionDB, 5);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.cache.invalidate();
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThunk(long key) {
        this.lock.acquire();
        try {
            FunctionDB function = this.cache.get(key);
            if (function != null) {
                boolean bl = function.isThunk();
                return bl;
            }
            boolean bl = this.thunkAdapter.getThunkRecord(key) != null;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getThunkedFunctionId(long functionId) {
        this.lock.acquire();
        try {
            FunctionDB function = this.cache.get(functionId);
            if (function != null) {
                Function thunkedFunction = function.getThunkedFunction(false);
                long l = thunkedFunction != null ? thunkedFunction.getID() : -1L;
                return l;
            }
            DBRecord rec = this.thunkAdapter.getThunkRecord(functionId);
            long l = rec != null ? rec.getLongValue(0) : -1L;
            return l;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getThunkFunctionIds(long referencedFunctionId) {
        this.lock.acquire();
        ArrayList<Long> list = null;
        try {
            RecordIterator records = this.thunkAdapter.iterateThunkRecords(referencedFunctionId);
            while (records.hasNext()) {
                DBRecord rec = records.next();
                if (list == null) {
                    list = new ArrayList<Long>(1);
                }
                list.add(rec.getKey());
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return list;
    }

    FunctionDB getThunkedFunction(FunctionDB function) {
        DBRecord rec = null;
        try {
            rec = this.thunkAdapter.getThunkRecord(function.getKey());
            if (rec != null) {
                return (FunctionDB)this.getFunction(rec.getLongValue(0));
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguage(LanguageTranslator translator, TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.adapter.getRecordCount());
        int cnt = 0;
        this.lock.acquire();
        try {
            RecordIterator recIter = this.adapter.iterateFunctionRecords();
            while (recIter.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = recIter.next();
                String serialization = rec.getString(6);
                try {
                    serialization = VariableStorage.translateSerialization(translator, serialization);
                    rec.setString(6, serialization);
                    this.adapter.updateFunctionRecord(rec);
                }
                catch (InvalidInputException e) {
                    continue;
                }
                monitor.setProgress((long)(++cnt));
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.invalidateCache(true);
            this.lock.release();
        }
    }

    @Override
    public FunctionTagManager getFunctionTagManager() {
        return this.functionTagManager;
    }

    private class FunctionIteratorDB
    implements FunctionIterator {
        private SymbolIterator it;

        FunctionIteratorDB(boolean external, boolean forward) {
            this.it = external ? FunctionManagerDB.this.program.getSymbolTable().getSymbols(new AddressSet(AddressSpace.EXTERNAL_SPACE.getMinAddress(), AddressSpace.EXTERNAL_SPACE.getMaxAddress()), SymbolType.FUNCTION, forward) : FunctionManagerDB.this.program.getSymbolTable().getSymbols(FunctionManagerDB.this.program.getMemory(), SymbolType.FUNCTION, forward);
        }

        FunctionIteratorDB(Address start, boolean forward) {
            AddressFactory af = FunctionManagerDB.this.program.getAddressFactory();
            Address min = FunctionManagerDB.this.program.getMinAddress();
            Address max = FunctionManagerDB.this.program.getMaxAddress();
            AddressSet set = null;
            if (start.isMemoryAddress() && min != null) {
                if (forward && start.compareTo(max) <= 0) {
                    set = af.getAddressSet(start, max);
                } else if (!forward && start.compareTo(min) >= 0) {
                    set = af.getAddressSet(min, start);
                }
            }
            if (set == null) {
                set = new AddressSet();
            }
            this.it = FunctionManagerDB.this.program.getSymbolTable().getSymbols(set, SymbolType.FUNCTION, forward);
        }

        FunctionIteratorDB(AddressSetView addrSet, boolean forward) {
            this.it = FunctionManagerDB.this.program.getSymbolTable().getSymbols(addrSet, SymbolType.FUNCTION, forward);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Function next() {
            SymbolDB s = (SymbolDB)this.it.next();
            return FunctionManagerDB.this.getFunction(s.getID());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Function> iterator() {
            return this;
        }
    }

    private class FunctionFilteredIterator
    extends FilteredIterator<Function>
    implements FunctionIterator {
        public FunctionFilteredIterator(Iterator<Function> it) {
            super(it, FunctionManagerDB.this.functionFilter);
        }
    }
}

