/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.EmptyMemReferenceIterator;
import ghidra.program.database.references.FromAdapter;
import ghidra.program.database.references.OldStackRefDBAdpater;
import ghidra.program.database.references.RefList;
import ghidra.program.database.references.ReferenceDB;
import ghidra.program.database.references.ToAdapter;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.EmptyAddressIterator;
import ghidra.program.model.address.OldGenericNamespaceAddress;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.OffsetReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.ShiftedReference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.map.LazyMap;
import org.apache.commons.collections4.map.LazySortedMap;

public class ReferenceDBManager
implements ReferenceManager,
ManagerDB,
ErrorHandler {
    private static final Reference[] NO_REFS = new Reference[0];
    private FunctionVariableReferenceCacher functionCacher = new FunctionVariableReferenceCacher();
    private OldStackRefDBAdpater oldStackRefAdapter;
    private AddressMap addrMap;
    private FromAdapter fromAdapter;
    private ToAdapter toAdapter;
    private ProgramDB program;
    private SymbolManager symbolMgr;
    private Lock lock;
    private DBObjectCache<RefList> fromCache;
    private DBObjectCache<RefList> toCache;

    public ReferenceDBManager(DBHandle dbHandle, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        this.addrMap = addrMap;
        this.lock = lock;
        this.fromCache = new DBObjectCache(100);
        this.toCache = new DBObjectCache(100);
        VersionException versionExc = null;
        try {
            this.initializeAdapters(dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.oldStackRefAdapter = OldStackRefDBAdpater.getAdapter(dbHandle, openMode, monitor);
            if (openMode != 3) {
                versionExc = new VersionException(true).combine(versionExc);
            }
        }
        catch (VersionException versionException) {
            // empty catch block
        }
        if (versionExc != null) {
            throw versionExc;
        }
    }

    private void initializeAdapters(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        VersionException versionExc = null;
        try {
            this.fromAdapter = FromAdapter.getAdapter(handle, openMode, this.addrMap, this, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.toAdapter = ToAdapter.getAdapter(handle, openMode, this.addrMap, this, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        if (versionExc != null) {
            throw versionExc;
        }
        if (openMode == 3) {
            handle.deleteTable("Memory References");
        }
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
        this.symbolMgr = program.getSymbolTable();
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        if (openMode == 3) {
            this.processOldAdapterStackRefs(monitor);
            this.convertOldReferences(monitor);
        }
    }

    private void convertOldReferences(TaskMonitor monitor) throws IOException, CancelledException {
        AddressFactory factory = this.program.getAddressFactory();
        AddressIterator toVarAddresses = this.toAdapter.getToIterator(new AddressSet(AddressSpace.VARIABLE_SPACE.getMinAddress(), AddressSpace.VARIABLE_SPACE.getMaxAddress()), true);
        this.convertOldReferences(toVarAddresses, "Variable", monitor);
        this.convertOldReferences(this.toAdapter.getOldNamespaceAddresses(factory.getRegisterSpace()), "Register", monitor);
        this.convertOldReferences(this.toAdapter.getOldNamespaceAddresses(factory.getStackSpace()), "Stack", monitor);
    }

    private void convertOldReferences(AddressIterator toIterator, String typeOfRef, TaskMonitor monitor) throws IOException, CancelledException {
        int cnt = 0;
        while (toIterator.hasNext()) {
            monitor.checkCancelled();
            Address oldAddr = toIterator.next();
            if (!oldAddr.isVariableAddress() && !(oldAddr instanceof OldGenericNamespaceAddress)) break;
            if (cnt == 0) {
                monitor.setMessage("Converting " + typeOfRef + " References...");
                monitor.initialize((long)this.toAdapter.getRecordCount());
            }
            monitor.setProgress((long)(++cnt));
            Address newAddr = null;
            if (oldAddr instanceof OldGenericNamespaceAddress) {
                OldGenericNamespaceAddress oldNamespaceAddr = (OldGenericNamespaceAddress)oldAddr;
                long functionID = oldNamespaceAddr.getNamespaceID();
                Symbol sym = this.symbolMgr.getSymbol(functionID);
                if (sym != null && sym.getSymbolType() == SymbolType.FUNCTION) {
                    newAddr = oldNamespaceAddr.getGlobalAddress();
                }
            } else {
                Variable v;
                VariableStorage storage;
                Symbol[] symbols = this.symbolMgr.getSymbols(oldAddr);
                if (symbols != null && symbols.length != 0 && (storage = (v = (Variable)symbols[0].getObject()).getVariableStorage()) != null && !storage.isCompoundStorage()) {
                    newAddr = storage.getFirstVarnode().getAddress();
                }
            }
            if (newAddr == null) {
                this.removeAllTo(oldAddr);
                continue;
            }
            this.moveReferencesTo(oldAddr, newAddr, monitor);
        }
    }

    private int removeAllTo(Address toAddr) throws IOException {
        Reference[] refs;
        RefList toRefs = this.getToRefs(toAddr);
        if (toRefs == null) {
            return 0;
        }
        int cnt = toRefs.getNumRefs();
        for (Reference ref : refs = toRefs.getAllRefs()) {
            RefList fromRefs = this.getFromRefs(ref.getFromAddress());
            fromRefs.removeRef(toAddr, ref.getOperandIndex());
            if (fromRefs.isEmpty()) {
                this.fromCache.delete(fromRefs.getKey());
            }
            this.referenceRemoved(ref);
        }
        toRefs.removeAll();
        this.toCache.delete(toRefs.getKey());
        return cnt;
    }

    private void processOldAdapterStackRefs(TaskMonitor monitor) throws IOException, CancelledException {
        if (this.oldStackRefAdapter == null) {
            return;
        }
        AddressMap oldAddrMap = this.addrMap.getOldAddressMap();
        monitor.setMessage("Processing Old Stack References...");
        monitor.initialize((long)this.oldStackRefAdapter.getRecordCount());
        int cnt = 0;
        RecordIterator iter = this.oldStackRefAdapter.getRecords();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            DBRecord rec = iter.next();
            Address fromAddr = oldAddrMap.decodeAddress(rec.getLongValue(0));
            short opIndex = rec.getShortValue(1);
            boolean userDefined = rec.getBooleanValue(2);
            short offset = rec.getShortValue(3);
            this.addStackReference(fromAddr, opIndex, offset, RefType.READ, userDefined ? SourceType.USER_DEFINED : SourceType.ANALYSIS);
            monitor.setProgress((long)(++cnt));
        }
        this.oldStackRefAdapter = null;
    }

    private boolean isIncompatible(Reference ref, boolean isOffset, boolean isShifted, long offsetOrShift) {
        if (isShifted != ref.isShiftedReference() || isOffset != ref.isOffsetReference()) {
            return true;
        }
        if (isShifted) {
            return (long)((ShiftedReference)ref).getShift() != offsetOrShift;
        }
        if (isOffset) {
            return ((OffsetReference)ref).getOffset() != offsetOrShift;
        }
        return false;
    }

    private RefType combineReferenceType(RefType newType, RefType oldType) {
        if (newType == oldType) {
            return oldType;
        }
        if (newType.isFlow()) {
            return newType;
        }
        if (oldType.isFlow()) {
            return oldType;
        }
        if (newType == RefType.DATA && oldType.isData()) {
            return oldType;
        }
        if (newType == RefType.DATA_IND) {
            if (oldType.isIndirect()) {
                return oldType;
            }
        } else if (newType == RefType.READ ? oldType == RefType.WRITE || oldType == RefType.READ_WRITE : newType == RefType.WRITE && (oldType == RefType.READ || oldType == RefType.READ_WRITE)) {
            return RefType.READ_WRITE;
        }
        if (newType == RefType.READ_IND && (oldType == RefType.WRITE_IND || oldType == RefType.READ_WRITE_IND)) {
            return RefType.READ_WRITE_IND;
        }
        if (newType == RefType.WRITE_IND && (oldType == RefType.READ_IND || oldType == RefType.READ_WRITE_IND)) {
            return RefType.READ_WRITE_IND;
        }
        return newType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReferenceDB addRef(Address fromAddr, Address toAddr, RefType type, SourceType sourceType, int opIndex, boolean isOffset, boolean isShifted, long offsetOrShift) throws IOException {
        if (isOffset && isShifted) {
            throw new IllegalArgumentException("Reference may not be both shifted and offset");
        }
        if (opIndex < -1) {
            throw new IllegalArgumentException("Invalid opIndex specified: " + opIndex);
        }
        if (toAddr.getAddressSpace().isOverlaySpace()) {
            toAddr = ((OverlayAddressSpace)toAddr.getAddressSpace()).translateAddress(toAddr);
        }
        this.lock.acquire();
        try {
            boolean isPrimary = false;
            ReferenceDB oldRef = (ReferenceDB)this.getReference(fromAddr, toAddr, opIndex);
            if (oldRef != null) {
                if (!this.isIncompatible(oldRef, isOffset, isShifted, offsetOrShift) && (type = this.combineReferenceType(type, oldRef.getReferenceType())) == oldRef.getReferenceType()) {
                    ReferenceDB referenceDB = oldRef;
                    return referenceDB;
                }
                this.removeReference(fromAddr, toAddr, opIndex);
                isPrimary = oldRef.isPrimary();
            }
            boolean isStackRegisterRef = toAddr.isStackAddress() || toAddr.isRegisterAddress();
            RefList fromRefs = this.getFromRefs(fromAddr);
            RefList toRefs = null;
            if (!isStackRegisterRef) {
                toRefs = this.getToRefs(toAddr);
            }
            isPrimary |= fromRefs == null || fromAddr.isMemoryAddress() && !fromRefs.hasReference(opIndex);
            if (fromRefs == null) {
                fromRefs = this.fromAdapter.createRefList(this.program, this.fromCache, fromAddr);
            }
            fromRefs = fromRefs.checkRefListSize(this.fromCache, 1);
            fromRefs.addRef(fromAddr, toAddr, type, opIndex, -1L, isPrimary, sourceType, isOffset, isShifted, offsetOrShift);
            if (toRefs == null && !isStackRegisterRef) {
                toRefs = this.toAdapter.createRefList(this.program, this.toCache, toAddr);
            }
            if (toRefs != null) {
                toRefs = toRefs.checkRefListSize(this.toCache, 1);
                toRefs.addRef(fromAddr, toAddr, type, opIndex, -1L, isPrimary, sourceType, isOffset, isShifted, offsetOrShift);
            }
            ReferenceDB r = toRefs == null || fromRefs.getNumRefs() < toRefs.getNumRefs() ? fromRefs.getRef(toAddr, opIndex) : toRefs.getRef(fromAddr, opIndex);
            this.referenceAdded(r);
            ReferenceDB referenceDB = r;
            return referenceDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Reference addMemoryReference(Address fromAddr, Address toAddr, RefType type, SourceType sourceType, int opIndex) {
        if (!fromAddr.isMemoryAddress()) {
            throw new IllegalArgumentException("From address must be memory addresses");
        }
        try {
            if (!toAddr.isMemoryAddress()) {
                this.removeAllFrom(fromAddr, opIndex);
            } else if (toAddr.isMemoryAddress()) {
                this.removeNonMemRefs(fromAddr, opIndex);
            } else {
                throw new IllegalArgumentException("To address must be memory or register address");
            }
            return this.addRef(fromAddr, toAddr, type, sourceType, opIndex, false, false, 0L);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public Reference addStackReference(Address fromAddr, int opIndex, int stackOffset, RefType type, SourceType sourceType) {
        if (!fromAddr.isMemoryAddress()) {
            throw new IllegalArgumentException("From address must be memory address");
        }
        if (!type.isData()) {
            throw new IllegalArgumentException("Invalid stack reference type: " + type);
        }
        Function function = this.program.getFunctionManager().getFunctionContaining(fromAddr);
        if (function == null) {
            throw new IllegalArgumentException("Invalid stack reference scope: fromAddr not within function");
        }
        this.removeAllFrom(fromAddr, opIndex);
        try {
            Address stackAddr = this.program.getAddressFactory().getStackSpace().getAddress(stackOffset);
            return this.addRef(fromAddr, stackAddr, type, sourceType, opIndex, false, false, 0L);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    private void removeNonMemRefs(Address fromAddr, int opIndex) throws IOException {
        if (fromAddr == Address.EXT_FROM_ADDRESS) {
            return;
        }
        RefList fromRefs = this.getFromRefs(fromAddr);
        if (fromRefs == null) {
            return;
        }
        ReferenceIterator refIter = fromRefs.getRefs();
        while (refIter.hasNext()) {
            Reference ref = refIter.next();
            if (ref.getOperandIndex() != opIndex || ref.isMemoryReference()) continue;
            this.delete(ref);
        }
    }

    @Override
    public Reference addRegisterReference(Address fromAddr, int opIndex, Register register, RefType type, SourceType sourceType) {
        if (!fromAddr.isMemoryAddress()) {
            throw new IllegalArgumentException("From address must be memory address");
        }
        if (!type.isData()) {
            throw new IllegalArgumentException("Invalid register reference type: " + type);
        }
        this.removeAllFrom(fromAddr, opIndex);
        try {
            return this.addRef(fromAddr, register.getAddress(), type, sourceType, opIndex, false, false, 0L);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    private boolean isExternalBlockAddress(Address addr) {
        return this.program.getMemory().isExternalBlockAddress(addr);
    }

    @Override
    public Reference addOffsetMemReference(Address fromAddr, Address toAddr, boolean toAddrIsBase, long offset, RefType type, SourceType sourceType, int opIndex) {
        if (!fromAddr.isMemoryAddress() || !toAddr.isMemoryAddress()) {
            throw new IllegalArgumentException("From and To addresses must be memory addresses");
        }
        boolean isExternalBlockRef = this.isExternalBlockAddress(toAddr);
        boolean badOffsetReference = false;
        if (isExternalBlockRef) {
            if (!toAddrIsBase) {
                Address baseAddr = toAddr.subtractWrap(offset);
                if (this.isExternalBlockAddress(baseAddr)) {
                    toAddr = baseAddr;
                    toAddrIsBase = true;
                } else {
                    isExternalBlockRef = false;
                    badOffsetReference = true;
                }
            }
        } else if (toAddrIsBase && this.isExternalBlockAddress(toAddr = toAddr.addWrap(offset))) {
            badOffsetReference = true;
        }
        if (badOffsetReference) {
            Msg.warn((Object)this, (Object)("Offset Reference from " + fromAddr + " produces bad Xref into EXTERNAL block"));
        }
        try {
            this.removeNonMemRefs(fromAddr, opIndex);
            return this.addRef(fromAddr, toAddr, type, sourceType, opIndex, true, false, offset);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public Reference addShiftedMemReference(Address fromAddr, Address toAddr, int shiftValue, RefType type, SourceType sourceType, int opIndex) {
        if (!fromAddr.isMemoryAddress() || !toAddr.isMemoryAddress()) {
            throw new IllegalArgumentException("From and To addresses must be memory addresses");
        }
        try {
            this.removeNonMemRefs(fromAddr, opIndex);
            return this.addRef(fromAddr, toAddr, type, sourceType, opIndex, false, true, shiftValue);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public Reference addExternalReference(Address fromAddr, int opIndex, ExternalLocation location, SourceType sourceType, RefType type) throws InvalidInputException {
        if (!fromAddr.isMemoryAddress()) {
            throw new IllegalArgumentException("From address must be memory addresses");
        }
        try {
            if (this.symbolMgr.getPrimarySymbol(location.getExternalSpaceAddress()) != null) {
                this.removeAllFrom(fromAddr, opIndex);
                return this.addRef(fromAddr, location.getExternalSpaceAddress(), type, sourceType, opIndex, false, false, 0L);
            }
            try {
                return this.addExternalReference(fromAddr, location.getParentName(), location.getLabel(), location.getAddress(), sourceType, opIndex, type);
            }
            catch (DuplicateNameException e) {
                throw new InvalidInputException("External location not found and failed to create due to name conflict");
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public Reference addExternalReference(Address fromAddr, String libraryName, String extLabel, Address extAddr, SourceType sourceType, int opIndex, RefType type) throws InvalidInputException, DuplicateNameException {
        if (!fromAddr.isMemoryAddress()) {
            throw new IllegalArgumentException("From addresses must be memory addresses");
        }
        try {
            ExternalManagerDB extMgr = this.program.getExternalManager();
            ExternalLocation extLoc = extMgr.addExtLocation(libraryName, extLabel, extAddr, sourceType);
            this.removeAllFrom(fromAddr, opIndex);
            Address toAddr = extLoc.getExternalSpaceAddress();
            return this.addRef(fromAddr, toAddr, type, sourceType, opIndex, false, false, 0L);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public Reference addExternalReference(Address fromAddr, Namespace extNamespace, String extLabel, Address extAddr, SourceType sourceType, int opIndex, RefType type) throws InvalidInputException, DuplicateNameException {
        if (!fromAddr.isMemoryAddress()) {
            throw new IllegalArgumentException("From addresses must be memory addresses");
        }
        try {
            ExternalManagerDB extMgr = this.program.getExternalManager();
            ExternalLocation extLoc = extMgr.addExtLocation(extNamespace, extLabel, extAddr, sourceType);
            this.removeAllFrom(fromAddr, opIndex);
            Address toAddr = extLoc.getExternalSpaceAddress();
            return this.addRef(fromAddr, toAddr, type, sourceType, opIndex, false, false, 0L);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public Variable getReferencedVariable(Reference reference) {
        RefType refType = reference.getReferenceType();
        return this.program.getFunctionManager().getReferencedVariable(reference.getFromAddress(), reference.getToAddress(), 0, !refType.isWrite() && (refType.isRead() || refType.isIndirect()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference[] getReferencesTo(Variable var) {
        this.lock.acquire();
        try {
            Function function = var.getFunction();
            if (function.getProgram() != this.program || function.isDeleted()) {
                Reference[] referenceArray = NO_REFS;
                return referenceArray;
            }
            SymbolDB varSymbol = (SymbolDB)var.getSymbol();
            if (varSymbol != null && varSymbol.isDeleted()) {
                Reference[] referenceArray = NO_REFS;
                return referenceArray;
            }
            this.functionCacher.setFunction(function);
            VariableStorage storage = var.getVariableStorage();
            Scope scope = this.findVariableScope(function, varSymbol, var);
            List<Reference> matchingReferences = this.getScopedVariableReferences(storage, function, scope);
            if (matchingReferences.isEmpty()) {
                Reference[] referenceArray = NO_REFS;
                return referenceArray;
            }
            Reference[] refs = new Reference[matchingReferences.size()];
            matchingReferences.toArray(refs);
            Reference[] referenceArray = refs;
            return referenceArray;
        }
        finally {
            this.lock.release();
        }
    }

    private Scope findVariableScope(Function function, Symbol varSymbol, Variable var) {
        VariableStorage storage = var.getVariableStorage();
        Address variableAddr = null;
        try {
            variableAddr = varSymbol != null ? varSymbol.getAddress() : this.symbolMgr.findVariableStorageAddress(storage);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        int firstUseOffset = var.getFirstUseOffset();
        int outOfScopeOffset = Integer.MAX_VALUE;
        if (firstUseOffset < 0) {
            firstUseOffset = Integer.MAX_VALUE - firstUseOffset;
        }
        if (variableAddr == null) {
            return new Scope(firstUseOffset, outOfScopeOffset);
        }
        for (Variable v : this.functionCacher.getVariables(variableAddr)) {
            int nextVarOffset = v.getFirstUseOffset();
            if (nextVarOffset < 0) {
                nextVarOffset = Integer.MAX_VALUE - nextVarOffset;
            }
            if (nextVarOffset >= outOfScopeOffset || nextVarOffset <= firstUseOffset) continue;
            outOfScopeOffset = nextVarOffset;
        }
        return new Scope(var.getFirstUseOffset(), outOfScopeOffset);
    }

    private List<Reference> getScopedVariableReferences(VariableStorage storage, Function function, Scope scope) {
        SortedMap<Address, List<Reference>> dataReferences = this.functionCacher.getFunctionDataReferences();
        Address entry = function.getEntryPoint();
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (Varnode varnode : storage.getVarnodes()) {
            this.getScopedVarnodeReferences(references, varnode, dataReferences, scope, entry);
        }
        return references;
    }

    private void getScopedVarnodeReferences(List<Reference> matchingReferences, Varnode varnode, SortedMap<Address, List<Reference>> dataReferences, Scope scope, Address entry) {
        Address maxStorageAddr;
        Address minStorageAddr = varnode.getAddress();
        try {
            maxStorageAddr = minStorageAddr.add(varnode.getSize() - 1);
        }
        catch (AddressOutOfBoundsException e) {
            maxStorageAddr = minStorageAddr.getAddressSpace().getMaxAddress();
        }
        int firstUseOffset = scope.getFirstUseOffset();
        int outOfScopeOffset = scope.getOutOfScopeOffset();
        SortedMap<Address, List<Reference>> subMap = dataReferences.tailMap(minStorageAddr);
        for (List<Reference> refList : subMap.values()) {
            for (Reference ref : refList) {
                if (ref.getToAddress().compareTo(maxStorageAddr) > 0) {
                    return;
                }
                int refOffset = (int)ref.getFromAddress().subtract(entry);
                if (refOffset < 0) {
                    refOffset = Integer.MAX_VALUE - refOffset;
                }
                if (refOffset < firstUseOffset || refOffset >= outOfScopeOffset) continue;
                matchingReferences.add(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPrimary(Reference ref, boolean isPrimary) {
        this.lock.acquire();
        try {
            Reference pref;
            Address fromAddr = ref.getFromAddress();
            Address toAddr = ref.getToAddress();
            int opIndex = ref.getOperandIndex();
            RefList fromRefs = this.getFromRefs(fromAddr);
            if (fromRefs == null) {
                return;
            }
            Reference reference = pref = isPrimary ? fromRefs.getPrimaryRef(opIndex) : null;
            if (fromRefs.setPrimary(ref, isPrimary)) {
                RefList toRefs = this.getToRefs(toAddr);
                if (toRefs != null) {
                    toRefs.setPrimary(ref, isPrimary);
                }
                if (pref != null) {
                    fromRefs.setPrimary(pref, false);
                    toRefs = this.getToRefs(pref.getToAddress());
                    if (toRefs != null) {
                        toRefs.setPrimary(ref, false);
                    }
                    this.referencePrimaryChanged(pref);
                }
                this.referencePrimaryChanged(ref);
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference[] getReferencesFrom(Address addr) {
        this.lock.acquire();
        try {
            RefList fromRefs = this.getFromRefs(addr);
            if (fromRefs == null) {
                Reference[] referenceArray = NO_REFS;
                return referenceArray;
            }
            Reference[] referenceArray = fromRefs.getAllRefs();
            return referenceArray;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public Reference[] getFlowReferencesFrom(Address addr) {
        Reference[] refs = this.getReferencesFrom(addr);
        ArrayList<Reference> list = new ArrayList<Reference>(refs.length);
        for (Reference ref : refs) {
            if (!ref.getReferenceType().isFlow()) continue;
            list.add(ref);
        }
        refs = new Reference[list.size()];
        return list.toArray(refs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference getReference(Address fromAddr, Address toAddr, int opIndex) {
        this.lock.acquire();
        try {
            if (fromAddr.equals(Address.EXT_FROM_ADDRESS)) {
                RefList toRefs = this.getToRefs(toAddr);
                if (toRefs != null) {
                    ReferenceDB referenceDB = toRefs.getRef(fromAddr, opIndex);
                    return referenceDB;
                }
            } else {
                RefList fromRefs = this.getFromRefs(fromAddr);
                if (fromRefs != null) {
                    ReferenceDB referenceDB = fromRefs.getRef(toAddr, opIndex);
                    return referenceDB;
                }
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public int getReferenceCountFrom(Address fromAddr) {
        RefList fromRefs = this.getFromRefs(fromAddr);
        if (fromRefs != null) {
            return fromRefs.getNumRefs();
        }
        return 0;
    }

    @Override
    public int getReferenceCountTo(Address toAddr) {
        if (toAddr.isStackAddress() || toAddr.isRegisterAddress()) {
            throw new UnsupportedOperationException("getReferenceCountTo not supported for stack/register addresses");
        }
        RefList toRefs = this.getToRefs(toAddr);
        if (toRefs != null) {
            return toRefs.getNumRefs();
        }
        return 0;
    }

    @Override
    public int getReferenceDestinationCount() {
        return this.toAdapter.getRecordCount();
    }

    @Override
    public int getReferenceSourceCount() {
        return this.fromAdapter.getRecordCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Reference[] getReferences(Address fromAddr, int opIndex) {
        this.lock.acquire();
        try {
            RefList fromRefs = this.getFromRefs(fromAddr);
            if (fromRefs == null) {
                Reference[] referenceArray = NO_REFS;
                return referenceArray;
            }
            ArrayList<Reference> list = new ArrayList<Reference>(10);
            ReferenceIterator it = fromRefs.getRefs();
            while (it.hasNext()) {
                Reference ref = it.next();
                if (ref.getOperandIndex() != opIndex) continue;
                list.add(ref);
            }
            Reference[] refs = new Reference[list.size()];
            Reference[] referenceArray = list.toArray(refs);
            return referenceArray;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference getPrimaryReferenceFrom(Address addr, int opIndex) {
        this.lock.acquire();
        try {
            RefList fromRefs = this.getFromRefs(addr);
            if (fromRefs != null) {
                Reference reference = fromRefs.getPrimaryRef(opIndex);
                return reference;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public AddressIterator getReferenceDestinationIterator(Address startAddr, boolean forward) {
        try {
            return this.toAdapter.getToIterator(startAddr, forward);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public AddressIterator getReferenceDestinationIterator(AddressSetView addrSet, boolean forward) {
        if (addrSet != null && addrSet.isEmpty()) {
            return AddressIterator.EMPTY_ITERATOR;
        }
        try {
            return this.toAdapter.getToIterator(addrSet, forward);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public AddressIterator getReferenceSourceIterator(Address startAddr, boolean forward) {
        try {
            return this.fromAdapter.getFromIterator(startAddr, forward);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public ReferenceIterator getReferenceIterator(Address startAddr) {
        return new FromRefIterator(startAddr);
    }

    @Override
    public AddressIterator getReferenceSourceIterator(AddressSetView addrSet, boolean forward) {
        if (addrSet != null && addrSet.isEmpty()) {
            return AddressIterator.EMPTY_ITERATOR;
        }
        try {
            return this.fromAdapter.getFromIterator(addrSet, forward);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return new EmptyAddressIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFlowReferencesFrom(Address addr) {
        this.lock.acquire();
        try {
            RefList fromRefs = this.getFromRefs(addr);
            if (fromRefs == null) {
                boolean bl = false;
                return bl;
            }
            ReferenceIterator it = fromRefs.getRefs();
            while (it.hasNext()) {
                Reference ref = it.next();
                if (!ref.getReferenceType().isFlow()) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasReferencesFrom(Address fromAddr) {
        this.lock.acquire();
        try {
            long addr = this.addrMap.getKey(fromAddr, false);
            if (addr == -1L) {
                boolean bl = false;
                return bl;
            }
            RefList refList = this.fromCache.get(addr);
            if (refList != null && !refList.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.fromAdapter.hasRefFrom(addr);
            return bl;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasReferencesFrom(Address fromAddr, int opIndex) {
        this.lock.acquire();
        try {
            RefList fromRefs = this.getFromRefs(fromAddr);
            if (fromRefs == null) {
                boolean bl = false;
                return bl;
            }
            ReferenceIterator it = fromRefs.getRefs();
            while (it.hasNext()) {
                Reference ref = it.next();
                if (ref.getOperandIndex() != opIndex) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasReferencesTo(Address toAddr) {
        if (toAddr.isStackAddress() || toAddr.isRegisterAddress()) {
            throw new UnsupportedOperationException("hasReferencesTo not supported for stack/register addresses");
        }
        this.lock.acquire();
        try {
            long addr = this.addrMap.getKey(toAddr, false);
            if (addr == -1L) {
                boolean bl = false;
                return bl;
            }
            RefList refList = this.toCache.get(addr);
            if (refList != null && !refList.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.toAdapter.hasRefTo(addr);
            return bl;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    @Override
    public void removeAllReferencesFrom(Address beginAddr, Address endAddr) {
        try {
            AddressIterator it = this.fromAdapter.getFromIterator(new AddressSet(beginAddr, endAddr), true);
            while (it.hasNext()) {
                Address addr = it.next();
                this.removeAllFrom(addr);
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
    }

    @Override
    public void removeAllReferencesFrom(Address fromAddr) {
        try {
            this.removeAllFrom(fromAddr);
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
    }

    @Override
    public void removeAllReferencesTo(Address toAddr) {
        try {
            this.removeAllTo(toAddr);
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReference(Address fromAddr, Address toAddr, int opIndex) {
        this.lock.acquire();
        try {
            RefList toRefs;
            ReferenceDB ref = null;
            RefList fromRefs = this.getFromRefs(fromAddr);
            if (fromRefs != null && (ref = fromRefs.getRef(toAddr, opIndex)) != null) {
                fromRefs.removeRef(toAddr, opIndex);
                if (fromRefs.isEmpty()) {
                    this.fromCache.delete(fromRefs.getKey());
                }
            }
            if ((toRefs = this.getToRefs(toAddr)) != null) {
                if (ref == null) {
                    ref = toRefs.getRef(fromAddr, opIndex);
                }
                toRefs.removeRef(fromAddr, opIndex);
                if (toRefs.isEmpty()) {
                    this.toCache.delete(toRefs.getKey());
                }
            }
            if (ref != null) {
                this.referenceRemoved(ref);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    public void symbolRemoved(Symbol symbol) {
        if (symbol.isDynamic()) {
            return;
        }
        if (symbol.getSymbolType() != SymbolType.LABEL) {
            this.checkFunctionChange(symbol);
            return;
        }
        long symID = symbol.getID();
        Address refAddr = symbol.getAddress();
        ReferenceIterator iter = this.getReferencesTo(refAddr);
        ArrayList<Reference> list = new ArrayList<Reference>();
        while (iter.hasNext()) {
            Reference ref = iter.next();
            if (symID != ref.getSymbolID()) continue;
            list.add(ref);
        }
        for (Reference ref : list) {
            this.removeAssociation(ref);
        }
    }

    public void symbolAdded(Symbol sym) {
        this.checkFunctionChange(sym);
    }

    private void checkFunctionChange(Symbol sym) {
        SymbolType symbolType = sym.getSymbolType();
        if (symbolType == SymbolType.FUNCTION || symbolType == SymbolType.PARAMETER || symbolType == SymbolType.LOCAL_VAR) {
            this.functionCacher.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAssociation(Symbol s, Reference ref) {
        if (s.getSymbolType() != SymbolType.LABEL || s.isDynamic() || s.isExternal()) {
            return;
        }
        this.lock.acquire();
        try {
            Address symAddr = s.getAddress();
            if (!symAddr.equals(ref.getToAddress())) {
                throw new IllegalArgumentException("Symbol address(" + symAddr + ") not equal to reference's To address(" + ref.getToAddress() + ")");
            }
            try {
                this.setSymbolID(ref, s.getID());
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
            this.program.setObjChanged(50, ref.getFromAddress(), (Object)ref, null, (Object)s);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void removeAssociation(Reference ref) {
        this.lock.acquire();
        try {
            this.setSymbolID(ref, -1L);
            this.program.setObjChanged(51, ref.getFromAddress(), (Object)ref, null, null);
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference updateRefType(Reference ref, RefType refType) {
        this.lock.acquire();
        try {
            if (ref.getReferenceType() == refType) {
                Reference reference = ref;
                return reference;
            }
            RefList fromRefs = this.getFromRefs(ref.getFromAddress());
            if (fromRefs == null) {
                Reference reference = null;
                return reference;
            }
            Address toAddr = ref.getToAddress();
            ReferenceDB curRef = fromRefs.getRef(toAddr, ref.getOperandIndex());
            if (curRef == null) {
                Reference reference = null;
                return reference;
            }
            fromRefs.updateRefType(toAddr, ref.getOperandIndex(), refType);
            RefList toRefs = this.getToRefs(toAddr);
            if (toRefs != null) {
                toRefs.updateRefType(ref.getFromAddress(), ref.getOperandIndex(), refType);
            }
            ReferenceDB newRef = fromRefs.getRef(toAddr, ref.getOperandIndex());
            this.referenceTypeChanged(newRef, curRef.getReferenceType(), refType);
            ReferenceDB referenceDB = newRef;
            return referenceDB;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceIterator getReferencesTo(Address addr) {
        this.lock.acquire();
        try {
            if (addr.isStackAddress() || addr.isRegisterAddress()) {
                throw new UnsupportedOperationException("getReferencesTo not supported for stack/register addresses");
            }
            RefList toRefs = this.getToRefs(addr);
            if (toRefs != null) {
                ReferenceIterator referenceIterator = toRefs.getRefs();
                return referenceIterator;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new EmptyMemReferenceIterator();
    }

    @Override
    public void invalidateCache(boolean all) {
        this.lock.acquire();
        try {
            this.fromCache.invalidate();
            this.toCache.invalidate();
            this.functionCacher.clearCache();
        }
        finally {
            this.lock.release();
        }
    }

    public int moveReferencesTo(Address oldToAddr, Address newToAddr, TaskMonitor monitor) throws CancelledException, IOException {
        RefList toRefs = this.getToRefs(oldToAddr);
        if (toRefs == null) {
            return 0;
        }
        Reference[] refs = toRefs.getAllRefs();
        RefList newToRefs = null;
        if (!newToAddr.isStackAddress() && !newToAddr.isRegisterAddress()) {
            newToRefs = this.getToRefs(newToAddr);
            if (newToRefs == null) {
                newToRefs = this.toAdapter.createRefList(this.program, this.toCache, newToAddr);
            }
            newToRefs = newToRefs.checkRefListSize(this.toCache, refs.length);
        }
        for (Reference ref : refs) {
            monitor.checkCancelled();
            Address fromAddr = ref.getFromAddress();
            int opIndex = ref.getOperandIndex();
            RefList fromRefs = this.getFromRefs(fromAddr);
            if (fromRefs != null) {
                fromRefs.removeRef(oldToAddr, ref.getOperandIndex());
                fromRefs.addRef(fromAddr, newToAddr, ref.getReferenceType(), opIndex, -1L, ref.isPrimary(), ref.getSource(), false, false, 0L);
            }
            if (newToRefs == null) continue;
            newToRefs.addRef(fromAddr, newToAddr, ref.getReferenceType(), opIndex, -1L, ref.isPrimary(), ref.getSource(), false, false, 0L);
        }
        toRefs.removeAll();
        this.toCache.delete(toRefs.getKey());
        return refs.length;
    }

    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) {
        this.removeAllReferencesFrom(startAddr, endAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            Address fromEndAddr = fromAddr.add(length - 1L);
            boolean forward = fromAddr.compareTo(toAddr) > 0;
            Address firstAddr = forward ? fromAddr : fromEndAddr;
            AddressIterator refSourceIter = this.getReferenceSourceIterator(firstAddr, forward);
            while (refSourceIter.hasNext()) {
                monitor.checkCancelled();
                Address oldFromAddr = refSourceIter.next();
                if (forward && oldFromAddr.compareTo(fromEndAddr) > 0) break;
                if (!forward && oldFromAddr.compareTo(fromAddr) < 0) {
                    break;
                }
                RefList fromRefs = this.getFromRefs(oldFromAddr);
                if (fromRefs == null) continue;
                Reference[] refs = fromRefs.getAllRefs();
                fromRefs.removeAll();
                this.fromCache.delete(fromRefs.getKey());
                long offset = oldFromAddr.subtract(fromAddr);
                Address newRefFromAddr = toAddr.add(offset);
                for (Reference ref : refs) {
                    monitor.checkCancelled();
                    Address newRefToAddr = ref.getToAddress();
                    int opIndex = ref.getOperandIndex();
                    RefList toRefs = this.getToRefs(newRefToAddr);
                    if (newRefToAddr.compareTo(fromAddr) >= 0 && newRefToAddr.compareTo(fromEndAddr) <= 0) {
                        offset = newRefToAddr.subtract(fromAddr);
                        newRefToAddr = toAddr.add(offset);
                    }
                    if (toRefs != null) {
                        toRefs.removeRef(oldFromAddr, ref.getOperandIndex());
                    }
                    if (ref.getSource() == SourceType.DEFAULT) continue;
                    long offsetOrShift = 0L;
                    if (ref instanceof OffsetReference) {
                        offsetOrShift = ((OffsetReference)ref).getOffset();
                    }
                    if (ref instanceof ShiftedReference) {
                        offsetOrShift = ((ShiftedReference)ref).getShift();
                    }
                    ReferenceDB newRef = this.addRef(newRefFromAddr, newRefToAddr, ref.getReferenceType(), ref.getSource(), opIndex, ref.isOffsetReference(), ref.isShiftedReference(), offsetOrShift);
                    long symbolId = ref.getSymbolID();
                    if (symbolId == -1L) continue;
                    this.setSymbolID(newRef, symbolId);
                }
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public byte getReferenceLevel(Address toAddr) {
        try {
            DBRecord rec = this.toAdapter.getRecord(this.addrMap.getKey(toAddr, false));
            if (rec != null) {
                return rec.getByteValue(2);
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        return 0;
    }

    public AddressIterator getExternalEntryIterator() {
        this.lock.acquire();
        try {
            RefList refList = this.getFromRefs(Address.EXT_FROM_ADDRESS);
            if (refList != null) {
                ExtEntryAddressIterator extEntryAddressIterator = new ExtEntryAddressIterator(refList.getRefs());
                return extEntryAddressIterator;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new EmptyAddressIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExternalEntryPoint(Address toAddr) {
        this.lock.acquire();
        try {
            RefList refList = this.getToRefs(toAddr);
            if (refList != null) {
                boolean bl = refList.getRef(Address.EXT_FROM_ADDRESS, -1) != null;
                return bl;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    public void addExternalEntryPointRef(Address toAddr) throws IllegalArgumentException {
        if (!toAddr.isMemoryAddress()) {
            throw new IllegalArgumentException("Entry point address must be memory address");
        }
        if (!this.isExternalEntryPoint(toAddr)) {
            try {
                this.addRef(Address.EXT_FROM_ADDRESS, toAddr, RefType.EXTERNAL_REF, SourceType.DEFAULT, -1, false, false, 0L);
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
            this.externalEntryPointAdded(toAddr);
        }
    }

    public void removeExternalEntryPoint(Address addr) {
        if (this.isExternalEntryPoint(addr)) {
            this.removeReference(Address.EXT_FROM_ADDRESS, addr, -1);
            this.externalEntryPointRemoved(addr);
        }
    }

    private void externalEntryPointAdded(Address addr) {
        this.program.setChanged(47, addr, addr, null, null);
    }

    private void externalEntryPointRemoved(Address addr) {
        this.program.setChanged(48, addr, addr, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefList getFromRefs(Address from) {
        this.lock.acquire();
        try {
            long fromAddr = this.addrMap.getKey(from, false);
            RefList refList = this.fromCache.get(fromAddr);
            if (refList == null) {
                try {
                    refList = this.fromAdapter.getRefList(this.program, this.fromCache, from, fromAddr);
                }
                catch (IOException e) {
                    this.dbError(e);
                }
            }
            RefList refList2 = refList;
            return refList2;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefList getToRefs(Address to) {
        this.lock.acquire();
        try {
            long toAddr = this.addrMap.getKey(to, false);
            RefList refList = this.toCache.get(toAddr);
            if (refList == null) {
                try {
                    refList = this.toAdapter.getRefList(this.program, this.toCache, to, toAddr);
                }
                catch (ClosedException closedException) {
                }
                catch (IOException e) {
                    this.dbError(e);
                }
            }
            RefList refList2 = refList;
            return refList2;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllFrom(Address fromAddr) throws IOException {
        this.lock.acquire();
        try {
            Reference[] refs;
            RefList fromRefs = this.getFromRefs(fromAddr);
            if (fromRefs == null) {
                return;
            }
            for (Reference ref : refs = fromRefs.getAllRefs()) {
                RefList toRefs = this.getToRefs(ref.getToAddress());
                if (toRefs != null) {
                    toRefs.removeRef(fromAddr, ref.getOperandIndex());
                    if (toRefs.isEmpty()) {
                        this.toCache.delete(toRefs.getKey());
                    }
                }
                this.referenceRemoved(ref);
            }
            fromRefs.removeAll();
            this.fromCache.delete(fromRefs.getKey());
        }
        finally {
            this.lock.release();
        }
    }

    private void removeAllFrom(Address fromAddr, int opIndex) {
        Reference[] refs;
        for (Reference ref : refs = this.getReferences(fromAddr, opIndex)) {
            this.delete(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSymbolID(Reference ref, long symbolID) throws IOException {
        this.lock.acquire();
        try {
            RefList fromRefs = this.getFromRefs(ref.getFromAddress());
            if (fromRefs == null) {
                return;
            }
            ReferenceDB curRef = fromRefs.getRef(ref.getToAddress(), ref.getOperandIndex());
            if (curRef == null) {
                return;
            }
            fromRefs.setSymbolID(curRef, symbolID);
            RefList toRefs = this.getToRefs(ref.getToAddress());
            if (toRefs != null) {
                toRefs.setSymbolID(curRef, symbolID);
            }
        }
        finally {
            this.lock.release();
        }
    }

    private void referenceAdded(Reference ref) {
        Address addr = ref.getFromAddress();
        if (addr == Address.EXT_FROM_ADDRESS) {
            addr = null;
        }
        this.functionCacher.clearCache();
        this.program.setObjChanged(60, addr, (Object)ref, null, (Object)ref);
        if (ref.getReferenceType() == RefType.FALL_THROUGH) {
            this.program.getCodeManager().fallThroughChanged(ref.getFromAddress(), ref);
        }
    }

    private void referenceRemoved(Reference ref) {
        this.functionCacher.clearCache();
        this.program.setObjChanged(61, ref.getFromAddress(), (Object)ref, (Object)ref, null);
        if (ref.getReferenceType() == RefType.FALL_THROUGH) {
            this.program.getCodeManager().fallThroughChanged(ref.getFromAddress(), null);
        }
    }

    private void referenceTypeChanged(Reference ref, RefType oldType, RefType newType) {
        this.functionCacher.clearCache();
        this.program.setObjChanged(62, ref.getFromAddress(), (Object)ref, (Object)oldType, (Object)newType);
        if (oldType == RefType.FALL_THROUGH) {
            this.program.getCodeManager().fallThroughChanged(ref.getFromAddress(), null);
        }
    }

    private void referencePrimaryChanged(Reference ref) {
        if (ref.isPrimary()) {
            this.program.setObjChanged(63, ref.getFromAddress(), (Object)ref, null, (Object)ref);
        } else {
            this.program.setObjChanged(64, ref.getFromAddress(), (Object)ref, (Object)ref, null);
        }
    }

    public void dbError(IOException e) {
        this.program.dbError(e);
    }

    @Override
    public void delete(Reference ref) {
        this.removeReference(ref.getFromAddress(), ref.getToAddress(), ref.getOperandIndex());
    }

    @Override
    public ReferenceIterator getExternalReferences() {
        AddressSet set = new AddressSet(AddressSpace.EXTERNAL_SPACE.getMinAddress(), AddressSpace.EXTERNAL_SPACE.getMaxAddress());
        AddressIterator it = this.getReferenceDestinationIterator(set, true);
        return new ExternalReferenceIterator(it);
    }

    @Override
    public Reference addReference(Reference ref) {
        Reference memRef;
        Address from = ref.getFromAddress();
        Address to = ref.getToAddress();
        RefType type = ref.getReferenceType();
        SourceType sourceType = ref.getSource();
        int opIndex = ref.getOperandIndex();
        if (ref.isExternalReference()) {
            ExternalLocation extLoc = ((ExternalReference)ref).getExternalLocation();
            try {
                return this.addExternalReference(from, extLoc.getParentNameSpace(), extLoc.getLabel(), extLoc.getAddress(), sourceType, opIndex, type);
            }
            catch (DuplicateNameException e) {
                throw new AssertException((Throwable)e);
            }
            catch (InvalidInputException e) {
                throw new AssertException((Throwable)e);
            }
        }
        if (ref.getToAddress().isStackAddress()) {
            return this.addStackReference(ref.getFromAddress(), opIndex, (int)ref.getToAddress().getOffset(), type, sourceType);
        }
        if (ref.isOffsetReference()) {
            OffsetReference offRef = (OffsetReference)ref;
            memRef = this.addOffsetMemReference(from, offRef.getBaseAddress(), true, offRef.getOffset(), type, sourceType, opIndex);
        } else if (ref.isShiftedReference()) {
            ShiftedReference shiftRef = (ShiftedReference)ref;
            memRef = this.addShiftedMemReference(from, to, shiftRef.getShift(), type, sourceType, opIndex);
        } else {
            memRef = this.addMemoryReference(from, to, type, sourceType, opIndex);
        }
        boolean isPrimary = ref.isPrimary();
        if (isPrimary != memRef.isPrimary()) {
            this.setPrimary(memRef, isPrimary);
        }
        return memRef;
    }

    @Override
    public Reference[] getReferencesFrom(Address fromAddr, int opIndex) {
        Reference[] retRefs = null;
        try {
            RefList fromRefs = this.getFromRefs(fromAddr);
            if (fromRefs == null) {
                return NO_REFS;
            }
            Reference[] refs = fromRefs.getAllRefs();
            int cnt = 0;
            for (Reference ref : refs) {
                if (ref.getOperandIndex() != opIndex) continue;
                ++cnt;
            }
            if (cnt == refs.length) {
                return refs;
            }
            retRefs = new Reference[cnt];
            cnt = 0;
            for (Reference ref : refs) {
                if (ref.getOperandIndex() != opIndex) continue;
                retRefs[cnt++] = ref;
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        return retRefs;
    }

    ProgramDB getProgram() {
        return this.program;
    }

    private class FunctionVariableReferenceCacher {
        private Function cachedFunction;
        private SortedMap<Address, List<Reference>> references;
        private Map<Address, List<Variable>> variablesByAddress;

        private FunctionVariableReferenceCacher() {
        }

        synchronized void setFunction(Function function) {
            if (this.cachedFunction == function) {
                return;
            }
            this.clearCache();
            this.cachedFunction = function;
        }

        synchronized void clearCache() {
            this.cachedFunction = null;
            this.references = null;
        }

        synchronized SortedMap<Address, List<Reference>> getFunctionDataReferences() {
            if (this.references != null) {
                return this.references;
            }
            this.references = this.getSortedVariableReferences(this.cachedFunction);
            return this.references;
        }

        synchronized List<Variable> getVariables(Address address) {
            if (this.variablesByAddress != null) {
                return this.variablesByAddress.get(address);
            }
            LazyMap map = LazyMap.lazyMap(new HashMap(), () -> new ArrayList());
            for (Symbol s : ReferenceDBManager.this.symbolMgr.getSymbols(this.cachedFunction.getID())) {
                if (!s.getAddress().equals(address)) continue;
                Variable v = (Variable)s.getObject();
                ((List)map.get(address)).add(v);
            }
            this.variablesByAddress = map;
            return this.variablesByAddress.get(address);
        }

        private SortedMap<Address, List<Reference>> getSortedVariableReferences(Function function) {
            LazySortedMap newReferencesList = LazySortedMap.lazySortedMap(new TreeMap(), () -> new ArrayList());
            FromRefIterator refIter = new FromRefIterator(function.getBody());
            while (refIter.hasNext()) {
                Reference ref = refIter.next();
                RefType referenceType = ref.getReferenceType();
                if (referenceType.isFlow() && !referenceType.isIndirect()) continue;
                Address toAddr = ref.getToAddress();
                ((List)newReferencesList.get(toAddr)).add(ref);
            }
            return newReferencesList;
        }
    }

    private class Scope {
        int outOfScopeOffset;
        int firstUseOffset;

        Scope(int firstUseOffset, int outOfScopeOffset) {
            this.firstUseOffset = firstUseOffset;
            this.outOfScopeOffset = outOfScopeOffset;
        }

        int getFirstUseOffset() {
            return this.firstUseOffset;
        }

        int getOutOfScopeOffset() {
            return this.outOfScopeOffset;
        }
    }

    class FromRefIterator
    implements ReferenceIterator {
        AddressIterator fromIter;
        ReferenceIterator refIter;

        FromRefIterator(Address startFromAddr) {
            this.fromIter = ReferenceDBManager.this.getReferenceSourceIterator(startFromAddr, true);
        }

        FromRefIterator(AddressSetView set) {
            this.fromIter = ReferenceDBManager.this.getReferenceSourceIterator(set, true);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.refIter != null && this.refIter.hasNext()) {
                    return true;
                }
                Address fromAddr = this.fromIter.next();
                this.refIter = null;
                while (fromAddr != null && this.refIter == null) {
                    RefList refList = ReferenceDBManager.this.getFromRefs(fromAddr);
                    if (refList != null) {
                        this.refIter = refList.getRefs();
                        continue;
                    }
                    fromAddr = this.fromIter.next();
                }
            }
            catch (IOException e) {
                ReferenceDBManager.this.program.dbError(e);
            }
            return this.refIter != null;
        }

        @Override
        public Reference next() {
            if (this.hasNext()) {
                return this.refIter.next();
            }
            return null;
        }

        @Override
        public Iterator<Reference> iterator() {
            return this;
        }
    }

    private class ExtEntryAddressIterator
    implements AddressIterator {
        private ReferenceIterator iter;
        private Address currentAddress;

        ExtEntryAddressIterator(ReferenceIterator iter) {
            this.iter = iter;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.currentAddress != null;
        }

        @Override
        public Address next() {
            this.findNext();
            if (this.currentAddress != null) {
                Address addr = this.currentAddress;
                this.currentAddress = null;
                return addr;
            }
            return null;
        }

        private void findNext() {
            if (this.currentAddress == null) {
                while (this.iter.hasNext()) {
                    Reference ref = this.iter.next();
                    if (ref == null || !ref.isEntryPointReference()) continue;
                    this.currentAddress = ref.getToAddress();
                    break;
                }
            }
        }

        @Override
        public Iterator<Address> iterator() {
            return this;
        }
    }

    class ExternalReferenceIterator
    implements ReferenceIterator {
        private AddressIterator it;
        private ReferenceIterator refIt;

        ExternalReferenceIterator(AddressIterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.refIt != null && this.refIt.hasNext() || this.it.hasNext();
        }

        @Override
        public Reference next() {
            Address addr;
            if (!(this.refIt != null && this.refIt.hasNext() || (addr = this.it.next()) == null)) {
                this.refIt = ReferenceDBManager.this.getReferencesTo(addr);
            }
            if (this.refIt != null) {
                return this.refIt.next();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Reference> iterator() {
            return this;
        }
    }
}

