/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;

public class ArrayDataType
extends DataTypeImpl
implements Array {
    private int numElements;
    private DataType dataType;
    private int elementLength;
    private boolean deleted = false;

    public ArrayDataType(DataType dataType, int numElements, int elementLength) {
        this(dataType, numElements, elementLength, null);
    }

    public ArrayDataType(DataType dataType, int numElements, int elementLength, DataTypeManager dtm) {
        super(dataType.getCategoryPath(), "array", dtm);
        if (dataType instanceof FactoryDataType) {
            throw new IllegalArgumentException("Factory data type not permitted");
        }
        if (numElements < 0) {
            throw new IllegalArgumentException("Number of array elements may not be negative [" + numElements + "]");
        }
        DataType baseDt = dataType;
        if (dataType instanceof TypeDef) {
            baseDt = ((TypeDef)dataType).getBaseDataType();
        }
        ArrayDataType.validate(baseDt);
        dataType = dataType.clone(dtm);
        this.elementLength = -1;
        if (baseDt instanceof Dynamic) {
            if (elementLength < 0) {
                throw new IllegalArgumentException("Must specify Array element-length for dynamic " + dataType.getClass().getSimpleName());
            }
            this.elementLength = elementLength;
        } else {
            this.elementLength = dataType.getAlignedLength();
        }
        this.dataType = dataType;
        this.numElements = numElements;
        this.name = DataTypeUtilities.getName(this, true);
        dataType.addParent(this);
    }

    private static void validate(DataType baseDt) throws IllegalArgumentException {
        if (baseDt instanceof BitFieldDataType) {
            throw new IllegalArgumentException("Array data-type may not be a bitfield: " + baseDt.getName());
        }
        if (baseDt instanceof FactoryDataType) {
            throw new IllegalArgumentException("Array data-type may not be a Factory data-type: " + baseDt.getName());
        }
        if (baseDt instanceof Dynamic) {
            if (!((Dynamic)baseDt).canSpecifyLength()) {
                throw new IllegalArgumentException("Array data-type may not be a non-sizable Dynamic data-type: " + baseDt.getName());
            }
        } else if (baseDt.getLength() < 1) {
            throw new IllegalArgumentException("Data type may not report a length less than 1: " + baseDt.getClass().getSimpleName());
        }
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return this.dataType.hasLanguageDependantLength();
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return this.getDataType().getSettingsDefinitions();
    }

    @Override
    public TypeDefSettingsDefinition[] getTypeDefSettingsDefinitions() {
        return this.getDataType().getTypeDefSettingsDefinitions();
    }

    @Override
    public boolean isEquivalent(DataType obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Array)) {
            return false;
        }
        Array array = (Array)obj;
        if (this.numElements != array.getNumElements()) {
            return false;
        }
        if (!this.dataType.isEquivalent(array.getDataType())) {
            return false;
        }
        return !(this.dataType instanceof Dynamic) || this.getElementLength() == array.getElementLength();
    }

    @Override
    public int getNumElements() {
        return this.numElements;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return DataTypeUtilities.getMnemonic(this, false, settings);
    }

    @Override
    public boolean isZeroLength() {
        return this.numElements == 0;
    }

    @Override
    public int getLength() {
        if (this.numElements == 0) {
            return 1;
        }
        return this.numElements * this.getElementLength();
    }

    @Override
    public int getAlignedLength() {
        return this.getLength();
    }

    @Override
    public String getDescription() {
        return "Array of " + this.dataType.getDisplayName();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public final DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new ArrayDataType(this.dataType.clone(dtm), this.numElements, this.getElementLength(), dtm);
    }

    @Override
    public final DataType copy(DataTypeManager dtm) {
        return this.clone(dtm);
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        if (dt == this.dataType && dt.getLength() > 0) {
            this.elementLength = this.dataType.getAlignedLength();
            this.notifySizeChanged();
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        if (dt == this.dataType) {
            this.notifyAlignmentChanged();
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return this.getArrayValueClass(settings);
    }

    @Override
    public void setName(String name) throws InvalidNameException {
    }

    @Override
    public int getElementLength() {
        return this.elementLength;
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        if (this.dataType == dt) {
            this.notifyDeleted();
            this.deleted = true;
        }
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        if (newDt == this || newDt.getLength() < 0) {
            newDt = DataType.DEFAULT;
        }
        if (this.dataType == oldDt) {
            String oldName = this.getName();
            int oldLength = this.getLength();
            int oldAlignment = this.getAlignment();
            int oldElementLength = this.getElementLength();
            this.dataType.removeParent(this);
            this.dataType = newDt;
            this.dataType.addParent(this);
            if (this.dataType.getLength() >= 0) {
                this.elementLength = this.dataType.getAlignedLength();
            }
            if (!this.getName().equals(oldName)) {
                this.notifyNameChanged(oldName);
            }
            if (this.getLength() != oldLength || oldElementLength != this.getElementLength()) {
                this.notifySizeChanged();
            } else if (this.getAlignment() != oldAlignment) {
                this.notifyAlignmentChanged();
            }
        }
    }

    @Override
    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
    }

    @Override
    public void setNameAndCategory(CategoryPath path, String name) throws InvalidNameException, DuplicateNameException {
    }

    @Override
    public CategoryPath getCategoryPath() {
        DataType dt = this.getDataType();
        return dt.getCategoryPath();
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
        if (this.dataType == dt) {
            this.notifyNameChanged(oldName);
        }
    }

    @Override
    public boolean dependsOn(DataType dt) {
        DataType myDt = this.getDataType();
        return myDt == dt || myDt.dependsOn(dt);
    }

    @Override
    public String getDefaultLabelPrefix() {
        DataType dt = this.getDataType();
        if (dt == DataType.DEFAULT) {
            return "ARRAY";
        }
        return dt.getDefaultLabelPrefix() + "_ARRAY";
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return this.getArrayDefaultLabelPrefix(buf, settings, len, options);
    }

    @Override
    public String getDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutLength) {
        return this.getArrayDefaultOffcutLabelPrefix(buf, settings, len, options, offcutLength);
    }

    @Override
    public long getLastChangeTime() {
        return 0L;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.getArrayValue(buf, settings, length);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.getArrayRepresentation(buf, settings, length);
    }
}

