/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.Field;
import generic.End;
import generic.Span;
import ghidra.util.database.DirectedIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface FieldSpan
extends End.EndSpan<Field, FieldSpan> {
    public static final Domain DOMAIN = new Domain();
    public static final Empty EMPTY = Empty.INSTANCE;
    public static final Impl ALL = new Impl((End<Field>)DOMAIN.min(), (End<Field>)DOMAIN.max());

    public static FieldSpan sub(Field from, boolean fromInclusive, Field to, boolean toInclusive, DirectedIterator.Direction direction) {
        if (!(!from.equals((Object)to) || fromInclusive && toInclusive)) {
            return EMPTY;
        }
        return direction == DirectedIterator.Direction.FORWARD ? DOMAIN.closed(End.lower(from, fromInclusive), End.upper(to, toInclusive)) : DOMAIN.closed(End.lower(to, toInclusive), End.upper(from, fromInclusive));
    }

    public static FieldSpan head(Field to, boolean toInclusive, DirectedIterator.Direction direction) {
        return direction == DirectedIterator.Direction.FORWARD ? DOMAIN.closed(End.negativeInfinity(), End.upper(to, toInclusive)) : DOMAIN.closed(End.lower(to, toInclusive), End.positiveInfinity());
    }

    public static FieldSpan tail(Field from, boolean fromInclusive, DirectedIterator.Direction direction) {
        return direction == DirectedIterator.Direction.FORWARD ? DOMAIN.closed(End.lower(from, fromInclusive), End.positiveInfinity()) : DOMAIN.closed(End.negativeInfinity(), End.upper(from, fromInclusive));
    }

    public static final class Empty
    implements FieldSpan,
    Span.Empty<End<Field>, FieldSpan> {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        public String toString() {
            return this.doToString();
        }

        public Span.Domain<End<Field>, FieldSpan> domain() {
            return DOMAIN;
        }
    }

    public static class Domain
    extends End.EndDomain<Field, FieldSpan> {
        private Domain() {
            super(Field::compareTo);
        }

        public FieldSpan closed(End<Field> min, End<Field> max) {
            if (!min.isValidMin()) {
                throw new IllegalArgumentException("Invalid min: " + min);
            }
            if (!max.isValidMax()) {
                throw new IllegalArgumentException("Invalid max: " + max);
            }
            return (FieldSpan)super.closed(min, max);
        }

        public FieldSpan newSpan(End<Field> min, End<Field> max) {
            return new Impl(min, max);
        }

        public FieldSpan empty() {
            return EMPTY;
        }

        public FieldSpan all() {
            return ALL;
        }
    }

    public static final class Impl
    extends Record
    implements FieldSpan {
        private final End<Field> min;
        private final End<Field> max;

        public Impl(End<Field> min, End<Field> max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public String toString() {
            return this.doToString();
        }

        public Span.Domain<End<Field>, FieldSpan> domain() {
            return DOMAIN;
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Impl.class, "min;max", "min", "max"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Impl.class, "min;max", "min", "max"}, this, o);
        }

        public End<Field> min() {
            return this.min;
        }

        public End<Field> max() {
            return this.max;
        }
    }
}

