/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractFieldListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractIndexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrimitiveMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class FieldListTypeApplier
extends MsTypeApplier {
    private List<MsTypeApplier> baseClassList = new ArrayList<MsTypeApplier>();
    private List<MsTypeApplier> memberList = new ArrayList<MsTypeApplier>();
    private List<MsTypeApplier> methodList = new ArrayList<MsTypeApplier>();
    private boolean isEmpty;

    static FieldListTypeApplier getFieldListApplierSpecial(DefaultPdbApplicator applicator, RecordNumber recordNumber) throws PdbException {
        MsTypeApplier applier = applicator.getApplierOrNoTypeSpec(recordNumber, FieldListTypeApplier.class);
        if (applier instanceof FieldListTypeApplier) {
            FieldListTypeApplier fieldListApplier = (FieldListTypeApplier)applier;
            return fieldListApplier;
        }
        if (recordNumber.getCategory() == RecordCategory.TYPE) {
            try {
                return new FieldListTypeApplier(applicator, applicator.getPdb().getTypeRecord(recordNumber), true);
            }
            catch (IllegalArgumentException e) {
                applicator.appendLogMsg(e.getMessage());
            }
        }
        throw new PdbException("Problem creating field list");
    }

    public FieldListTypeApplier(DefaultPdbApplicator applicator, AbstractMsType msType) throws IllegalArgumentException {
        this(applicator, msType, false);
    }

    public FieldListTypeApplier(DefaultPdbApplicator applicator, AbstractMsType msType, boolean noType) throws IllegalArgumentException {
        super(applicator, msType);
        if (noType && msType instanceof PrimitiveMsType && ((PrimitiveMsType)msType).isNoType()) {
            this.isEmpty = true;
        } else {
            if (!(msType instanceof AbstractFieldListMsType)) {
                throw new IllegalArgumentException("PDB Incorrectly applying " + msType.getClass().getSimpleName() + " to " + this.getClass().getSimpleName());
            }
            this.isEmpty = false;
        }
    }

    boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    BigInteger getSize() {
        return BigInteger.ZERO;
    }

    @Override
    void apply() throws PdbException, CancelledException {
        if (!this.isEmpty()) {
            this.dataType = this.applyFieldListMsType((AbstractFieldListMsType)this.msType);
        }
    }

    List<MsTypeApplier> getBaseClassList() {
        return this.baseClassList;
    }

    List<MsTypeApplier> getMemberList() {
        return this.memberList;
    }

    List<MsTypeApplier> getMethodList() {
        return this.methodList;
    }

    private DataType applyFieldListMsType(AbstractFieldListMsType type) throws PdbException, CancelledException {
        this.applyBaseClasses(type.getBaseClassList());
        this.applyMembers(type.getMemberList());
        this.applyMethods(type.getMethodList());
        for (AbstractIndexMsType indexType : type.getIndexList()) {
            MsTypeApplier referencedTypeApplier = this.applicator.getTypeApplier(indexType.getReferencedRecordNumber());
            if (referencedTypeApplier instanceof FieldListTypeApplier) {
                FieldListTypeApplier subApplier = (FieldListTypeApplier)referencedTypeApplier;
                this.baseClassList.addAll(subApplier.getBaseClassList());
                this.memberList.addAll(subApplier.getMemberList());
                this.methodList.addAll(subApplier.getMethodList());
                continue;
            }
            this.pdbLogAndInfoMessage(this, "referenceTypeApplier is not FieldListTypeApplier");
        }
        return null;
    }

    private void applyBaseClasses(List<MsTypeField> baseClasses) throws CancelledException, PdbException {
        for (MsTypeField typeIterated : baseClasses) {
            MsTypeApplier applier = this.applicator.getTypeApplier((AbstractMsType)((Object)typeIterated));
            applier.apply();
            this.baseClassList.add(applier);
        }
    }

    private void applyMembers(List<MsTypeField> members) throws CancelledException, PdbException {
        for (MsTypeField typeIterated : members) {
            MsTypeApplier applier = this.applicator.getTypeApplier((AbstractMsType)((Object)typeIterated));
            applier.apply();
            this.memberList.add(applier);
        }
    }

    private void applyMethods(List<MsTypeField> methods) throws CancelledException, PdbException {
        for (MsTypeField typeIterated : methods) {
            MsTypeApplier applier = this.applicator.getTypeApplier((AbstractMsType)((Object)typeIterated));
            applier.apply();
            this.methodList.add(applier);
        }
    }
}

