/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.DBTraceSpaceKey;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeView;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeWithLocationView;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.database.symbol.DBTraceSymbolMultipleTypesView;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceSymbolWithLocationView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LazyCollection;
import ghidra.util.LockHold;
import ghidra.util.database.spatial.rect.Rectangle2DDirection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class DBTraceSymbolMultipleTypesWithLocationView<T extends AbstractDBTraceSymbol>
extends DBTraceSymbolMultipleTypesView<T>
implements TraceSymbolWithLocationView<T> {
    public DBTraceSymbolMultipleTypesWithLocationView(DBTraceSymbolManager manager, Collection<? extends AbstractDBTraceSymbolSingleTypeWithLocationView<? extends T>> parts) {
        super(manager, parts);
    }

    @SafeVarargs
    public DBTraceSymbolMultipleTypesWithLocationView(DBTraceSymbolManager manager, AbstractDBTraceSymbolSingleTypeWithLocationView<? extends T> ... parts) {
        super(manager, parts);
    }

    protected Collection<? extends AbstractDBTraceSymbolSingleTypeWithLocationView<? extends T>> getParts() {
        return this.parts;
    }

    @Override
    public T getChildWithNameAt(String name, long snap, TraceThread thread, Address address, TraceNamespaceSymbol parent) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            for (AbstractDBTraceSymbolSingleTypeWithLocationView<T> p : this.getParts()) {
                T symbol = p.getChildWithNameAt(name, snap, thread, address, parent);
                if (symbol == null) continue;
                T t = symbol;
                return t;
            }
            Iterator<AbstractDBTraceSymbolSingleTypeWithLocationView<T>> iterator = null;
            return (T)iterator;
        }
    }

    @Override
    public Collection<? extends T> getAt(long snap, TraceThread thread, Address address, boolean includeDynamicSymbols) {
        return this.getParts().stream().flatMap(p -> p.getAt(snap, thread, address, includeDynamicSymbols).stream()).toList();
    }

    @Override
    public Collection<? extends T> getIntersecting(Lifespan span, TraceThread thread, AddressRange range, boolean includeDynamicSymbols, boolean forward) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            this.manager.trace.getThreadManager().assertIsMine(thread);
            this.manager.assertValidThreadAddress(thread, range.getMinAddress());
            DBTraceAddressSnapRangePropertyMapSpace space = (DBTraceAddressSnapRangePropertyMapSpace)this.manager.idMap.get(DBTraceSpaceKey.create(range.getAddressSpace(), thread, 0), false);
            if (space == null) {
                List list = Collections.emptyList();
                return list;
            }
            LazyCollection lazyCollection = new LazyCollection(() -> space.reduce((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span).starting(forward ? Rectangle2DDirection.LEFTMOST : Rectangle2DDirection.RIGHTMOST)).orderedValues().stream().filter(s -> {
                byte tid = DBTraceSymbolManager.unpackTypeID(s);
                for (AbstractDBTraceSymbolSingleTypeView p : this.parts) {
                    if (p.typeID != tid) continue;
                    return true;
                }
                return false;
            }).map(s -> {
                byte tid = DBTraceSymbolManager.unpackTypeID(s);
                for (AbstractDBTraceSymbolSingleTypeView p : this.parts) {
                    if (p.typeID != tid) continue;
                    return (AbstractDBTraceSymbol)p.store.getObjectAt(DBTraceSymbolManager.unpackKey(s));
                }
                throw new AssertionError();
            }));
            return lazyCollection;
        }
    }
}

