/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceSpan;
import java.util.Objects;

public class DefaultTraceSpan
implements TraceSpan {
    private final Trace trace;
    private final Lifespan span;
    private final int hash;

    public DefaultTraceSpan(Trace trace, Lifespan span) {
        this.trace = trace;
        this.span = span;
        this.hash = Objects.hash(trace, span);
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public Lifespan getSpan() {
        return this.span;
    }

    public String toString() {
        return "TraceSnap<" + this.trace + ": " + this.span + ">";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultTraceSpan)) {
            return false;
        }
        DefaultTraceSpan that = (DefaultTraceSpan)obj;
        if (this.trace != that.trace) {
            return false;
        }
        return Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(TraceSpan that) {
        if (this == that) {
            return 0;
        }
        int result = this.trace.getName().compareTo(that.getTrace().getName());
        if (result != 0) {
            return result;
        }
        result = this.span.compareTo(that.getSpan());
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

