/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaCommand;
import agent.frida.manager.FridaEvent;
import agent.frida.manager.cmd.FridaCommandError;
import agent.frida.manager.evt.AbstractFridaCompletedCommandEvent;
import agent.frida.manager.evt.FridaCommandErrorEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class FridaPendingCommand<T>
extends CompletableFuture<T>
implements FridaCause {
    private final FridaCommand<? extends T> cmd;
    private final Set<FridaEvent<?>> evts = new LinkedHashSet();

    public FridaPendingCommand(FridaCommand<? extends T> cmd) {
        this.cmd = cmd;
    }

    public FridaCommand<? extends T> getCommand() {
        return this.cmd;
    }

    public void finish() {
        try {
            T result = this.cmd.complete(this);
            this.complete(result);
        }
        catch (Throwable e) {
            this.completeExceptionally(e);
        }
    }

    public boolean handle(FridaEvent<?> evt) {
        return this.cmd.handle(evt, this);
    }

    public void claim(FridaEvent<?> evt) {
        evt.claim(this);
        this.evts.add(evt);
    }

    public void steal(FridaEvent<?> evt) {
        this.claim(evt);
        evt.steal();
    }

    public <E extends FridaEvent<?>> E castSingleEvent(Class<E> cls) {
        if (this.evts.size() != 1) {
            throw new IllegalStateException("Command did not claim exactly one event");
        }
        return (E)((FridaEvent)cls.cast(this.evts.iterator().next()));
    }

    public <E extends FridaEvent<?>> E findFirstOf(Class<E> cls) {
        for (FridaEvent<?> evt : this.evts) {
            if (!cls.isAssignableFrom(evt.getClass())) continue;
            return (E)((FridaEvent)cls.cast(evt));
        }
        throw new IllegalStateException("Command did not claim any " + cls);
    }

    public <E extends FridaEvent<?>> List<E> findAllOf(Class<E> cls) {
        ArrayList<FridaEvent> found = new ArrayList<FridaEvent>();
        for (FridaEvent<?> evt : this.evts) {
            if (!cls.isAssignableFrom(evt.getClass())) continue;
            found.add((FridaEvent)cls.cast(evt));
        }
        return found;
    }

    public <E extends FridaEvent<?>> E findSingleOf(Class<E> cls) {
        List<E> found = this.findAllOf(cls);
        if (found.size() != 1) {
            throw new IllegalStateException("Command did not claim exactly one " + cls + ". Have " + this.evts);
        }
        return (E)((FridaEvent)found.get(0));
    }

    @SafeVarargs
    public final <E extends AbstractFridaCompletedCommandEvent> E checkCompletion(Class<E> ... classes) {
        AbstractFridaCompletedCommandEvent completion = this.findSingleOf(AbstractFridaCompletedCommandEvent.class);
        for (Class<E> cls : classes) {
            if (cls != completion.getClass()) continue;
            return (E)((AbstractFridaCompletedCommandEvent)cls.cast(completion));
        }
        if (completion instanceof FridaCommandErrorEvent) {
            throw new FridaCommandError(completion.getInfo(), this.cmd);
        }
        for (Class<E> cls : classes) {
            if (!cls.isAssignableFrom(completion.getClass())) continue;
            return (E)((AbstractFridaCompletedCommandEvent)cls.cast(completion));
        }
        throw new IllegalStateException("Command completed with " + completion + ", not any of " + Arrays.asList(classes));
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cmd + ")";
    }
}

