/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaImport;
import agent.frida.model.iface2.FridaModelTargetImport;
import agent.frida.model.impl.FridaModelTargetImportContainerImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.methods.FridaModelTargetFunctionInterceptorImpl;
import agent.frida.model.methods.FridaModelTargetUnloadScriptImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Import", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="_value", type=Address.class), @TargetAttributeType(name="_size", type=long.class), @TargetAttributeType(name="Name", type=String.class), @TargetAttributeType(name="Address", type=Address.class), @TargetAttributeType(name="Type", type=String.class), @TargetAttributeType(name="Slot", type=String.class), @TargetAttributeType(type=Object.class)})
public class FridaModelTargetImportImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetImport {
    protected final boolean constant;
    protected Address value;
    protected long size;
    protected String name;
    private FridaModelTargetFunctionInterceptorImpl intercept;
    private FridaModelTargetUnloadScriptImpl unload;

    protected static String indexImport(FridaImport symbol) {
        return symbol.getName();
    }

    protected static String keyImport(FridaImport symbol) {
        return PathUtils.makeKey((String)FridaModelTargetImportImpl.indexImport(symbol));
    }

    public FridaModelTargetImportImpl(FridaModelTargetImportContainerImpl imports, FridaImport imp) {
        super(imports.getModel(), (TargetObject)imports, FridaModelTargetImportImpl.keyImport(imp), imp, "Import");
        this.constant = false;
        try {
            this.value = imports.getModel().getAddressSpace("ram").getAddress(imp.getAddress());
        }
        catch (AddressFormatException e) {
            e.printStackTrace();
        }
        this.name = imp.getName();
        this.intercept = new FridaModelTargetFunctionInterceptorImpl(this);
        this.unload = new FridaModelTargetUnloadScriptImpl(this, this.intercept.getName());
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDescription(0), "_value", this.value, "Address", this.value, "Name", imp.getName(), "Type", imp.getType(), "Slot", imp.getSlot(), this.intercept.getName(), this.intercept, this.unload.getName(), this.unload), "Initialized");
    }

    @Override
    public String getDescription(int level) {
        FridaImport symbol = (FridaImport)this.getModelObject();
        return symbol.getName();
    }

    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public Address getValue() {
        return this.value;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

