/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaModuleInfo;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaKernelModule;
import agent.frida.manager.FridaModule;
import agent.frida.manager.FridaProcess;
import agent.frida.model.iface2.FridaModelTargetModuleContainer;
import agent.frida.model.impl.FridaModelImpl;
import agent.frida.model.impl.FridaModelTargetKernelImpl;
import agent.frida.model.impl.FridaModelTargetKernelModuleImpl;
import agent.frida.model.impl.FridaModelTargetModuleImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ModuleContainer", elements={@TargetElementType(type=FridaModelTargetModuleImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class FridaModelTargetKernelModuleContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetModuleContainer {
    protected final FridaModelTargetKernelImpl kernel;

    public FridaModelTargetKernelModuleContainerImpl(FridaModelTargetKernelImpl kernel) {
        super(kernel.getModel(), (TargetObject)kernel, "Modules", "ModuleContainer");
        this.kernel = kernel;
        this.getManager().addEventsListener(this);
        this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moduleLoaded(FridaProcess proc, FridaModuleInfo info, int index, FridaCause cause) {
        FridaModelTargetKernelModuleImpl targetModule;
        FridaModule module = info.getModule(index);
        FridaModelTargetKernelModuleContainerImpl fridaModelTargetKernelModuleContainerImpl = this;
        synchronized (fridaModelTargetKernelModuleContainerImpl) {
            targetModule = this.getTargetModule(module);
        }
        if (targetModule == null) {
            Msg.error((Object)this, (Object)("Module " + info.getModuleName(index) + " not found!"));
            return;
        }
        this.changeElements(List.of(), List.of(targetModule), Map.of(), "Loaded");
    }

    @Override
    public void moduleReplaced(FridaProcess proc, FridaModuleInfo info, int index, FridaCause cause) {
        FridaModule module = info.getModule(index);
        this.changeElements(List.of(), List.of(this.getTargetModule(module)), Map.of(), "Replaced");
        FridaModelTargetKernelModuleImpl targetModule = this.getTargetModule(module);
        this.changeElements(List.of(), List.of(targetModule), Map.of(), "Replaced");
    }

    @Override
    public void moduleUnloaded(FridaProcess proc, FridaModuleInfo info, int index, FridaCause cause) {
        FridaModelTargetKernelModuleImpl targetModule = this.getTargetModule(info.getModule(index));
        if (targetModule != null) {
            FridaModelImpl impl = (FridaModelImpl)this.model;
            impl.deleteModelObject(targetModule.getModule());
        }
        this.changeElements(List.of(info.getModuleName(index)), List.of(), Map.of(), "Unloaded");
    }

    public boolean supportsSyntheticModules() {
        return false;
    }

    @Override
    public CompletableFuture<? extends TargetModule> addSyntheticModule(String name) {
        throw new UnsupportedOperationException("frida does not support synthetic modules");
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        if (refresh.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)) {
            this.broadcast().invalidateCacheRequested((TargetObject)this);
        }
        return this.getManager().listKernelModules();
    }

    @Override
    public FridaModelTargetKernelModuleImpl getTargetModule(FridaModule module) {
        TargetObject targetObject = this.getMapObject(module);
        if (targetObject != null) {
            FridaModelTargetKernelModuleImpl targetModule = (FridaModelTargetKernelModuleImpl)targetObject;
            targetModule.setModelObject(module);
            return targetModule;
        }
        return new FridaModelTargetKernelModuleImpl(this, (FridaKernelModule)module);
    }
}

