/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.fbpk.FBPK;
import ghidra.file.formats.android.fbpk.FBPK_Constants;
import ghidra.file.formats.android.fbpk.FBPK_Factory;
import ghidra.file.formats.android.fbpk.FBPK_Partition;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class FBPK_Analyzer
extends FileFormatAnalyzer {
    public String getName() {
        return "Android FBPK Analyzer";
    }

    public String getDescription() {
        return "Annotates Android FBPK Files";
    }

    public boolean getDefaultEnablement(Program program) {
        return FBPK_Constants.isFBPK(program);
    }

    public boolean canAnalyze(Program program) {
        return FBPK_Constants.isFBPK(program);
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        Address headerAddress = program.getMinAddress();
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, !program.getLanguage().isBigEndian());
        try {
            FBPK header = FBPK_Factory.getFBPK(reader);
            DataType headerDataType = header.toDataType();
            Data headerData = program.getListing().createData(headerAddress, headerDataType);
            if (headerData == null) {
                log.appendMsg("Unable to apply FBPK data, stopping - " + headerAddress);
                return false;
            }
            Address address = headerAddress.add((long)headerDataType.getLength());
            monitor.initialize((long)header.getPartitions().size());
            monitor.setMessage("Marking up paritions...");
            for (FBPK_Partition partition : header.getPartitions()) {
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
                partition.markup(program, address, monitor, log);
                if (partition.getOffsetToNextPartitionTable() > 0) {
                    address = address.getNewAddress((long)partition.getOffsetToNextPartitionTable());
                    continue;
                }
                address = address.add((long)partition.getHeaderSize());
            }
            return true;
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
            return false;
        }
    }
}

