/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb;

import agent.gdb.GdbCompatibility;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.pty.PtyFactory;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.dbg.util.ShellUtils;
import ghidra.program.model.listing.Program;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@ConfigurableFactory.FactoryDescription(brief="gdb", htmlDetails="Connect to gdb.\nThis is best for most Linux and Unix userspace targets, and many embedded targets.\nIt may also be used with gdbserver by connecting to gdb, then using <code>target remote\n...</code>.\nThis will access the native API, which may put Ghidra's JVM at risk.")
public class GdbInJvmDebuggerModelFactory
implements DebuggerModelFactory {
    private String gdbCmd = "/usr/bin/gdb";
    @ConfigurableFactory.FactoryOption(value="GDB launch command")
    public final ConfigurableFactory.Property<String> gdbCommandOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getGdbCommand, this::setGdbCommand);
    private boolean existing = false;
    @ConfigurableFactory.FactoryOption(value="Use existing session via new-ui")
    public final ConfigurableFactory.Property<Boolean> useExistingOption = ConfigurableFactory.Property.fromAccessors(Boolean.TYPE, this::isUseExisting, this::setUseExisting);

    public CompletableFuture<? extends DebuggerObjectModel> build() {
        List gdbCmdLine = ShellUtils.parseArgs((String)this.gdbCmd);
        GdbModelImpl model = new GdbModelImpl(PtyFactory.local());
        return model.startGDB(this.existing ? null : (String)gdbCmdLine.get(0), (String[])gdbCmdLine.subList(1, gdbCmdLine.size()).toArray(String[]::new)).thenApply(__ -> model);
    }

    public int getPriority(Program program) {
        String exe;
        if (!GdbCompatibility.INSTANCE.isCompatible(this.gdbCmd)) {
            return -1;
        }
        if (program != null && ((exe = program.getExecutablePath()) == null || exe.isBlank())) {
            return -1;
        }
        return 80;
    }

    public String getGdbCommand() {
        return this.gdbCmd;
    }

    public void setGdbCommand(String gdbCmd) {
        this.gdbCmd = gdbCmd;
    }

    public boolean isUseExisting() {
        return this.existing;
    }

    public void setUseExisting(boolean existing) {
        this.existing = existing;
        this.gdbCommandOption.setEnabled(!existing);
    }
}

