/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target.schema;

import ghidra.dbg.target.TargetAggregate;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.TargetStack;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.schema.DefaultTargetObjectSchema;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.util.CollectionUtils;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface TargetObjectSchema {
    public static final ResyncMode DEFAULT_ELEMENT_RESYNC = ResyncMode.NEVER;
    public static final ResyncMode DEFAULT_ATTRIBUTE_RESYNC = ResyncMode.NEVER;

    public SchemaContext getContext();

    public SchemaName getName();

    public Class<?> getType();

    public Set<Class<? extends TargetObject>> getInterfaces();

    public boolean isCanonicalContainer();

    public Map<String, SchemaName> getElementSchemas();

    default public SchemaName getDefaultElementSchema() {
        return EnumerableTargetObjectSchema.OBJECT.getName();
    }

    default public SchemaName getElementSchema(String index) {
        SchemaName schemaName = this.getElementSchemas().get(index);
        return schemaName == null ? this.getDefaultElementSchema() : schemaName;
    }

    public ResyncMode getElementResyncMode();

    public Map<String, AttributeSchema> getAttributeSchemas();

    default public AttributeSchema getDefaultAttributeSchema() {
        return AttributeSchema.DEFAULT_ANY;
    }

    default public AttributeSchema getAttributeSchema(String name) {
        AttributeSchema attributeSchema = this.getAttributeSchemas().get(name);
        return attributeSchema == null ? this.getDefaultAttributeSchema() : attributeSchema;
    }

    public ResyncMode getAttributeResyncMode();

    default public SchemaName getChildSchemaName(String key) {
        if (PathUtils.isIndex(key)) {
            return this.getElementSchema(PathUtils.parseIndex(key));
        }
        return this.getAttributeSchema(key).getSchema();
    }

    default public TargetObjectSchema getChildSchema(String key) {
        SchemaName name = this.getChildSchemaName(key);
        return this.getContext().getSchema(name);
    }

    default public TargetObjectSchema getSuccessorSchema(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        TargetObjectSchema childSchema = this.getChildSchema(path.get(0));
        return childSchema.getSuccessorSchema(path.subList(1, path.size()));
    }

    default public List<TargetObjectSchema> getSuccessorSchemas(List<String> path) {
        ArrayList<TargetObjectSchema> result = new ArrayList<TargetObjectSchema>();
        TargetObjectSchema schema = this;
        result.add(schema);
        for (String key : path) {
            schema = schema.getChildSchema(key);
            result.add(schema);
        }
        return result;
    }

    default public PathMatcher searchFor(Class<? extends TargetObject> type, boolean requireCanonical) {
        return this.searchFor(type, List.of(), requireCanonical);
    }

    default public PathMatcher searchFor(Class<? extends TargetObject> type, List<String> prefix, boolean requireCanonical) {
        if (type == TargetObject.class) {
            throw new IllegalArgumentException("Must provide a specific interface");
        }
        PathMatcher result = new PathMatcher();
        Private.searchFor(this, result, prefix, true, type, false, requireCanonical, new HashSet<TargetObjectSchema>());
        return result;
    }

    default public List<String> searchForCanonicalContainer(Class<? extends TargetObject> type) {
        if (type == TargetObject.class) {
            throw new IllegalArgumentException("Must provide a specific interface");
        }
        SchemaContext ctx = this.getContext();
        HashSet<TargetObjectSchema> visited = new HashSet<TargetObjectSchema>();
        HashSet<TargetObjectSchema> visitedAsElement = new HashSet<TargetObjectSchema>();
        HashSet<Private.CanonicalSearchEntry> allOnLevel = new HashSet<Private.CanonicalSearchEntry>();
        allOnLevel.add(new Private.CanonicalSearchEntry(List.of(), false, this));
        while (!allOnLevel.isEmpty()) {
            List<String> found = null;
            for (Private.CanonicalSearchEntry ent : allOnLevel) {
                if (!ent.schema.getInterfaces().contains(type) || !ent.parentIsCanonical) continue;
                if (found != null) {
                    return null;
                }
                found = PathUtils.parent(ent.path);
            }
            if (found != null) {
                return List.copyOf(found);
            }
            HashSet<Private.CanonicalSearchEntry> nextLevel = new HashSet<Private.CanonicalSearchEntry>();
            for (Private.CanonicalSearchEntry ent : allOnLevel) {
                if (PathPattern.isWildcard(PathUtils.getKey(ent.path))) continue;
                for (Map.Entry<String, AttributeSchema> entry : ent.schema.getAttributeSchemas().entrySet()) {
                    TargetObjectSchema attrSchema = ctx.getSchema(entry.getValue().getSchema());
                    if (!TargetObject.class.isAssignableFrom(attrSchema.getType()) || !visited.add(attrSchema)) continue;
                    nextLevel.add(new Private.CanonicalSearchEntry(PathUtils.extend((List<String>)ent.path, entry.getKey()), false, attrSchema));
                }
                for (Map.Entry<String, Object> entry : ent.schema.getElementSchemas().entrySet()) {
                    TargetObjectSchema elemSchema = ctx.getSchema((SchemaName)entry.getValue());
                    visited.add(elemSchema);
                    if (!visitedAsElement.add(elemSchema)) continue;
                    nextLevel.add(new Private.CanonicalSearchEntry(PathUtils.index(ent.path, entry.getKey()), ent.schema.isCanonicalContainer(), elemSchema));
                }
                TargetObjectSchema deSchema = ctx.getSchema(ent.schema.getDefaultElementSchema());
                visited.add(deSchema);
                if (!visitedAsElement.add(deSchema)) continue;
                nextLevel.add(new Private.CanonicalSearchEntry(PathUtils.index(ent.path, ""), ent.schema.isCanonicalContainer(), deSchema));
            }
            allOnLevel = nextLevel;
        }
        return null;
    }

    default public List<String> searchForSuitable(Class<? extends TargetObject> type, List<String> path) {
        List<TargetObjectSchema> schemas = this.getSuccessorSchemas(path);
        while (path != null) {
            TargetObjectSchema schema = schemas.get(path.size());
            if (schema.getInterfaces().contains(type)) {
                return path;
            }
            List<String> inAgg = Private.searchForSuitableInAggregate(schema, type);
            if (inAgg != null) {
                return PathUtils.extend(path, inAgg);
            }
            path = PathUtils.parent(path);
        }
        return null;
    }

    default public PathPredicates matcherForSuitable(Class<? extends TargetObject> type, List<String> path) {
        PathMatcher result = new PathMatcher();
        HashSet<TargetObjectSchema> visited = new HashSet<TargetObjectSchema>();
        List<TargetObjectSchema> schemas = this.getSuccessorSchemas(path);
        while (path != null) {
            TargetObjectSchema schema = schemas.get(path.size());
            Private.searchFor(schema, result, path, false, type, true, false, visited);
            path = PathUtils.parent(path);
        }
        return result;
    }

    default public List<String> searchForSuitableContainer(Class<? extends TargetObject> type, List<String> path) {
        List<TargetObjectSchema> schemas = this.getSuccessorSchemas(path);
        while (path != null) {
            TargetObjectSchema schema = schemas.get(path.size());
            if (schema.isCanonicalContainer()) {
                TargetObjectSchema deSchema = schema.getContext().getSchema(schema.getDefaultElementSchema());
                if (deSchema.getInterfaces().contains(type)) {
                    return path;
                }
                List<String> inAgg = Private.searchForSuitableContainerInAggregate(schema, type);
                if (inAgg != null) {
                    return PathUtils.extend(path, inAgg);
                }
            }
            path = PathUtils.parent(path);
        }
        return null;
    }

    default public List<String> searchForAncestor(Class<? extends TargetObject> type, List<String> path) {
        while (path != null) {
            TargetObjectSchema schema = this.getSuccessorSchema(path);
            if (schema.getInterfaces().contains(type)) {
                return path;
            }
            path = PathUtils.parent(path);
        }
        return null;
    }

    default public List<String> searchForAncestorContainer(Class<? extends TargetObject> type, List<String> path) {
        while (path != null) {
            TargetObjectSchema deSchema;
            TargetObjectSchema schema = this.getSuccessorSchema(path);
            if (schema.isCanonicalContainer() && (deSchema = schema.getContext().getSchema(schema.getDefaultElementSchema())).getInterfaces().contains(type)) {
                return path;
            }
            path = PathUtils.parent(path);
        }
        return null;
    }

    default public boolean isHidden(String key) {
        if (PathUtils.isIndex(key)) {
            return false;
        }
        AttributeSchema schema = this.getAttributeSchema(key);
        if (schema == AttributeSchema.DEFAULT_ANY || schema == AttributeSchema.DEFAULT_OBJECT || schema == AttributeSchema.DEFAULT_VOID) {
            return key.startsWith("_");
        }
        return schema.isHidden();
    }

    default public void validateTypeAndInterfaces(Object value, List<String> parentPath, String key, boolean strict) {
        Class<?> cls = value.getClass();
        if (!this.getType().isAssignableFrom(cls)) {
            String path = key == null ? null : PathUtils.toString(PathUtils.extend(parentPath, key));
            String msg = path == null ? "Value " + value + " does not conform to required type " + this.getType() + " of schema " + this : "Value " + value + " for " + path + " does not conform to required type " + this.getType() + " of schema " + this;
            Msg.error((Object)this, (Object)msg);
            if (strict) {
                throw new AssertionError((Object)msg);
            }
        }
        for (Class<? extends TargetObject> iface : this.getInterfaces()) {
            if (iface.isAssignableFrom(cls)) continue;
            String msg = "Value " + value + " does not implement required interface " + iface + " of schema " + this;
            Msg.error((Object)this, (Object)msg);
            if (strict) {
                throw new AssertionError((Object)msg);
            }
        }
    }

    default public void validateRequiredAttributes(TargetObject object, boolean strict) {
        Set<String> present = object.getCachedAttributes().keySet();
        Set missing = this.getAttributeSchemas().values().stream().filter(AttributeSchema::isRequired).map(AttributeSchema::getName).filter(a -> !present.contains(a)).collect(Collectors.toSet());
        if (!missing.isEmpty()) {
            String msg = "Object " + object + " is missing required attributes " + missing + " of schema " + this;
            Msg.error((Object)this, (Object)msg);
            if (strict) {
                throw new AssertionError((Object)msg);
            }
        }
    }

    default public void validateAttributeDelta(List<String> parentPath, CollectionUtils.Delta<?, ?> delta, boolean strict) {
        Set violatesFixed;
        for (Map.Entry ent : delta.added.entrySet()) {
            String key = ent.getKey();
            Object value = ent.getValue();
            AttributeSchema as = this.getAttributeSchema(key);
            TargetObjectSchema schema = this.getContext().getSchema(as.getSchema());
            schema.validateTypeAndInterfaces(value, parentPath, key, strict);
        }
        Set violatesRequired = this.getAttributeSchemas().values().stream().filter(AttributeSchema::isRequired).map(AttributeSchema::getName).filter(delta.getKeysRemoved()::contains).collect(Collectors.toSet());
        if (!violatesRequired.isEmpty()) {
            String msg = "Object " + parentPath + " removed required attributes " + violatesRequired + " of schema " + this;
            Msg.error((Object)this, (Object)msg);
            if (strict) {
                throw new AssertionError((Object)msg);
            }
        }
        if (!(violatesFixed = this.getAttributeSchemas().values().stream().filter(AttributeSchema::isFixed).map(AttributeSchema::getName).filter(delta.removed::containsKey).collect(Collectors.toSet())).isEmpty()) {
            String msg = "Object " + parentPath + " modified or removed fixed attributes " + violatesFixed + " of schema " + this;
            Msg.error((Object)this, (Object)msg);
            if (strict) {
                throw new AssertionError((Object)msg);
            }
        }
    }

    default public void validateElementDelta(List<String> parentPath, CollectionUtils.Delta<?, ? extends TargetObject> delta, boolean strict) {
        for (Map.Entry ent : delta.added.entrySet()) {
            TargetObject element = (TargetObject)ent.getValue();
            TargetObjectSchema schema = this.getContext().getSchema(this.getElementSchema(ent.getKey()));
            schema.validateTypeAndInterfaces(element, parentPath, ent.getKey(), strict);
        }
    }

    default public PathPredicates searchForRegisterContainer(int frameLevel, List<String> path) {
        List<String> simple = this.searchForSuitable(TargetRegisterContainer.class, path);
        if (simple != null) {
            return PathPredicates.pattern(simple);
        }
        List<String> stackPath = this.searchForSuitable(TargetStack.class, path);
        if (stackPath == null) {
            return PathPredicates.EMPTY;
        }
        PathPattern framePatternRelStack = this.getSuccessorSchema(stackPath).searchFor(TargetStackFrame.class, false).getSingletonPattern();
        if (framePatternRelStack == null) {
            return PathPredicates.EMPTY;
        }
        if (framePatternRelStack.countWildcards() != 1) {
            return null;
        }
        PathMatcher result = new PathMatcher();
        for (String string : List.of(Integer.toString(frameLevel), "0x" + Integer.toHexString(frameLevel))) {
            List<String> framePathRelStack = framePatternRelStack.applyKeys(string).getSingletonPath();
            List<String> framePath = PathUtils.extend(stackPath, framePathRelStack);
            List<String> regsPath = this.searchForSuitable(TargetRegisterContainer.class, framePath);
            if (regsPath == null) continue;
            result.addPattern(regsPath);
        }
        return result;
    }

    default public int computeFrameLevel(List<String> path) {
        int i;
        List<String> framePath = this.searchForAncestor(TargetStackFrame.class, path);
        if (framePath == null) {
            return 0;
        }
        List<String> stackPath = this.searchForAncestor(TargetStack.class, framePath);
        int n = i = stackPath == null ? 0 : stackPath.size();
        while (i < framePath.size()) {
            String key = framePath.get(i);
            if (PathUtils.isIndex(key)) {
                return Integer.decode(PathUtils.parseIndex(key));
            }
            ++i;
        }
        throw new IllegalArgumentException("No index between stack and frame");
    }

    public static class SchemaName
    implements Comparable<SchemaName> {
        private final String name;

        public SchemaName(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SchemaName)) {
                return false;
            }
            SchemaName that = (SchemaName)obj;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(SchemaName o) {
            return this.name.compareTo(o.name);
        }
    }

    public static interface AttributeSchema {
        public static final AttributeSchema DEFAULT_ANY = new DefaultTargetObjectSchema.DefaultAttributeSchema("", EnumerableTargetObjectSchema.ANY.getName(), false, false, true);
        public static final AttributeSchema DEFAULT_OBJECT = new DefaultTargetObjectSchema.DefaultAttributeSchema("", EnumerableTargetObjectSchema.OBJECT.getName(), false, false, true);
        public static final AttributeSchema DEFAULT_VOID = new DefaultTargetObjectSchema.DefaultAttributeSchema("", EnumerableTargetObjectSchema.VOID.getName(), false, true, true);

        public String getName();

        public SchemaName getSchema();

        public boolean isRequired();

        public boolean isFixed();

        public boolean isHidden();
    }

    public static class Private {
        private static void searchFor(TargetObjectSchema sch, PathMatcher result, List<String> prefix, boolean parentIsCanonical, Class<? extends TargetObject> type, boolean requireAggregate, boolean requireCanonical, Set<TargetObjectSchema> visited) {
            if (sch instanceof EnumerableTargetObjectSchema) {
                return;
            }
            if (sch.getInterfaces().contains(type) && (parentIsCanonical || !requireCanonical)) {
                result.addPattern(prefix);
                return;
            }
            if (!visited.add(sch)) {
                return;
            }
            if (requireAggregate && !sch.getInterfaces().contains(TargetAggregate.class)) {
                return;
            }
            SchemaContext ctx = sch.getContext();
            boolean isCanonical = sch.isCanonicalContainer();
            for (Map.Entry<String, SchemaName> ent : sch.getElementSchemas().entrySet()) {
                List<String> extended = PathUtils.index(prefix, ent.getKey());
                TargetObjectSchema targetObjectSchema = ctx.getSchema(ent.getValue());
                Private.searchFor(targetObjectSchema, result, extended, isCanonical, type, requireAggregate, requireCanonical, visited);
            }
            List<String> deExtended = PathUtils.extend(prefix, "[]");
            TargetObjectSchema deSchema = ctx.getSchema(sch.getDefaultElementSchema());
            Private.searchFor(deSchema, result, deExtended, isCanonical, type, requireAggregate, requireCanonical, visited);
            for (Map.Entry entry : sch.getAttributeSchemas().entrySet()) {
                List<String> extended = PathUtils.extend(prefix, (String)entry.getKey());
                TargetObjectSchema attrSchema = ctx.getSchema(((AttributeSchema)entry.getValue()).getSchema());
                Private.searchFor(attrSchema, result, extended, isCanonical, type, requireAggregate, requireCanonical, visited);
            }
            List<String> daExtended = PathUtils.extend(prefix, "");
            TargetObjectSchema targetObjectSchema = ctx.getSchema(sch.getDefaultAttributeSchema().getSchema());
            Private.searchFor(targetObjectSchema, result, daExtended, isCanonical, type, requireAggregate, requireCanonical, visited);
            visited.remove(sch);
        }

        static List<String> searchForInAggregate(TargetObjectSchema seed, Predicate<SearchEntry> predicate) {
            InAggregateSearch inAgg = new InAggregateSearch(seed);
            while (!inAgg.allOnLevel.isEmpty()) {
                Set found = inAgg.allOnLevel.stream().filter(predicate).collect(Collectors.toSet());
                if (!found.isEmpty()) {
                    if (found.size() == 1) {
                        return ((SearchEntry)found.iterator().next()).path;
                    }
                    return null;
                }
                inAgg.nextLevel();
            }
            return null;
        }

        static List<String> searchForSuitableInAggregate(TargetObjectSchema seed, Class<? extends TargetObject> type) {
            return Private.searchForInAggregate(seed, ent -> ent.schema.getInterfaces().contains(type));
        }

        static List<String> searchForSuitableContainerInAggregate(TargetObjectSchema seed, Class<? extends TargetObject> type) {
            return Private.searchForInAggregate(seed, ent -> {
                if (!ent.schema.isCanonicalContainer()) {
                    return false;
                }
                TargetObjectSchema deSchema = ent.schema.getContext().getSchema(ent.schema.getDefaultElementSchema());
                return deSchema.getInterfaces().contains(type);
            });
        }

        private static class InAggregateSearch
        extends BreadthFirst<SearchEntry> {
            final Set<TargetObjectSchema> visited = new HashSet<TargetObjectSchema>();

            public InAggregateSearch(TargetObjectSchema seed) {
                super(Set.of(new SearchEntry(List.of(), seed)));
            }

            @Override
            public boolean descend(SearchEntry ent) {
                return ent.schema.getInterfaces().contains(TargetAggregate.class);
            }

            @Override
            public void expandAttribute(Set<SearchEntry> nextLevel, SearchEntry ent, TargetObjectSchema schema, List<String> path) {
                if (this.visited.add(schema)) {
                    nextLevel.add(new SearchEntry(path, schema));
                }
            }

            @Override
            public void expandDefaultAttribute(Set<SearchEntry> nextLevel, SearchEntry ent) {
            }

            @Override
            public void expandElements(Set<SearchEntry> nextLevel, SearchEntry ent) {
            }

            @Override
            public void expandDefaultElement(Set<SearchEntry> nextLevel, SearchEntry ent) {
            }
        }

        private static class SearchEntry {
            final List<String> path;
            final TargetObjectSchema schema;

            public SearchEntry(List<String> path, TargetObjectSchema schema) {
                this.path = path;
                this.schema = schema;
            }
        }

        private static class CanonicalSearchEntry
        extends SearchEntry {
            final boolean parentIsCanonical;

            public CanonicalSearchEntry(List<String> path, boolean parentIsCanonical, TargetObjectSchema schema) {
                super(path, schema);
                this.parentIsCanonical = parentIsCanonical;
            }
        }

        private static abstract class BreadthFirst<T extends SearchEntry> {
            Set<T> allOnLevel = new HashSet<T>();

            public BreadthFirst(Set<T> seed) {
                this.allOnLevel.addAll(seed);
            }

            public void expandAttributes(Set<T> nextLevel, T ent) {
                SchemaContext ctx = ((SearchEntry)ent).schema.getContext();
                for (AttributeSchema as : ((SearchEntry)ent).schema.getAttributeSchemas().values()) {
                    try {
                        SchemaName schema = as.getSchema();
                        TargetObjectSchema child = ctx.getSchema(schema);
                        this.expandAttribute(nextLevel, ent, child, PathUtils.extend(((SearchEntry)ent).path, as.getName()));
                    }
                    catch (NullPointerException npe) {
                        Msg.error((Object)this, (Object)("Null schema for " + as));
                    }
                }
            }

            public void expandDefaultAttribute(Set<T> nextLevel, T ent) {
                SchemaContext ctx = ((SearchEntry)ent).schema.getContext();
                AttributeSchema das = ((SearchEntry)ent).schema.getDefaultAttributeSchema();
                TargetObjectSchema child = ctx.getSchema(das.getSchema());
                this.expandAttribute(nextLevel, ent, child, PathUtils.extend(((SearchEntry)ent).path, das.getName()));
            }

            public void expandElements(Set<T> nextLevel, T ent) {
                SchemaContext ctx = ((SearchEntry)ent).schema.getContext();
                for (Map.Entry<String, SchemaName> elemEnt : ((SearchEntry)ent).schema.getElementSchemas().entrySet()) {
                    TargetObjectSchema child = ctx.getSchema(elemEnt.getValue());
                    this.expandElement(nextLevel, ent, child, PathUtils.index(((SearchEntry)ent).path, elemEnt.getKey()));
                }
            }

            public void expandDefaultElement(Set<T> nextLevel, T ent) {
                SchemaContext ctx = ((SearchEntry)ent).schema.getContext();
                TargetObjectSchema child = ctx.getSchema(((SearchEntry)ent).schema.getDefaultElementSchema());
                this.expandElement(nextLevel, ent, child, PathUtils.index(((SearchEntry)ent).path, ""));
            }

            public void nextLevel() {
                HashSet<T> nextLevel = new HashSet<T>();
                for (SearchEntry ent : this.allOnLevel) {
                    if (!this.descend(ent)) continue;
                    this.expandAttributes(nextLevel, ent);
                    this.expandDefaultAttribute(nextLevel, ent);
                    this.expandElements(nextLevel, ent);
                    this.expandDefaultElement(nextLevel, ent);
                }
                this.allOnLevel = nextLevel;
            }

            public boolean descend(T ent) {
                return true;
            }

            public void expandAttribute(Set<T> nextLevel, T ent, TargetObjectSchema schema, List<String> path) {
            }

            public void expandElement(Set<T> nextLevel, T ent, TargetObjectSchema schema, List<String> path) {
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ResyncMode {
        NEVER{

            @Override
            public boolean shouldResync(CompletableFuture<Void> curRequest) {
                return false;
            }
        }
        ,
        ONCE{

            @Override
            public boolean shouldResync(CompletableFuture<Void> curRequest) {
                return curRequest == null || curRequest.isCompletedExceptionally();
            }
        }
        ,
        ALWAYS{

            @Override
            public boolean shouldResync(CompletableFuture<Void> curRequest) {
                return true;
            }
        };


        public abstract boolean shouldResync(CompletableFuture<Void> var1);
    }
}

