/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelClosedReason;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class DebuggerCallbackReorderer
implements DebuggerModelListener {
    private final DebuggerModelListener listener;
    private final Map<TargetObject, ObjectRecord> records = new HashMap<TargetObject, ObjectRecord>();
    private CompletableFuture<Void> lastEvent = AsyncUtils.NIL;
    private volatile boolean disposed = false;

    public DebuggerCallbackReorderer(DebuggerModelListener listener) {
        this.listener = listener;
    }

    private void defensive(Runnable r, String cb) {
        try {
            r.run();
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Listener " + this.listener + " caused exception processing " + cb), (Throwable)t);
        }
    }

    @Override
    public void catastrophic(Throwable t) {
        if (this.disposed) {
            return;
        }
        this.listener.catastrophic(t);
    }

    @Override
    public void modelClosed(DebuggerModelClosedReason reason) {
        if (this.disposed) {
            return;
        }
        this.listener.modelClosed(reason);
    }

    @Override
    public void modelOpened() {
        if (this.disposed) {
            return;
        }
        this.listener.modelOpened();
    }

    @Override
    public void modelStateChanged() {
        if (this.disposed) {
            return;
        }
        this.listener.modelStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void created(TargetObject object) {
        if (this.disposed) {
            return;
        }
        Map<TargetObject, ObjectRecord> map = this.records;
        synchronized (map) {
            this.records.put(object, new ObjectRecord(object));
        }
        this.defensive(() -> this.listener.created(object), "created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidated(TargetObject object, TargetObject branch, String reason) {
        ObjectRecord remove;
        if (this.disposed) {
            return;
        }
        Map<TargetObject, ObjectRecord> map = this.records;
        synchronized (map) {
            remove = this.records.remove(object);
        }
        if (remove != null) {
            remove.removed();
        }
        this.defensive(() -> this.listener.invalidated(object, branch, reason), "invalidated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rootAdded(TargetObject root) {
        if (this.disposed) {
            return;
        }
        this.defensive(() -> this.listener.rootAdded(root), "rootAdded");
        Map<TargetObject, ObjectRecord> map = this.records;
        synchronized (map) {
            this.records.get(root).added();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attributesChanged(TargetObject object, Collection<String> removed, Map<String, ?> added) {
        ObjectRecord record;
        if (this.disposed) {
            return;
        }
        Map<TargetObject, ObjectRecord> map = this.records;
        synchronized (map) {
            record = this.records.get(object);
        }
        if (record == null) {
            this.defensive(() -> this.listener.attributesChanged(object, removed, added), "attributesChanged");
        }
        for (Map.Entry entry : added.entrySet()) {
            ObjectRecord rec;
            Object val = entry.getValue();
            if (!(val instanceof TargetObject)) continue;
            TargetObject obj = (TargetObject)val;
            if (PathUtils.isLink(object.getPath(), (String)entry.getKey(), obj.getPath())) continue;
            Map<TargetObject, ObjectRecord> map2 = this.records;
            synchronized (map2) {
                rec = this.records.get(obj);
            }
            if (rec == null) continue;
            rec.added();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void elementsChanged(TargetObject object, Collection<String> removed, Map<String, ? extends TargetObject> added) {
        ObjectRecord record;
        if (this.disposed) {
            return;
        }
        Map<TargetObject, ObjectRecord> map = this.records;
        synchronized (map) {
            record = this.records.get(object);
        }
        if (record == null) {
            this.defensive(() -> this.listener.elementsChanged(object, removed, added), "elementsChanged");
        }
        for (Map.Entry entry : added.entrySet()) {
            ObjectRecord rec;
            TargetObject obj = (TargetObject)entry.getValue();
            if (PathUtils.isElementLink(object.getPath(), (String)entry.getKey(), obj.getPath())) continue;
            Map<TargetObject, ObjectRecord> map2 = this.records;
            synchronized (map2) {
                rec = this.records.get(obj);
            }
            if (rec == null) continue;
            rec.added();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orderedOnObjects(Collection<TargetObject> objects, Runnable r, String cb) {
        AsyncFence fence = new AsyncFence();
        fence.include(this.lastEvent);
        Map<TargetObject, ObjectRecord> map = this.records;
        synchronized (map) {
            for (TargetObject obj : objects) {
                ObjectRecord record = this.records.get(obj);
                if (record == null) continue;
                fence.include(record.complete);
            }
        }
        this.lastEvent = ((CompletableFuture)fence.ready().thenAccept(__ -> this.defensive(r, cb))).exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Callback " + cb + " dropped for error in dependency"), (Throwable)ex);
            return null;
        });
    }

    @Override
    public void breakpointHit(TargetObject container, TargetObject trapped, TargetStackFrame frame, TargetBreakpointSpec spec, TargetBreakpointLocation breakpoint) {
        if (this.disposed) {
            return;
        }
        List<TargetObject> args = frame == null ? List.of(container, trapped, spec, breakpoint) : List.of(container, trapped, frame, spec, breakpoint);
        this.orderedOnObjects(args, () -> this.listener.breakpointHit(container, trapped, frame, spec, breakpoint), "breakpointHit");
    }

    @Override
    public void consoleOutput(TargetObject console, TargetConsole.Channel channel, byte[] data) {
        if (this.disposed) {
            return;
        }
        this.orderedOnObjects(List.of(console), () -> this.listener.consoleOutput(console, channel, data), "consoleOutput");
    }

    private Collection<TargetObject> gatherObjects(Collection<?> ... collections) {
        HashSet<TargetObject> objs = new HashSet<TargetObject>();
        for (Collection<?> col : collections) {
            for (Object val : col) {
                if (!(val instanceof TargetObject)) continue;
                objs.add((TargetObject)val);
            }
        }
        return objs;
    }

    @Override
    public void event(TargetObject object, TargetThread eventThread, TargetEventScope.TargetEventType type, String description, List<Object> parameters) {
        if (this.disposed) {
            return;
        }
        List<TargetObject> objs = eventThread == null ? List.of(object) : List.of(object, eventThread);
        this.orderedOnObjects(this.gatherObjects(objs, parameters), () -> this.listener.event(object, eventThread, type, description, parameters), "event(" + type + ") " + description);
    }

    @Override
    public void invalidateCacheRequested(TargetObject object) {
        if (this.disposed) {
            return;
        }
        this.orderedOnObjects(List.of(object), () -> this.listener.invalidateCacheRequested(object), "invalidateCacheRequested");
    }

    @Override
    public void memoryReadError(TargetObject memory, AddressRange range, DebuggerMemoryAccessException e) {
        if (this.disposed) {
            return;
        }
        this.orderedOnObjects(List.of(memory), () -> this.listener.memoryReadError(memory, range, e), "invalidateCacheRequested");
    }

    @Override
    public void memoryUpdated(TargetObject memory, Address address, byte[] data) {
        if (this.disposed) {
            return;
        }
        this.orderedOnObjects(List.of(memory), () -> this.listener.memoryUpdated(memory, address, data), "invalidateCacheRequested");
    }

    @Override
    public void registersUpdated(TargetObject bank, Map<String, byte[]> updates) {
        if (this.disposed) {
            return;
        }
        this.orderedOnObjects(List.of(bank), () -> this.listener.registersUpdated(bank, updates), "invalidateCacheRequested");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Set<ObjectRecord> volRecs;
        this.disposed = true;
        Map<TargetObject, ObjectRecord> map = this.records;
        synchronized (map) {
            volRecs = Set.copyOf(this.records.values());
            this.records.clear();
        }
        for (ObjectRecord rec : volRecs) {
            rec.cancel();
        }
    }

    public CompletableFuture<Void> flushEvents() {
        return this.lastEvent.thenApply(v -> v);
    }

    private class ObjectRecord {
        private final TargetObject obj;
        private final CompletableFuture<TargetObject> addedToParent = new CompletableFuture();
        private final CompletableFuture<TargetObject> complete;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ObjectRecord(TargetObject obj) {
            ObjectRecord parentRecord;
            this.obj = obj;
            TargetObject parent = obj.getParent();
            Map<TargetObject, ObjectRecord> map = DebuggerCallbackReorderer.this.records;
            synchronized (map) {
                parentRecord = parent == null ? null : DebuggerCallbackReorderer.this.records.get(parent);
            }
            this.complete = parentRecord == null ? this.addedToParent.thenApply(this::completed) : ((CompletableFuture)parentRecord.complete.thenCompose(__ -> this.addedToParent)).thenApply(this::completed);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TargetObject completed(TargetObject obj) {
            Map<String, ? extends TargetObject> elements;
            Map<TargetObject, ObjectRecord> map = DebuggerCallbackReorderer.this.records;
            synchronized (map) {
                DebuggerCallbackReorderer.this.records.remove(obj);
            }
            Map<String, ?> attributes = obj.getCallbackAttributes();
            if (!attributes.isEmpty()) {
                DebuggerCallbackReorderer.this.defensive(() -> DebuggerCallbackReorderer.this.listener.attributesChanged(obj, List.of(), Map.copyOf(attributes)), "attributesChanged(r)");
            }
            if (!(elements = obj.getCallbackElements()).isEmpty()) {
                DebuggerCallbackReorderer.this.defensive(() -> DebuggerCallbackReorderer.this.listener.elementsChanged(obj, List.of(), Map.copyOf(elements)), "elementsChanged(r)");
            }
            return obj;
        }

        void added() {
            if (!this.addedToParent.isDone()) {
                this.addedToParent.complete(this.obj);
            }
        }

        void removed() {
            if (!this.addedToParent.isDone()) {
                this.addedToParent.cancel(false);
            }
        }

        public void cancel() {
            this.addedToParent.cancel(false);
            this.complete.cancel(false);
        }
    }
}

