/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import javax.swing.Timer;
import utilities.util.reflection.ReflectionUtilities;

public abstract class AbstractSwingUpdateManager {
    protected static final long NONE = 0L;
    public static final int DEFAULT_MAX_DELAY = 30000;
    protected static final int MIN_DELAY_FLOOR = 10;
    public static final int DEFAULT_MIN_DELAY = 250;
    protected static final String DEFAULT_NAME = AbstractSwingUpdateManager.class.getSimpleName();
    private static final WeakSet<AbstractSwingUpdateManager> instances = WeakDataStructureFactory.createCopyOnReadWeakSet();
    protected final Timer timer;
    private final int minDelay;
    private final int maxDelay;
    private final String name;
    private String inceptionInformation;
    private long requestTime = 0L;
    private long bufferingStartTime;
    private boolean disposed = false;
    protected boolean isWorking;

    protected AbstractSwingUpdateManager() {
        this(250, 30000);
    }

    protected AbstractSwingUpdateManager(int minDelay) {
        this(minDelay, 30000);
    }

    protected AbstractSwingUpdateManager(int minDelay, int maxDelay) {
        this(minDelay, maxDelay, DEFAULT_NAME);
    }

    protected AbstractSwingUpdateManager(int minDelay, int maxDelay, String name) {
        this.maxDelay = maxDelay;
        this.name = name;
        this.recordInception();
        this.minDelay = Math.max(10, minDelay);
        this.timer = new Timer(minDelay, e -> this.timerCallback());
        this.timer.setRepeats(false);
        instances.add((Object)this);
    }

    protected abstract void swingDoWork();

    protected synchronized void update() {
        if (this.disposed) {
            return;
        }
        this.requestTime = System.currentTimeMillis();
        Swing.runLater(this::checkForWork);
    }

    protected synchronized void updateLater() {
        if (this.disposed) {
            return;
        }
        this.requestTime = System.currentTimeMillis();
        this.bufferingStartTime = this.bufferingStartTime == 0L ? this.requestTime : this.bufferingStartTime;
        this.scheduleCheckForWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNow() {
        AbstractSwingUpdateManager abstractSwingUpdateManager = this;
        synchronized (abstractSwingUpdateManager) {
            if (this.disposed) {
                return;
            }
            this.requestTime = System.currentTimeMillis();
            this.bufferingStartTime = 0L;
        }
        Swing.runNow(this::checkForWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        AbstractSwingUpdateManager abstractSwingUpdateManager = this;
        synchronized (abstractSwingUpdateManager) {
            if (this.disposed) {
                return;
            }
            if (!this.hasPendingUpdates()) {
                return;
            }
            this.requestTime = System.currentTimeMillis();
            this.bufferingStartTime = 0L;
        }
        Swing.runNow(this::checkForWork);
    }

    public synchronized void stop() {
        if (this.disposed) {
            return;
        }
        this.timer.stop();
        this.requestTime = 0L;
        this.bufferingStartTime = 0L;
    }

    public synchronized boolean hasPendingUpdates() {
        if (this.disposed) {
            return false;
        }
        return this.requestTime != 0L;
    }

    public synchronized boolean isBusy() {
        if (this.disposed) {
            return false;
        }
        return this.requestTime != 0L || this.isWorking;
    }

    public synchronized void dispose() {
        this.timer.stop();
        instances.remove((Object)this);
        this.requestTime = 0L;
        this.bufferingStartTime = 0L;
        this.disposed = true;
    }

    public synchronized boolean isDisposed() {
        return this.disposed;
    }

    public String toString() {
        return this.name + " @ " + this.inceptionInformation;
    }

    public String toStringDebug() {
        return "{\n\tname: " + this.name + "\n\tcreator: " + this.inceptionInformation + " (" + System.identityHashCode(this) + ")\n\trequest time: " + this.requestTime + "\n\twork count: " + this.isWorking + "\n}";
    }

    protected void checkForWork() {
        if (this.shouldDoWork()) {
            this.swingExecutePendingWork();
        }
    }

    private void timerCallback() {
        if (this.shouldDoWork()) {
            this.swingExecutePendingWork();
        } else if (this.requestTime == 0L) {
            this.bufferingStartTime = 0L;
        }
    }

    private synchronized boolean shouldDoWork() {
        if (this.requestTime == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.isTimeToWork(now)) {
            this.bufferingStartTime = now;
            this.requestTime = 0L;
            this.isWorking = true;
            return true;
        }
        this.scheduleCheckForWork();
        return false;
    }

    protected void scheduleCheckForWork() {
        this.timer.start();
    }

    private boolean isTimeToWork(long now) {
        long timeSinceBufferingStart = now - this.bufferingStartTime;
        if (timeSinceBufferingStart > (long)this.maxDelay) {
            return true;
        }
        long timeSinceLastRequest = now - this.requestTime;
        return timeSinceLastRequest > (long)this.minDelay;
    }

    private void swingExecutePendingWork() {
        try {
            this.swingDoWork();
        }
        catch (Throwable t) {
            Msg.showError((Object)this, null, (String)"Unexpected Exception", (Object)"Unexpected exception in Swing Update Manager", (Throwable)t);
        }
        this.isWorking = false;
        this.scheduleCheckForWork();
    }

    private void recordInception() {
        this.inceptionInformation = this.getInceptionFromTheFirstClassThatIsNotUs();
    }

    private String getInceptionFromTheFirstClassThatIsNotUs() {
        Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan((Class[])new Class[]{this.getClass()});
        StackTraceElement[] trace = t.getStackTrace();
        String classInfo = trace[0].toString();
        return classInfo;
    }
}

