/*
 * Decompiled with CFR 0.152.
 */
package resources;

import generic.theme.GIcon;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.RepaintManager;
import org.apache.commons.lang3.StringUtils;
import resources.icons.BytesImageIcon;
import resources.icons.ColorIcon3D;
import resources.icons.DerivedImageIcon;
import resources.icons.DisabledImageIcon;
import resources.icons.EmptyIcon;
import resources.icons.FileBasedIcon;
import resources.icons.ScaledImageIcon;
import resources.icons.TranslateIcon;
import resources.icons.UnresolvedIcon;
import resources.icons.UrlImageIcon;
import utility.module.ModuleUtilities;

public class ResourceManager {
    public static final String BOMB = "images/core.png";
    public static final String BIG_BOMB = "images/core24.png";
    public static final String EXTERNAL_ICON_PREFIX = "[EXTERNAL]";
    private static final Map<String, ImageIcon> iconMap = new HashMap<String, ImageIcon>();
    private static List<String> defaultSearchPaths;
    private static List<String> testSearchPaths;
    private static ClassLoader classLoader;
    private static final ImageIcon DEFAULT_ICON;

    public static URL getResource(String filename) {
        URL url = classLoader.getResource(filename);
        if (url != null) {
            return url;
        }
        url = ResourceManager.getResource(ResourceManager.getTestSearchPaths(), filename);
        return url;
    }

    public static InputStream getResourceAsStream(String filename) {
        InputStream is = classLoader.getResourceAsStream(filename);
        if (is != null) {
            return is;
        }
        URL url = ResourceManager.getResource(ResourceManager.getTestSearchPaths(), filename);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            Msg.debug(RepaintManager.class, (Object)("Unable to open input stream for " + url), (Throwable)e);
            return null;
        }
    }

    public static File getResourceFile(String filename) {
        URL url = ResourceManager.getResource(filename);
        if (url == null || !"file".equals(url.getProtocol())) {
            return null;
        }
        try {
            URI uri = new URI(url.toExternalForm());
            return new File(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can not find resource " + filename);
        }
    }

    private static URL getResource(List<String> searchPaths, String filename) {
        for (String path : searchPaths) {
            File f = new File(path, filename);
            if (!f.exists()) continue;
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                Msg.debug(ResourceManager.class, (Object)"Unable to create URL for file", (Throwable)e);
            }
        }
        return null;
    }

    public static Set<URL> getResources(String dirName, String extension) {
        Set<String> names = ResourceManager.doGetResourceNames(ResourceManager.getDefaultSearchPaths(), dirName, extension);
        Set<String> testNames = ResourceManager.doGetResourceNames(ResourceManager.getTestSearchPaths(), dirName, extension);
        names.addAll(testNames);
        Set<URL> urls = names.stream().map(name -> ResourceManager.getResource(name)).collect(Collectors.toSet());
        return urls;
    }

    public static Set<String> getResourceNames(String dirName, String extension) {
        Set<String> resourceNames = ResourceManager.doGetResourceNames(ResourceManager.getDefaultSearchPaths(), dirName, extension);
        Set<String> testResourceNames = ResourceManager.doGetResourceNames(ResourceManager.getTestSearchPaths(), dirName, extension);
        resourceNames.addAll(testResourceNames);
        return resourceNames;
    }

    private static Set<String> doGetResourceNames(List<String> paths, String resourceDirName, String extension) {
        HashSet<String> set = new HashSet<String>();
        for (String path : paths) {
            if (!StringUtils.endsWithAny((CharSequence)path.toLowerCase(), (CharSequence[])new CharSequence[]{".jar", ".zip"})) {
                String classpathDirectoryEntry = path + File.separator + resourceDirName;
                File f = new File(classpathDirectoryEntry);
                ResourceManager.findResources(set, f, resourceDirName, extension);
                continue;
            }
            File file = new File(path);
            try {
                if (!file.exists()) continue;
                ResourceManager.searchJarFile(set, file, resourceDirName, extension);
            }
            catch (IOException e) {
                Msg.error(ResourceManager.class, (Object)"Unable to search compressed file", (Throwable)e);
            }
        }
        return set;
    }

    private static void findResources(Set<String> set, File file, String dirName, String extension) {
        if (!file.exists()) {
            return;
        }
        String[] names = file.list();
        if (names == null) {
            return;
        }
        for (String element : names) {
            if (extension != null && !element.endsWith(extension)) continue;
            set.add(dirName + "/" + element);
        }
    }

    private static void searchJarFile(Set<String> set, File file, String resourceDirName, String extension) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                File entryAsFile;
                String startPath;
                JarEntry entry = entries.nextElement();
                if (entry.getSize() == 0L) continue;
                String name = entry.getName();
                if (extension != null && !name.endsWith(extension) || !name.startsWith(startPath = resourceDirName) || (entryAsFile = new File(name = name.substring(startPath.length() + 1))).getParent() != null) continue;
                set.add(entry.getName());
            }
        }
    }

    public static ImageIcon getScaledIcon(Icon icon, int width, int height, int hints) {
        return new ScaledImageIcon(icon, width, height, hints);
    }

    public static ImageIcon getScaledIcon(ImageIcon icon, int width, int height) {
        return new ScaledImageIcon(icon, width, height);
    }

    public static Icon getScaledIcon(Icon icon, int width, int height) {
        if (icon instanceof EmptyIcon) {
            return new EmptyIcon(width, height);
        }
        return new ScaledImageIcon(icon, width, height);
    }

    public static ImageIcon getDisabledIcon(Icon icon) {
        return new DisabledImageIcon(icon);
    }

    public static ImageIcon getDisabledIcon(ImageIcon icon) {
        return new DisabledImageIcon(icon);
    }

    public static ImageIcon getDisabledIcon(Icon icon, int brightnessPercent) {
        return new DisabledImageIcon(icon, brightnessPercent);
    }

    public static ImageIcon getImageIconFromImage(String imageName, Image image) {
        return new DerivedImageIcon(imageName, image);
    }

    public static ImageIcon getImageIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        if (icon instanceof GIcon) {
            return ((GIcon)icon).getImageIcon();
        }
        return new DerivedImageIcon(icon);
    }

    public static String getIconName(Icon icon) {
        if (icon instanceof FileBasedIcon) {
            return ((FileBasedIcon)((Object)icon)).getFilename();
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getDescription();
        }
        if (icon instanceof GIcon) {
            GIcon gIcon = (GIcon)icon;
            Icon delegateIcon = gIcon.getDelegate();
            String name = ResourceManager.getIconName(delegateIcon);
            if (name != null) {
                return name;
            }
            return ((GIcon)icon).getId();
        }
        if (icon instanceof TranslateIcon) {
            return ResourceManager.getIconName(((TranslateIcon)icon).getBaseIcon());
        }
        return icon.toString();
    }

    public static ImageIcon loadImage(String imageName, byte[] imageBytes) {
        ImageIcon icon = iconMap.get(imageName);
        if (icon != null) {
            return icon;
        }
        icon = new BytesImageIcon(imageName, imageBytes);
        iconMap.put(imageName, icon);
        return icon;
    }

    public static ImageIcon loadImage(String filename, int width, int height) {
        ImageIcon loadImage = ResourceManager.loadImage(filename);
        if (loadImage == null) {
            return null;
        }
        return ResourceManager.getScaledIcon(loadImage, width, height);
    }

    public static ImageIcon findIcon(String path) {
        ImageIcon icon = iconMap.get(path);
        if (icon == null && (icon = ResourceManager.doLoadIcon(path)) != null) {
            iconMap.put(path, icon);
        }
        return icon;
    }

    public static Icon loadIcon(String iconPath) {
        ImageIcon icon = iconMap.get(iconPath);
        if (icon == null && (icon = ResourceManager.doLoadIcon(iconPath)) != null) {
            iconMap.put(iconPath, icon);
        }
        return icon;
    }

    public static ImageIcon loadImage(String iconPath) {
        ImageIcon icon = iconMap.get(iconPath);
        if (icon == null && (icon = ResourceManager.doLoadIcon(iconPath)) != null) {
            iconMap.put(iconPath, icon);
        }
        return icon == null ? new UnresolvedIcon(iconPath, DEFAULT_ICON) : icon;
    }

    public static Set<Icon> getLoadedIcons() {
        return new HashSet<Icon>(iconMap.values());
    }

    private static UrlImageIcon doLoadIcon(String path) {
        URL url;
        if (path.startsWith(EXTERNAL_ICON_PREFIX)) {
            String relativePath = path.substring(EXTERNAL_ICON_PREFIX.length());
            File dir = Application.getUserSettingsDirectory();
            File iconFile = new File(dir, relativePath);
            if (iconFile.exists()) {
                try {
                    return new UrlImageIcon(path, iconFile.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
        if (!path.contains("/") && (url = ResourceManager.getResource("images/" + path)) != null) {
            return new UrlImageIcon(path, url);
        }
        url = ResourceManager.getResource(path);
        if (url != null) {
            return new UrlImageIcon(path, url);
        }
        File imageFile = new File(path);
        if (imageFile.exists()) {
            try {
                return new UrlImageIcon(path, imageFile.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<ImageIcon> loadImages(String ... filenames) {
        ArrayList<ImageIcon> results = new ArrayList<ImageIcon>(filenames.length);
        for (String filename : filenames) {
            results.add(ResourceManager.loadImage(filename));
        }
        return results;
    }

    public static ImageIcon reloadImage(String filename) {
        iconMap.remove(filename);
        return ResourceManager.loadImage(filename);
    }

    public static ImageIcon getDefaultIcon() {
        return DEFAULT_ICON;
    }

    public static Set<String> getToolImages() {
        Set<String> list = ResourceManager.getResourceNames("defaultTools/images", null);
        ResourceManager.filterImages(list);
        return list;
    }

    private static ImageIcon loadDefaultIcon() {
        URL url = ResourceManager.getResource(BOMB);
        if (url != null) {
            return new UrlImageIcon(BOMB, url);
        }
        Msg.error(ResourceManager.class, (Object)"Could not find default icon: images/core.png");
        return ResourceManager.getImageIcon(new ColorIcon3D(Color.RED, 16, 16));
    }

    private static void filterImages(Set<String> set) {
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            String filename = it.next().toLowerCase();
            if (StringUtils.endsWithAny((CharSequence)filename, (CharSequence[])new CharSequence[]{".gif", ".jpg", ".png"})) continue;
            it.remove();
        }
    }

    private static synchronized List<String> getDefaultSearchPaths() {
        if (defaultSearchPaths != null) {
            return defaultSearchPaths;
        }
        ArrayList<String> results = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path");
        String java = System.getProperty("java.home");
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreElements()) {
            String path = st.nextToken();
            if (path.startsWith(java)) continue;
            results.add(path);
        }
        defaultSearchPaths = results;
        return results;
    }

    private static List<String> getTestSearchPaths() {
        if (testSearchPaths != null) {
            return testSearchPaths;
        }
        if (!SystemUtilities.isInTestingMode()) {
            testSearchPaths = Collections.emptyList();
            return testSearchPaths;
        }
        ArrayList<String> results = new ArrayList<String>();
        List<String> searchPaths = ResourceManager.getDefaultSearchPaths();
        for (String path : searchPaths) {
            Path modulePath = ModuleUtilities.getModule((String)path);
            if (modulePath == null) continue;
            File moduleFile = modulePath.toFile();
            File file = new File(moduleFile, "src/test/resources");
            if (file.exists()) {
                results.add(file.getAbsolutePath());
            }
            if (!(file = new File(moduleFile, "src/test.slow/resources")).exists()) continue;
            results.add(file.getAbsolutePath());
        }
        testSearchPaths = results;
        return testSearchPaths;
    }

    static {
        classLoader = ResourceManager.class.getClassLoader();
        DEFAULT_ICON = ResourceManager.loadDefaultIcon();
    }
}

