/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.context;

import docking.ComponentProvider;
import ghidra.app.context.ProgramActionContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;

public class ProgramLocationActionContext
extends ProgramActionContext {
    private final ProgramLocation location;
    private final ProgramSelection selection;
    private final ProgramSelection highlight;
    private CodeUnit cu;
    private boolean codeUnitInitialized = false;

    public ProgramLocationActionContext(ComponentProvider provider, Program program, ProgramLocation location, ProgramSelection selection, ProgramSelection highlight) {
        super(provider, program);
        this.location = location;
        this.selection = selection;
        this.highlight = highlight;
    }

    public ProgramLocation getLocation() {
        return this.location;
    }

    public ProgramSelection getSelection() {
        return this.selection == null ? new ProgramSelection() : this.selection;
    }

    public ProgramSelection getHighlight() {
        return this.highlight == null ? new ProgramSelection() : this.highlight;
    }

    public Address getAddress() {
        if (this.location != null) {
            return this.location.getAddress();
        }
        return null;
    }

    public CodeUnit getCodeUnit() {
        if (!this.codeUnitInitialized) {
            Address addr = this.getAddress();
            if (addr != null) {
                this.cu = this.program.getListing().getCodeUnitContaining(addr);
                if (this.cu instanceof Data && this.location.getComponentPath() != null) {
                    Data data = (Data)this.cu;
                    this.cu = data.getComponent(this.location.getComponentPath());
                }
            }
            this.codeUnitInitialized = true;
        }
        return this.cu;
    }

    public boolean hasSelection() {
        return this.selection != null && !this.selection.isEmpty();
    }

    public boolean hasHighlight() {
        return this.highlight != null && !this.highlight.isEmpty();
    }
}

