/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clipboard;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.dnd.GenericDataFlavor;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.internal.EmptyLayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import generic.text.TextLayoutGraphics;
import ghidra.app.cmd.comments.CodeUnitInfoPasteCmd;
import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.function.SetVariableNameCmd;
import ghidra.app.cmd.label.RenameLabelCmd;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.services.ClipboardContentProviderService;
import ghidra.app.util.ByteCopier;
import ghidra.app.util.ClipboardType;
import ghidra.app.util.CodeUnitInfo;
import ghidra.app.util.CodeUnitInfoTransferable;
import ghidra.app.util.CommentTypes;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.program.util.VariableLocation;
import ghidra.util.Msg;
import ghidra.util.task.CancellableIterator;
import ghidra.util.task.TaskMonitor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import util.CollectionUtils;

public class CodeBrowserClipboardProvider
extends ByteCopier
implements ClipboardContentProviderService {
    protected static final PaintContext PAINT_CONTEXT = new PaintContext();
    private static int[] COMMENT_TYPES = CommentTypes.getTypes();
    public static final ClipboardType ADDRESS_TEXT_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Address");
    public static final ClipboardType ADDRESS_TEXT_WITH_OFFSET_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Address w/ Offset");
    public static final ClipboardType CODE_TEXT_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Formatted Code");
    public static final ClipboardType LABELS_COMMENTS_TYPE = new ClipboardType(CodeUnitInfoTransferable.localDataTypeFlavor, "Labels and Comments");
    public static final ClipboardType LABELS_TYPE = new ClipboardType(CodeUnitInfoTransferable.localDataTypeFlavor, "Labels");
    public static final ClipboardType COMMENTS_TYPE = new ClipboardType(CodeUnitInfoTransferable.localDataTypeFlavor, "Comments");
    private static final List<ClipboardType> COPY_TYPES = CodeBrowserClipboardProvider.createCopyTypesList();
    protected boolean copyFromSelectionEnabled;
    protected ComponentProvider componentProvider;
    private ListingModel model;
    private Set<ChangeListener> listeners = new CopyOnWriteArraySet<ChangeListener>();
    private String stringContent;

    private static List<ClipboardType> createCopyTypesList() {
        LinkedList<ClipboardType> list = new LinkedList<ClipboardType>();
        list.add(CODE_TEXT_TYPE);
        list.add(LABELS_COMMENTS_TYPE);
        list.add(LABELS_TYPE);
        list.add(COMMENTS_TYPE);
        list.add(BYTE_STRING_TYPE);
        list.add(BYTE_STRING_NO_SPACE_TYPE);
        list.add(PYTHON_BYTE_STRING_TYPE);
        list.add(PYTHON_LIST_TYPE);
        list.add(CPP_BYTE_ARRAY_TYPE);
        list.add(ADDRESS_TEXT_TYPE);
        list.add(ADDRESS_TEXT_WITH_OFFSET_TYPE);
        return list;
    }

    public CodeBrowserClipboardProvider(PluginTool tool, ComponentProvider codeViewerProvider) {
        this.tool = tool;
        this.componentProvider = codeViewerProvider;
        PAINT_CONTEXT.setTextCopying(true);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    @Override
    public Transferable copy(TaskMonitor monitor) {
        if (this.stringContent != null) {
            return CodeBrowserClipboardProvider.createStringTransferable(this.stringContent);
        }
        if (this.copyFromSelectionEnabled) {
            return this.copyCode(monitor);
        }
        return this.copyFromCurrentLocation();
    }

    @Override
    public boolean paste(Transferable pasteData) {
        try {
            DataFlavor[] flavors;
            for (DataFlavor element : flavors = pasteData.getTransferDataFlavors()) {
                if (element.equals(LABELS_COMMENTS_TYPE.getFlavor())) {
                    return this.pasteLabelsComments(pasteData, true, true);
                }
                if (element.equals(LABELS_TYPE.getFlavor())) {
                    return this.pasteLabelsComments(pasteData, true, false);
                }
                if (element.equals(COMMENTS_TYPE.getFlavor())) {
                    return this.pasteLabelsComments(pasteData, false, true);
                }
                if (element.equals(LabelStringTransferable.labelStringFlavor)) {
                    return this.pasteLabelString(pasteData);
                }
                if (!element.equals(NonLabelStringTransferable.nonLabelStringFlavor)) continue;
                return this.pasteNonLabelString(pasteData);
            }
            if (super.pasteBytes(pasteData)) {
                return true;
            }
            this.tool.setStatusInfo("Paste failed: unsupported data type", true);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.error((Object)this, (Object)("Unexpected Exception: " + msg), (Throwable)e);
            this.tool.setStatusInfo("Paste failed: " + msg, true);
        }
        return false;
    }

    @Override
    public List<ClipboardType> getCurrentCopyTypes() {
        return COPY_TYPES;
    }

    @Override
    public Transferable copySpecial(ClipboardType copyType, TaskMonitor monitor) {
        if (copyType == ADDRESS_TEXT_TYPE) {
            return this.copyAddress(monitor);
        }
        if (copyType == ADDRESS_TEXT_WITH_OFFSET_TYPE) {
            return this.copySymbolString(monitor);
        }
        if (copyType == CODE_TEXT_TYPE) {
            return this.copyCode(monitor);
        }
        if (copyType == LABELS_COMMENTS_TYPE) {
            return this.copyLabelsComments(true, true, monitor);
        }
        if (copyType == LABELS_TYPE) {
            return this.copyLabelsComments(true, false, monitor);
        }
        if (copyType == COMMENTS_TYPE) {
            return this.copyLabelsComments(false, true, monitor);
        }
        return this.copyBytes(copyType, monitor);
    }

    public void setStringContent(String text) {
        this.stringContent = text;
    }

    public String getStringContent() {
        return this.stringContent;
    }

    public void setLocation(ProgramLocation location) {
        this.currentLocation = location;
    }

    public void setSelection(ProgramSelection selection) {
        this.currentSelection = selection;
        this.copyFromSelectionEnabled = selection != null && !selection.isEmpty();
        this.notifyStateChanged();
    }

    public void setProgram(Program p) {
        this.currentProgram = p;
        this.currentLocation = null;
        this.currentSelection = null;
    }

    public void setListingLayoutModel(ListingModel model) {
        this.model = model;
    }

    protected ListingModel getListingModel() {
        return this.model;
    }

    private Transferable copyFromCurrentLocation() {
        Address address = this.currentLocation.getAddress();
        if (this.currentLocation instanceof AddressFieldLocation) {
            return new NonLabelStringTransferable(address.toString());
        }
        if (this.currentLocation instanceof LabelFieldLocation) {
            LabelFieldLocation labelFieldLocation = (LabelFieldLocation)this.currentLocation;
            return new LabelStringTransferable(labelFieldLocation.getName());
        }
        if (this.currentLocation instanceof FunctionNameFieldLocation) {
            FunctionNameFieldLocation functionNameLocation = (FunctionNameFieldLocation)this.currentLocation;
            return new LabelStringTransferable(functionNameLocation.getFunctionName());
        }
        if (this.currentLocation instanceof CommentFieldLocation) {
            CommentFieldLocation commentFieldLocation = (CommentFieldLocation)this.currentLocation;
            String[] comment = commentFieldLocation.getComment();
            return new NonLabelStringTransferable(comment);
        }
        if (this.currentLocation instanceof BytesFieldLocation) {
            return this.copyByteString(address);
        }
        if (this.currentLocation instanceof OperandFieldLocation) {
            return this.getOperandLocationTransferable((OperandFieldLocation)this.currentLocation);
        }
        if (this.currentLocation instanceof MnemonicFieldLocation) {
            MnemonicFieldLocation location = (MnemonicFieldLocation)this.currentLocation;
            return new NonLabelStringTransferable(location.getMnemonic());
        }
        if (this.currentLocation instanceof VariableLocation) {
            VariableLocation variableLocation = (VariableLocation)this.currentLocation;
            Variable variable = variableLocation.getVariable();
            return new LabelStringTransferable(variable.getName());
        }
        return null;
    }

    private Transferable getOperandLocationTransferable(OperandFieldLocation location) {
        int opIndex = location.getOperandIndex();
        Listing listing = this.currentProgram.getListing();
        Instruction instruction = listing.getInstructionAt(location.getAddress());
        if (instruction == null) {
            return new NonLabelStringTransferable(location.getOperandRepresentation());
        }
        Reference reference = instruction.getPrimaryReference(opIndex);
        if (reference == null) {
            return new NonLabelStringTransferable(location.getOperandRepresentation());
        }
        Variable variable = this.currentProgram.getReferenceManager().getReferencedVariable(reference);
        if (variable != null) {
            return new LabelStringTransferable(variable.getName());
        }
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        Symbol symbol = symbolTable.getSymbol(reference);
        if (symbol != null) {
            return new LabelStringTransferable(symbol.getName());
        }
        return new NonLabelStringTransferable(location.getOperandRepresentation());
    }

    private Transferable copyAddress(TaskMonitor monitor) {
        AddressSetView addrs = this.getSelectedAddresses();
        AddressIterator iterable = addrs.getAddresses(true);
        CancellableIterator it = new CancellableIterator(iterable.iterator(), monitor);
        return CodeBrowserClipboardProvider.createStringTransferable(StringUtils.join((Iterator)it, (String)"\n"));
    }

    private Transferable copySymbolString(TaskMonitor monitor) {
        Listing listing = this.currentProgram.getListing();
        ArrayList<String> strings = new ArrayList<String>();
        CodeUnitIterator codeUnits = listing.getCodeUnits(this.getSelectedAddresses(), true);
        while (codeUnits.hasNext() && !monitor.isCancelled()) {
            CodeUnit cu = codeUnits.next();
            Address addr = cu.getAddress();
            Function function = listing.getFunctionContaining(addr);
            if (function == null) {
                strings.add(addr.toString());
                continue;
            }
            String name = function.getName(true);
            Address entry = function.getEntryPoint();
            int delta = addr.compareTo((Object)entry);
            if (delta == 0) {
                strings.add(name);
                continue;
            }
            if (delta > 0) {
                strings.add(String.format("%s + %#x", name, addr.subtract(entry)));
                continue;
            }
            strings.add(String.format("%s - %#x", name, entry.subtract(addr)));
        }
        return CodeBrowserClipboardProvider.createStringTransferable(StringUtils.join(strings, (String)"\n"));
    }

    protected Transferable copyCode(TaskMonitor monitor) {
        AddressSetView addressSet = this.getSelectedAddresses();
        ListingModel listingModel = this.getListingModel();
        TextLayoutGraphics g = new TextLayoutGraphics();
        EmptyLayoutBackgroundColorManager colorMap = new EmptyLayoutBackgroundColorManager(PAINT_CONTEXT.getBackground());
        Rectangle rect = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE);
        AddressRangeIterator ranges = addressSet.getAddressRanges();
        while (ranges.hasNext() && !monitor.isCancelled()) {
            AddressRange curRange = (AddressRange)ranges.next();
            Address address = curRange.getMinAddress();
            Address maxAddress = curRange.getMaxAddress();
            while (address != null && address.compareTo((Object)maxAddress) <= 0 && !monitor.isCancelled()) {
                Layout layout = listingModel.getLayout(address, false);
                if (layout != null) {
                    layout.paint(null, (Graphics)g, PAINT_CONTEXT, rect, (LayoutBackgroundColorManager)colorMap, null);
                    g.flush();
                }
                address = listingModel.getAddressAfter(address);
            }
        }
        return CodeBrowserClipboardProvider.createStringTransferable(g.getBuffer());
    }

    private Transferable copyByteString(Address address) {
        AddressSet set = new AddressSet(address);
        return CodeBrowserClipboardProvider.createStringTransferable(this.copyBytesAsString((AddressSetView)set, false, TaskMonitor.DUMMY));
    }

    private CodeUnitInfoTransferable copyLabelsComments(boolean copyLabels, boolean copyComments, TaskMonitor monitor) {
        AddressSetView addressSet = this.getSelectedAddresses();
        ArrayList<CodeUnitInfo> list = new ArrayList<CodeUnitInfo>();
        Address startAddr = addressSet.getMinAddress();
        this.getCodeUnitInfo(addressSet, startAddr, list, copyLabels, copyComments, monitor);
        return new CodeUnitInfoTransferable(list);
    }

    private boolean pasteLabelsComments(Transferable pasteData, boolean pasteLabels, boolean pasteComments) {
        try {
            List list = (List)pasteData.getTransferData(CodeUnitInfoTransferable.localDataTypeFlavor);
            List infos = CollectionUtils.asList((List)list, CodeUnitInfo.class);
            CodeUnitInfoPasteCmd cmd = new CodeUnitInfoPasteCmd(this.currentLocation.getAddress(), infos, pasteLabels, pasteComments);
            return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            this.tool.setStatusInfo("Paste failed: " + msg, true);
            return false;
        }
    }

    private boolean pasteLabelString(Transferable pasteData) throws UnsupportedFlavorException, IOException {
        String labelName = (String)pasteData.getTransferData(LabelStringTransferable.labelStringFlavor);
        Address address = this.currentLocation.getAddress();
        if (this.currentLocation instanceof LabelFieldLocation) {
            LabelFieldLocation labelFieldLocation = (LabelFieldLocation)this.currentLocation;
            String oldName = labelFieldLocation.getName();
            RenameLabelCmd cmd = new RenameLabelCmd(address, oldName, labelName, SourceType.USER_DEFINED);
            return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
        if (this.currentLocation instanceof FunctionNameFieldLocation) {
            FunctionNameFieldLocation functionNameLocation = (FunctionNameFieldLocation)this.currentLocation;
            String oldName = functionNameLocation.getFunctionName();
            RenameLabelCmd cmd = new RenameLabelCmd(address, oldName, labelName, SourceType.USER_DEFINED);
            return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
        if (this.currentLocation instanceof OperandFieldLocation) {
            return this.pasteOperandField((OperandFieldLocation)this.currentLocation, labelName);
        }
        return this.maybePasteNonLabelString(labelName);
    }

    private boolean pasteOperandField(OperandFieldLocation operandLocation, String labelName) {
        int opIndex = operandLocation.getOperandIndex();
        Listing listing = this.currentProgram.getListing();
        Instruction instruction = listing.getInstructionAt(operandLocation.getAddress());
        if (instruction == null) {
            return false;
        }
        Reference reference = instruction.getPrimaryReference(opIndex);
        if (reference == null) {
            return false;
        }
        Variable var = this.currentProgram.getReferenceManager().getReferencedVariable(reference);
        if (var != null) {
            SetVariableNameCmd cmd = new SetVariableNameCmd(var, labelName, SourceType.USER_DEFINED);
            return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        Symbol symbol = symbolTable.getSymbol(reference);
        if (symbol instanceof CodeSymbol || symbol instanceof FunctionSymbol) {
            RenameLabelCmd cmd = new RenameLabelCmd(symbol, labelName, SourceType.USER_DEFINED);
            return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
        return this.maybePasteNonLabelString(labelName);
    }

    private boolean pasteNonLabelString(Transferable pasteData) throws UnsupportedFlavorException, IOException {
        String text = (String)pasteData.getTransferData(NonLabelStringTransferable.nonLabelStringFlavor);
        return this.maybePasteNonLabelString(text);
    }

    private boolean maybePasteNonLabelString(String string) {
        if (this.currentLocation instanceof CommentFieldLocation) {
            CommentFieldLocation commentFieldLocation = (CommentFieldLocation)this.currentLocation;
            Address address = commentFieldLocation.getAddress();
            int commentType = commentFieldLocation.getCommentType();
            SetCommentCmd cmd = new SetCommentCmd(address, commentType, string);
            return this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
        return false;
    }

    private void getCodeUnitInfo(AddressSetView set, Address startAddr, List<CodeUnitInfo> list, boolean copyLabels, boolean copyComments, TaskMonitor monitor) {
        HashMap<Address, CodeUnitInfo> map = new HashMap<Address, CodeUnitInfo>();
        if (copyLabels) {
            this.getFunctions(startAddr, set, list, map, monitor);
            this.getLabels(startAddr, set, list, map, monitor);
        }
        if (copyComments) {
            this.getComments(startAddr, set, list, map, monitor);
        }
    }

    private void getFunctions(Address startAddr, AddressSetView set, List<CodeUnitInfo> list, Map<Address, CodeUnitInfo> map, TaskMonitor monitor) {
        FunctionIterator it = this.currentProgram.getListing().getFunctions(set, true);
        while (it.hasNext() && !monitor.isCancelled()) {
            Function function = (Function)it.next();
            Address entry = function.getEntryPoint();
            CodeUnitInfo info = this.getInfoFromMap(list, map, entry, startAddr);
            info.setFunction(function);
        }
    }

    private void getComments(Address startAddr, AddressSetView set, List<CodeUnitInfo> list, Map<Address, CodeUnitInfo> map, TaskMonitor monitor) {
        Listing listing = this.currentProgram.getListing();
        CodeUnitIterator it = listing.getCodeUnitIterator("COMMENT__GHIDRA_", set, true);
        while (it.hasNext() && !monitor.isCancelled()) {
            CodeUnit cu = it.next();
            Address minAddress = cu.getMinAddress();
            CodeUnitInfo info = this.getInfoFromMap(list, map, minAddress, startAddr);
            this.setCommentInfo(cu, info);
        }
    }

    private void setCommentInfo(CodeUnit cu, CodeUnitInfo info) {
        for (int element : COMMENT_TYPES) {
            String[] comments = cu.getCommentAsArray(element);
            if (comments == null || comments.length <= 0) continue;
            info.setComment(element, comments);
        }
    }

    private void getLabels(Address startAddr, AddressSetView set, List<CodeUnitInfo> list, Map<Address, CodeUnitInfo> map, TaskMonitor monitor) {
        SymbolIterator it = this.currentProgram.getSymbolTable().getPrimarySymbolIterator(set, true);
        while (it.hasNext() && !monitor.isCancelled()) {
            Symbol symbol = it.next();
            Address minAddress = symbol.getAddress();
            Symbol[] symbols = this.currentProgram.getSymbolTable().getSymbols(minAddress);
            CodeUnitInfo info = this.getInfoFromMap(list, map, minAddress, startAddr);
            info.setSymbols(symbols);
        }
    }

    private CodeUnitInfo getInfoFromMap(List<CodeUnitInfo> list, Map<Address, CodeUnitInfo> map, Address minAddress, Address startAddr) {
        CodeUnitInfo info = map.get(minAddress);
        if (info == null) {
            long index = minAddress.subtract(startAddr);
            info = new CodeUnitInfo((int)index);
            map.put(minAddress, info);
            list.add(info);
        }
        return info;
    }

    @Override
    public boolean isValidContext(ActionContext context) {
        if (!(context instanceof CodeViewerActionContext)) {
            return false;
        }
        return context.getComponentProvider() == this.componentProvider;
    }

    @Override
    public ComponentProvider getComponentProvider() {
        return this.componentProvider;
    }

    @Override
    public boolean enableCopy() {
        return true;
    }

    @Override
    public boolean enableCopySpecial() {
        return true;
    }

    @Override
    public boolean canCopy() {
        return this.copyFromSelectionEnabled || this.stringContent != null || this.canCopyCurrentLocationWithNoSelection();
    }

    @Override
    public boolean canCopySpecial() {
        return this.currentLocation != null;
    }

    private boolean canCopyCurrentLocationWithNoSelection() {
        if (this.currentLocation instanceof AddressFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof LabelFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof FunctionNameFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof CommentFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof BytesFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof OperandFieldLocation) {
            return true;
        }
        if (this.currentLocation instanceof MnemonicFieldLocation) {
            return true;
        }
        return this.currentLocation instanceof VariableLocation;
    }

    @Override
    public boolean enablePaste() {
        return true;
    }

    @Override
    public boolean canPaste(DataFlavor[] availableFlavors) {
        if (availableFlavors != null) {
            for (DataFlavor flavor : availableFlavors) {
                if (flavor.equals(LABELS_COMMENTS_TYPE.getFlavor()) || flavor.equals(LABELS_TYPE.getFlavor()) || flavor.equals(COMMENTS_TYPE.getFlavor()) || flavor.equals(BYTE_STRING_TYPE.getFlavor()) || flavor.equals(LabelStringTransferable.labelStringFlavor) || flavor.equals(NonLabelStringTransferable.nonLabelStringFlavor)) {
                    return true;
                }
                if (!flavor.equals(DataFlavor.stringFlavor)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void lostOwnership(Transferable transferable) {
    }

    private static class LabelStringTransferable
    implements Transferable {
        public static final DataFlavor labelStringFlavor = new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Local label as string object");
        private final DataFlavor[] flavors = new DataFlavor[]{labelStringFlavor, DataFlavor.stringFlavor};
        private final List<DataFlavor> flavorList = Arrays.asList(this.flavors);
        private String symbolName;

        LabelStringTransferable(String name) {
            this.symbolName = name;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(labelStringFlavor)) {
                return this.symbolName;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.symbolName;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavorList.contains(flavor);
        }
    }

    private static class NonLabelStringTransferable
    implements Transferable {
        public static final DataFlavor nonLabelStringFlavor = new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Local non-label as string object");
        private final DataFlavor[] flavors = new DataFlavor[]{nonLabelStringFlavor, DataFlavor.stringFlavor};
        private final List<DataFlavor> flavorList = Arrays.asList(this.flavors);
        private String text;

        NonLabelStringTransferable(String[] text) {
            StringBuilder buildy = new StringBuilder();
            for (String string : text) {
                if (buildy.length() > 0) {
                    buildy.append('\n');
                }
                buildy.append(string);
            }
            this.text = buildy.toString();
        }

        NonLabelStringTransferable(String text) {
            this.text = text;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(nonLabelStringFlavor)) {
                return this.text;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.text;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavorList.contains(flavor);
        }
    }
}

