/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.eclipse;

import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;
import java.io.File;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Eclipse Integration Options", description="Options Eclipse Integration")
public class EclipseIntegrationOptionsPlugin
extends Plugin
implements ApplicationLevelOnlyPlugin {
    public static final String PLUGIN_OPTIONS_NAME = "Eclipse Integration";
    public static final String ECLIPSE_INSTALL_DIR_OPTION = "Eclipse Installation Directory";
    private static final String ECLIPSE_INSTALL_DIR_DESC = "Path to Eclipse installation directory";
    private static final File ECLIPSE_INSTALL_DIR_DEFAULT = null;
    public static final String ECLIPSE_WORKSPACE_DIR_OPTION = "Eclipse Workspace Directory (optional)";
    private static final String ECLIPSE_WORKSPACE_DIR_DESC = "Optional path to Eclipse workspace directory.  If defined and the directory does not exist, Eclipse will create it.  If undefined, Eclipse will be responsible for selecting the workspace directory.";
    private static final File ECLIPSE_WORKSPACE_DIR_DEFAULT = null;
    public static final String SCRIPT_EDITOR_PORT_OPTION = "Script Editor Port";
    private static final String SCRIPT_EDITOR_PORT_DESC = "The port number used to communicate with Eclipse for script editing.  It must match the port number set in the Eclipse GhidraDev plugin preference page in order for them to communicate.";
    private static final int SCRIPT_EDITOR_PORT_DEFAULT = 12321;
    public static final String SYMBOL_LOOKUP_PORT_OPTION = "Symbol Lookup Port";
    private static final String SYMBOL_LOOKUP_PORT_DESC = "The port number used to communicate with Eclipse for script editing.  It must match the port number set in the Eclipse GhidraDev plugin preference page in order for them to communicate.";
    private static final int SYMBOL_LOOKUP_PORT_DEFAULT = 12322;
    public static final String AUTO_GHIDRADEV_INSTALL_OPTION = "Automatically install GhidraDev";
    private static final String AUTO_GHIDRADEV_INSTALLATION_DESC = "Automatically install the GhidraDev plugin into the \"dropins\" directory of the specified Eclipse if it has not yet been installed.";
    private static final boolean AUTO_GHIDRADEV_INSTALL_DEFAULT = true;

    public EclipseIntegrationOptionsPlugin(PluginTool tool) {
        super(tool);
    }

    public void init() {
        super.init();
        ToolOptions options = this.tool.getOptions(PLUGIN_OPTIONS_NAME);
        options.registerOption(ECLIPSE_INSTALL_DIR_OPTION, OptionType.FILE_TYPE, (Object)ECLIPSE_INSTALL_DIR_DEFAULT, null, ECLIPSE_INSTALL_DIR_DESC);
        options.registerOption(ECLIPSE_WORKSPACE_DIR_OPTION, OptionType.FILE_TYPE, (Object)ECLIPSE_WORKSPACE_DIR_DEFAULT, null, ECLIPSE_WORKSPACE_DIR_DESC);
        options.registerOption(SCRIPT_EDITOR_PORT_OPTION, (Object)12321, null, "The port number used to communicate with Eclipse for script editing.  It must match the port number set in the Eclipse GhidraDev plugin preference page in order for them to communicate.");
        options.registerOption(SYMBOL_LOOKUP_PORT_OPTION, (Object)12322, null, "The port number used to communicate with Eclipse for script editing.  It must match the port number set in the Eclipse GhidraDev plugin preference page in order for them to communicate.");
        options.registerOption(AUTO_GHIDRADEV_INSTALL_OPTION, (Object)true, null, AUTO_GHIDRADEV_INSTALLATION_DESC);
        options.setOptionsHelpLocation(new HelpLocation("EclipseIntegration", "EclipseIntegration"));
    }
}

