/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.types.GoInterfaceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.PlateComment;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@PlateComment
@StructureMapping(structureName="runtime.itab")
public class GoItab
implements StructureMarkup<GoItab> {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoItab> context;
    @FieldMapping
    @MarkupReference(value="interfaceType")
    long inter;
    @FieldMapping
    @MarkupReference(value="type")
    long _type;
    @FieldMapping
    long fun;

    @Markup
    public GoInterfaceType getInterfaceType() throws IOException {
        return this.programContext.readStructure(GoInterfaceType.class, this.inter);
    }

    @Markup
    public GoType getType() throws IOException {
        return this.programContext.getGoType(this._type);
    }

    public long getFuncCount() throws IOException {
        GoInterfaceType iface = this.getInterfaceType();
        GoSlice methods = iface.getMethodsSlice();
        return Math.max(1L, methods.getLen());
    }

    public GoSlice getFunSlice() throws IOException {
        long funcCount = this.getFuncCount();
        long funOffset = this.context.getStructureEnd() - (long)this.programContext.getPtrSize();
        return new GoSlice(funOffset, funcCount, funcCount, this.programContext);
    }

    @Override
    public String getStructureName() throws IOException {
        return this.getInterfaceType().getStructureName();
    }

    @Override
    public StructureContext<GoItab> getStructureContext() {
        return this.context;
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException {
        GoSlice funSlice = this.getFunSlice();
        List<Address> funcAddrs = Arrays.stream(funSlice.readUIntList(this.programContext.getPtrSize())).mapToObj(offset -> this.programContext.getCodeAddress(offset)).collect(Collectors.toList());
        funSlice.markupElementReferences(this.programContext.getPtrSize(), funcAddrs, session);
        GoSlice extraFunSlice = funSlice.getSubSlice(1L, funSlice.getLen() - 1L, this.programContext.getPtrSize());
        extraFunSlice.markupArray(this.getStructureName() + "_extra_itab_functions", (DataType)null, true, session);
    }

    public String toString() {
        try {
            String s = "itab for " + this.getStructureName();
            GoInterfaceType ifaceType = this.getInterfaceType();
            String methodListString = ifaceType.getMethodListString();
            if (!methodListString.isEmpty()) {
                s = s + "\n// Methods\n" + methodListString;
            }
            return s;
        }
        catch (IOException e) {
            return super.toString();
        }
    }
}

