/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoString;
import ghidra.app.util.bin.format.golang.rtti.types.GoBaseType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureReader;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName="runtime._type")
public class GoPlainType
extends GoType
implements StructureReader<GoType> {
    @Override
    public void readStructure() throws IOException {
        this.typ = this.context.getDataTypeMapper().readStructure(GoBaseType.class, this.context.getReader());
    }

    @Override
    public DataType recoverDataType() throws IOException {
        BooleanDataType dt;
        DataTypeManager dtm = this.programContext.getDTM();
        switch (this.typ.getKind()) {
            case Bool: {
                BooleanDataType booleanDataType = BooleanDataType.dataType;
                break;
            }
            case Float32: {
                BooleanDataType booleanDataType = AbstractFloatDataType.getFloatDataType((int)4, null);
                break;
            }
            case Float64: {
                BooleanDataType booleanDataType = AbstractFloatDataType.getFloatDataType((int)8, null);
                break;
            }
            case Int: {
                BooleanDataType booleanDataType = AbstractIntegerDataType.getSignedDataType((int)this.programContext.getPtrSize(), (DataTypeManager)dtm);
                break;
            }
            case Int8: {
                BooleanDataType booleanDataType = AbstractIntegerDataType.getSignedDataType((int)1, null);
                break;
            }
            case Int16: {
                BooleanDataType booleanDataType = AbstractIntegerDataType.getSignedDataType((int)2, null);
                break;
            }
            case Int32: {
                BooleanDataType booleanDataType = AbstractIntegerDataType.getSignedDataType((int)4, null);
                break;
            }
            case Int64: {
                BooleanDataType booleanDataType = AbstractIntegerDataType.getSignedDataType((int)8, null);
                break;
            }
            case Uint: {
                BooleanDataType booleanDataType = AbstractIntegerDataType.getUnsignedDataType((int)this.programContext.getPtrSize(), (DataTypeManager)dtm);
                break;
            }
            case Uint8: {
                BooleanDataType booleanDataType = AbstractIntegerDataType.getUnsignedDataType((int)1, null);
                break;
            }
            case Uint16: {
                BooleanDataType booleanDataType = AbstractIntegerDataType.getUnsignedDataType((int)2, null);
                break;
            }
            case Uint32: {
                BooleanDataType booleanDataType = AbstractIntegerDataType.getUnsignedDataType((int)4, null);
                break;
            }
            case Uint64: {
                BooleanDataType booleanDataType = AbstractIntegerDataType.getUnsignedDataType((int)8, null);
                break;
            }
            case Uintptr: {
                BooleanDataType booleanDataType = AbstractIntegerDataType.getUnsignedDataType((int)this.programContext.getPtrSize(), (DataTypeManager)dtm);
                break;
            }
            case String: {
                BooleanDataType booleanDataType = this.programContext.getStructureDataType(GoString.class);
                break;
            }
            case UnsafePointer: {
                BooleanDataType booleanDataType = dtm.getPointer(null);
                break;
            }
            default: {
                BooleanDataType booleanDataType = dt = null;
            }
        }
        if (dt == null) {
            dt = super.recoverDataType();
        }
        String name = this.typ.getNameString();
        if (!dt.getName().equalsIgnoreCase(name)) {
            dt = new TypedefDataType(this.programContext.getRecoveredTypesCp(), name, (DataType)dt, dtm);
        }
        if ((long)dt.getLength() != this.typ.getSize()) {
            Msg.warn((Object)this, (Object)"Recovered golang data type size mismatch: %s, %d != %d".formatted(this.getDebugId(), this.typ.getSize(), dt.getLength()));
        }
        return dt;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        return super.discoverGoTypes(discoveredTypes);
    }
}

